/*-----------------------------------------------------------------------*/
/*                                  TIGA                                 */
/*          Copyright (c) 1990 Texas Instruments Incorporated.           */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*  function name:  get_modeinfo					 */
/*									 */
/*  synopsis:	    short get_modeinfo(index, modeinfo) 		 */
/*		    short index;	   graphics mode number 	 */
/*		    MODEINFO *modeinfo;    pointer to MODEINFO structure */
/*									 */
/*  description:    Retrieve parameters characterizing a graphics mode	 */
/*		    identified by its assigned mode number, as specified */
/*		    in the first argument.  The function retrieves the	 */
/*		    information and loads it into the MODEINFO data	 */
/*		    structure pointed to by the second argument.	 */
/*									 */
/*  Note that the TMS340 Graphics Library implementation of this	 */
/*  function necessarily differs from that of TIGA.  In TIGA, the	 */
/*  mode information is maintained on the host processor, whereas the	 */
/*  library must maintain the mode information on the GSP.		 */
/*-----------------------------------------------------------------------*/
/*   03/16/90...Original version written..................J.R. Van Aken  */
/*-----------------------------------------------------------------------*/

/* Names of GSP I/O registers and B-file registers */
#include <gsptypes.h>		 /* define MODEINFO struct */
#include "oem.h"                 /* define SETUP struct */

/* Declare external variables, both of which are defined in oemdata.c. */
extern short num_modes;
extern SETUP mode_setup[];


short get_modeinfo(index, modeinfo)
short index;
MODEINFO *modeinfo;
{
    if (index >= num_modes || index < 0)
	return (0);	     /* illegal mode number */
    *modeinfo = mode_setup[index].Mode_Info;
    return (!0);	     /* mode info successfully retrieved */
}

