;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1989-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   void set_dpitch(pitch)                                                ;
;   long  pitch;        pitch to set in the DPITCH and CONVDP registers   ;
;                                                                         ;
;   Notes:- A8 is destroyed                                               ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  11/24/89...Original Version...........................Graham Short     ;
;-------------------------------------------------------------------------;
;
;       INCLUDE FILES
        .include gspreg.inc  
        .include oem.inc
        .mlib    gspmac.lib
;
;       GLOBALS
        .globl  _set_dpitch
;
;       ENTRY POINT
_set_dpitch:
        Popc    A8              ; Pop pitch argument from the C stack
        move    A8,DPTCH        ; Initialize the DPTCH register
;
        .if     GSP_34010       ; 34010 code (DPTCH must be a power of 2)
        lmo     A8,A8
        setf    16,0,0
        move    A8,@CONVDP,0    ; Put lmo (DPTCH) into CONVDP
        .endif
;
        .if     GSP_34020       ; 34020 code (DPTCH can be arbitrary)
        setcdp
        .endif
;
        rets    2
