/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test the draw_point function.  Draw a variety of lissajous patterns
 *   composed of dots.	The patterns are created by driving the x and y
 *   coordinates of the dots with digital sinusoidal generators running
 *   at slightly different frequencies.  The fixed-point numbers used in
 *   the sinusoid calculations are 32-bit values with 16-bit fractions.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/26/90...Original version written...................J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

#define N	  6	  /* angular increment = 1>>N radians */
#define M	  5	  /* log2(# of lines in grid pattern */
#define TWOPI	  411775	   /* fixed point 2*PI */

static CONFIG cfg;


main()
{
    int hres, vres, x, y, x0, y0, ux, vx, uy, vy, i, j, k, color;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(0);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Draw various lissajous patterns of dots. */
    for (;;)
	for (k = 1; k < 8; k++)
	    for (j = 2, color = -1; j != 0; j--, color++) {
		x0 = (hres/2 << 16) + (1 << 15);
		vx = x0 - (4 << 16);
		ux = 0;
		y0 = (vres/2 << 16) + (1 << 15);
		vy = y0 - (4 << 16);
		uy = 0;
		set_fcolor(color);
		for (i = (TWOPI<<N)>>16+1-k; i >= 0; i--) {
		    x = (x0 + vx) >> 16;
		    y = (y0 + vy) >> 16;
		    draw_point(x, y);
		    ux -= vx >> N;
		    vx += ux >> N;
		    uy -= (vy >> N) + (vy >> N+k);
		    vy += (uy >> N) + (uy >> N+k);
		}
		for (i = 30; i != 0; i--)
		    wait_scan(vres);
	    }
}

