/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *     Test the encode_rect and decode_rect functions.	Draw a picture in
 *     the upper left corner of the screen.  Capture the picture in
 *     compressed form using the encode_rect function.	Copy the picture
 *     to various positions on the lower right portion of the screen
 *     using the decode_rect function.
 *----------------------------------------------------------------------
 * Revision History:
 *   08/19/87...Original version written...................J.R. Van Aken
 *   04/18/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	      0       /* default graphics mode */
#endif

#define  NCOLORS      9       /* number of colors used */
#define  MAXSIZE      8192    /* max bytes used to store picture */

#define  BLACK	      0       /* symbolic color names */
#define  CLOUDWHITE   1
#define  SEABLUE      2
#define  SKYBLUE      3
#define  BOATRED      4
#define  SAILWHITE    5
#define  FRAMEBROWN   6
#define  SUNYELLOW    7

typedef struct { short row[16]; } PATN16x16;

static CONFIG cfg;

/* Use these colors if display has at least 16 colors. */
static PALET palet[NCOLORS] = {
    { 0x00, 0x00, 0x00, 0x00 }, 	/*  0 = BLACK	      */
    { 0xDD, 0xEE, 0xFF, 0x88 }, 	/*  1 = CLOUDWHITE    */
    { 0x33, 0x55, 0xFF, 0x77 }, 	/*  2 = SEABLUE       */
    { 0x33, 0xCC, 0xDD, 0xAA }, 	/*  3 = SKYBLUE       */
    { 0xAA, 0x55, 0x00, 0x99 }, 	/*  4 = BOATRED       */
    { 0xEE, 0xEE, 0xEE, 0xDD }, 	/*  5 = SAILWHITE     */
    { 0xCC, 0x77, 0x33, 0x44 }, 	/*  6 = FRAMEBROWN    */
    { 0xFF, 0xCC, 0x22, 0xEE }, 	/*  7 = SUNYELLOW     */
};

/* Use these area-fill patterns if display has less than 16 colors. */
static PATTERN patn = { 16, 16, 1, (PTR)0 };
PATN16x16 patnbits[] = {
      /* PATTERN #0 */
      { 0x1111, 0x2222, 0x4444, 0x8888, 0x1111, 0x2222, 0x4444, 0x8888,
        0x1111, 0x2222, 0x4444, 0x8888, 0x1111, 0x2222, 0x4444, 0x8888 },
      /* PATTERN #1 */
      { 0x8181, 0x4242, 0x2424, 0x1818, 0x8181, 0x4242, 0x2424, 0x1818,
        0x8181, 0x4242, 0x2424, 0x1818, 0x8181, 0x4242, 0x2424, 0x1818 },
      /* PATTERN #2 */
      { 0x1111, 0xAAAA, 0x4444, 0xAAAA, 0x1111, 0xAAAA, 0x4444, 0xAAAA,
        0x1111, 0xAAAA, 0x4444, 0xAAAA, 0x1111, 0xAAAA, 0x4444, 0xAAAA },
};

/* Define relative coordinates of sailboat hull and sails. */
static short  boat[] = { 35, 179,   102, 179,	87, 191,   56, 189 };
static short sail1[] = { 62, 128,   62, 175,	41, 175,   0, 0 };
static short sail2[] = { 65, 126,   102, 175,	65, 175,   0, 0 };

static char picture[MAXSIZE];	 /* buffer for compressed image */


main()
{
    int hres, vres, i, w, h, x, y, vx, vy;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(BLACK);
    set_palet(NCOLORS, 0, palet);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Draw picture in upper left corner of screen. */
    w = 68*hres/256;			   /* image width in pixels */
    h = 57*vres/256;			   /* image height in pixels */
    for (i = 0; i < 4; i++) {
	boat[2*i]    = w*boat[2*i]/256;    /* scale boat coordinates */
	boat[2*i+1]  = h*boat[2*i+1]/256;
	sail1[2*i]   = w*sail1[2*i]/256;
	sail1[2*i+1] = h*sail1[2*i+1]/256;
	sail2[2*i]   = w*sail2[2*i]/256;
	sail2[2*i+1] = h*sail2[2*i+1]/256;
    }
    if (cfg.mode.palet_size >= NCOLORS) {    /* if color display */
	set_fcolor(SKYBLUE);
	fill_rect(w, 163*h/256, 0, 0);
	set_fcolor(SEABLUE);
	fill_rect(w, h-163*h/256, 0, 163*h/256);
	set_fcolor(SUNYELLOW);
	fill_oval(53*w/256, 70*h/256, 150*w/256, 81*h/256);
    } else {				     /* if less than NCOLORS */
	set_colors(1, 0);
	patn.data = (PTR)&patnbits[0];
	set_patn(&patn);
	patnfill_rect(w, 163*h/256, 0, 0);
	patn.data = (PTR)&patnbits[1];
	set_patn(&patn);
	patnfill_rect(w, h-163*h/256, 0, 163*h/256);
	patn.data = (PTR)&patnbits[2];
	set_patn(&patn);
	patnfill_oval(53*w/256, 70*h/256, 150*w/256, 81*h/256);
    }
    set_fcolor(CLOUDWHITE);
    fill_oval(142*w/256, 28*h/256, 9*w/256, 63*h/256);
    fill_oval(102*w/256, 23*h/256, 78*w/256, 84*h/256);
    fill_oval(27*w/256, 14*h/256, 197*w/256, 63*h/256);
    fill_oval(22*w/256, 12*h/256, 215*w/256, 72*h/256);
    set_fcolor(BOATRED);
    fill_convex(4, boat);
    set_fcolor(SAILWHITE);
    fill_convex(3, sail1);
    fill_convex(3, sail2);
    set_fcolor(FRAMEBROWN);
    frame_rect(w, h, 0, 0, 5, 5);
    set_fcolor(SAILWHITE);
    draw_rect(w-1, h-1, 0, 0);

    /* Run encode picture. */
    encode_rect(w, h, 0, 0, picture, sizeof(picture), 0);

    /* Copy encoded picture to various parts of screen. */
    x = w;
    y = h;
    vx = 1 + hres/256;
    vy = 1 + vres/256;
    for (;;) {
	set_clip_rect(hres-2*w, vres-2*h, w, h);
	if (cpw(x += vx, h))
	    vx = -vx;
	if (cpw(w, y += vy))
	    vy = -vy;
	set_clip_rect(hres-w, vres-h, w, h);
	decode_rect(x, y, picture);
    }
}

