/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test draw_oval function.  Draw ellipses of various shapes,
 *   including very small ellipses, very large ellipses, and long,
 *   skinny ellipses.
 *----------------------------------------------------------------------
 * Revision History:
 *   07/02/87...Original version written...................J.R. Van Aken
 *   04/12/90...Modified for general portability...........JRV
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "colors.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

static CONFIG cfg;


static delay(n)
int n;
{
     for ( ; n; n--)
	 wait_scan(cfg.mode.disp_hres);
}


main()
{
    int hres, vres, w, h, x, y, color;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Draw ellipses of various sizes and shapes. */
    for (;;) {
	/* Fill screen with array of ellipses of increasing size. */
	clear_screen(BLACK);
	for (w = 0, x = 4; x < hres; w++, x += w+3)
	     for (h = 0, y = 4; y < vres; h++, y += h+3)  {
		 set_fcolor(RED);
		 draw_rect(w, h, x, y);
		 set_fcolor(WHITE);
		 draw_oval(w, h, x, y);
	     }
	delay(90);

	/* Draw tall, skinny ellipses. */
	set_fcolor(WHITE);
	clear_screen(BLACK);
	set_ppop(10);  /* xor */
	for (w = x = y = 0, h = vres-1; x < hres; x += w+3, w++)
	    draw_oval(w, h, x, y);
	delay(60);

	/* Fill tall, skinny ellipses with color. */
	set_ppop(0);  /* replace */
	for (w = x = y = 0, h = vres-1; x < hres; x += w+3, w++) {
	    set_fcolor(BLUE);
	    fill_rect(w+1, h+1, x, y);
	    set_fcolor(RED);
	    fill_oval(w+1, h+1, x, y);
	    set_fcolor(WHITE);
	    draw_oval(w, h, x, y);
	}
	delay(60);

	/* Draw long, flat ellipses. */
	set_fcolor(WHITE);
	clear_screen(BLACK);
	set_ppop(10);  /* xor */
	for (w = hres-1, h = x = y = 0; y < vres; y += h+3, h++)
	    draw_oval(w, h, x, y);
	delay(60);

	/* Fill long, flat ellipses with color. */
	set_ppop(0);  /* replace */
	for (w = hres-1, h = x = y = 0; y < vres; y += h+3, h++) {
	    set_fcolor(BLUE);
	    fill_rect(w+1, h+1, x, y);
	    set_fcolor(RED);
	    fill_oval(w+1, h+1, x, y);
	    set_fcolor(WHITE);
	    draw_oval(w, h, x, y);
	}
	delay(60);

	/* Draw concentric ellipses outward from center of screen. */
	clear_screen(BLACK);
	w = h = 0;
	x = hres/2;
	y = vres/2;
	color = 15;
	for ( ; h < 3*vres/2; w += 10, h += 6, x -= 5, y -= 3) {
	    draw_oval(w, h, x, y);
	    set_fcolor(color);
	    if (!(--color))
		color = 15;
	}
	delay(60);

	/* Draw concentric ellipses centered at top left corner. */
	clear_screen(BLACK);
	x = y = 1;
	for (w = h = 0; h < 3*vres; w += 16, h += 10, x -= 8, y -= 5) {
	    draw_oval(w, h, x, y);
	    set_fcolor(color);
	    if (!(--color))
		color = 15;
	}
	delay(60);

	/* Draw concentric ellipses centered at bottom right corner. */
	clear_screen(BLACK);
	w = h = 0;
	x = hres-2;
	y = vres-2;
	for ( ; w < 5*hres/2; w += 10, h += 16, x -= 5, y -= 8) {
	    draw_oval(w, h, x, y);
	    set_fcolor(color);
	    if (!(--color))
		color = 15;
	}
	delay(60);
    }
}

