/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test zoom_rect function.  Draw an image into a rectangular region
 *   of the screen that can be transferred to other parts of the screen
 *   by the zoom_rect function.  The zoom_rect routine reduces or
 *   enlarges the drawing to fit into arbitrary destination rectangles
 *   specified by the test program.  The MAX pixel processing operation
 *   is selected in order to better preserve features of the original
 *   drawing in cases in which the destination is smaller than the
 *   original.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/23/87...Original version written...................J.R. Van Aken
 *   04/12/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "colors.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

/* Trig values expressed as fixed-point values with 10-bit fractions */
#define  COS144   (-828)       /* cos(144 degrees) */
#define  SIN144   (602)        /* sin(144 degrees) */

typedef struct { short x, y; } POINT2D;

static CONFIG cfg;
static FONTINFO fontinfo;


main()
{
    static char buffer[1280];	  /* scan line buffer (big enuf?) */
    static POINT2D star[5+1];	  /* database for 5-point star */
    int hres, vres, i, w, h, xd, yd, wd, hd;
    long x, y, tmp;
    char *s;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    get_fontinfo(0, &fontinfo);  /* get system font parameters */

    /* Outline the source rectangle in red. */
    w = hres/6;        /* rectangle's center x & width w */
    h = vres/5;        /* rectangle's center y & height h */
    set_fcolor(RED);
    draw_rect(w+1, h+1, w/2-1, h/2-1);

    /* Define the vertices of a 5-pointed star. */
    x = 0;
    y = -h << 10-1;
    for (i = 0; i < 6; i++ ) {
	star[i].x = w + x/1024;
	star[i].y = h + y/1024;
	tmp = x;
	x = (COS144*x	- SIN144*y)/1024;
	y = (SIN144*tmp + COS144*y)/1024;
    }

    /* Draw the star. */
    if (cfg.mode.disp_psize >= 4) {    /* check for color display */
	set_fcolor(BLUE);
	fill_polygon(5, star);
    }
    set_fcolor(MAGENTA);
    set_pensize(1, 1);
    pen_polyline(5+1, star);

    /* Write "HELLO WORLD" on top of star. */
    if (cfg.mode.disp_psize >= 4) {    /* check for color display */
	set_fcolor(YELLOW);
	transp_on();
    }
    x = w;
    y = h;
    h = fontinfo.charhigh;
    s = "HELLO";
    w = text_width(s);
    text_out(x-w/2, y-h, s);
    s = "WORLD";
    w = text_width(s);
    text_out(x-w/2, y, s);

    /* Stretch or squeeze image to fit destination rectangles. */
    set_fcolor(WHITE);
    if (cfg.mode.disp_psize >= 4)      /* check for non-color display */
	set_ppop(20);	       /* MAX operation for color */
    else
	set_ppop(8);	       /* OR operation for B&W */
    w = x;
    h = y;
    x -= w/2;
    y -= h/2;

    wd = 4*w;
    hd = 3*h/4;
    xd = x + 5*w/4;
    yd = y + h/8;
    draw_rect(wd+2, hd+2, xd-1, yd-1);
    zoom_rect(w, h, x, y, wd, hd, xd, yd, buffer);  /* short & squat */

    wd = 3*w/4;
    hd = 3*h;
    xd = x + w/8;
    yd = y + 5*h/4;
    draw_rect(wd+2, hd+2, xd-1, yd-1);
    zoom_rect(w, h, x, y, wd, hd, xd, yd, buffer);  /* tall & skinny */

    wd = 3*w/8;
    hd = 5*h/8;
    xd = x + 3*w/2;
    yd = y + 3*h/2;
    draw_rect(wd+2, hd+2, xd-1, yd-1);
    zoom_rect(w, h, x, y, wd, hd, xd, yd, buffer);  /* small */

    wd = 7*w/8;
    hd = 9*h/8;
    xd = x + 5*w/4;
    yd = y + 5*h/2;
    draw_rect(wd+2, hd+2, xd-1, yd-1);
    zoom_rect(w, h, x, y, wd, hd, xd, yd, buffer);  /* almost same */

    wd = 11*w/4;
    hd = 3*h;
    xd = x + 5*w/2;
    yd = y + 5*h/4;
    draw_rect(wd+2, hd+2, xd-1, yd-1);
    zoom_rect(w, h, x, y, wd, hd, xd, yd, buffer);  /* big */
}

