/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager                                              */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  void get_palet(palet_ary)                                            */
/*                                                                       */
/*  These functions return the contents of the entire palette.           */
/*                                                                       */
/*  int get_palet_entry(index, r, g, b, i)                               */
/*                                                                       */
/*  This function return the contents of a single palette entry          */
/*  If an invalid index is requested the function returns 0.             */
/*-----------------------------------------------------------------------*/
/*  09/16/88  Original Version Written                      Graham Short */
/*  03/14/90  Fixed palette entries limit                   W.S.Egr      */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspglobs.h>
#include "oem.h"

#define FALSE  0
#define TRUE   1

get_palet(size,palet_ary)
unsigned short size;
PALET palet_ary[];
{
    register  int  i;

    /* if larger than current palet size, only return palet_size */
    if( size > config.mode.palet_size )
         size = config.mode.palet_size;
    for(i = 0; i < size; i++)
    {
         palet_ary[i].r = palet[i].r;
         palet_ary[i].g = palet[i].g;
         palet_ary[i].b = palet[i].b;
         palet_ary[i].i = palet[i].i;
    }
}

get_palet_entry(index, r, g, b, i)
ulong index;
uchar *r;
uchar *g;
uchar *b;
uchar *i;
{
    if( index < config.mode.palet_size )
    {
         *r = palet[index].r;
         *g = palet[index].g;
         *b = palet[index].b;
         *i = palet[index].i;
         return(TRUE);
    }
    else
      return(FALSE);
}


