/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*          Copyright (c) 1990 Texas Instruments Incorporated.           */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  file            oemdata.c                                            */
/*                                                                       */
/*  description     This file contains global variable definitions for   */
/*		    alternate video modes and monitors. 		 */
/*									 */
/*  TMS34010 TIGA Development Board with full memory configuration:	 */
/*	1 megabyte of VRAM (2 banks)					 */
/*	1 megabyte of DRAM						 */
/*	Monitor:     SONY Multi Scan HG (Model no. CPD-1304)		 */
/*	Dot clocks:  OSC0 = 63.960 Mhz for 1024x768 noninterlaced	 */
/*		     OSC1 = 25.175 MHz for 640x480 noninterlaced	 */
/*		     OSC3 = 44.900 MHz for 1024x768 interlaced		 */
/*									 */
/*   15 graphics modes: 						 */
/*									 */
/*   mode #   resolution   # colors   # pages	display 		 */
/*   ------   ----------   --------   -------	------- 		 */
/*	0      640x480x8     256	 1	noninterlaced		 */
/*	1      640x480x4      16	 2	noninterlaced		 */
/*	2      640x480x2       4	 2	noninterlaced		 */
/*	3      640x480x1       2	 2	noninterlaced		 */
/*	4      320x240x8     256	 2	noninterlaced		 */
/*	5     1024x768x8     256	 1	noninterlaced		 */
/*	6     1024x768x4      16	 2	noninterlaced		 */
/*	7     1024x768x2       4	 2	noninterlaced		 */
/*	8     1024x768x1       2	 2	noninterlaced		 */
/*	9      512x384x8     256	 2	noninterlaced		 */
/*     10     1024x768x8     256	 1	interlaced		 */
/*     11     1024x768x4      16	 2	interlaced		 */
/*     12     1024x768x2       4	 2	interlaced		 */
/*     13     1024x768x1       2	 2	interlaced		 */
/*     14      512x384x8     256	 2	interlaced		 */
/*									 */
/*-----------------------------------------------------------------------*/
/*  05/02/90...Converted from OEMDATA.ASM file in CD.....J.R. Van Aken	 */
/*  09/11/90...Added 320x240 and 512x384 modes...........J.R. Van Aken	 */
/*-----------------------------------------------------------------------*/
#include <gsptypes.h>	      /* type definitions */
#include "oem.h"              /* hardware-specific constants */

#define NUM_MODES    15       /* number of graphics modes supported */

/*--------------------------------------------------------------------*/
/*  The constant CLK25MHZ below is set to 1 (this is the default) if  */
/*  the 640x480-resolution modes are driven by a separate 25.16-MHz   */
/*  oscillator #1.  You can change CLK25MHZ to 0 if you configure the */
/*  TDB to drive these modes with the 34010's 50.35-MHz INCLK,        */
/*  divided by two.						      */
/*--------------------------------------------------------------------*/
#define CLK25MHZ     1			    /* 0=INCLK/2, 1=25MHz OSC */
#define OSC1DIV2     (CLK25MHZ<<10)	    /* setting for CR1 bit 10 */

/* List of globals defined in this file */
extern short num_modes;
extern SETUP mode_setup[];

short num_modes = NUM_MODES;  /* This global is accessed in CONFIG.C. */

/*-------------------------------------------------------------------*/
/*								     */
/*  34010 TDB with full memory configuration -- graphics modes 0-14  */
/*								     */
/*-------------------------------------------------------------------*/
SETUP mode_setup[NUM_MODES] =
{
    /*-------------------------------------------------------------------*/
    /*	TDB Mode 0:	640x480x8, 256 colors,	1 video page,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    0x00002000, 		 /* disp_pitch			  */
	    480,			 /* disp_vres			  */
	    640,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    1,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10001400, 		 /* workspace address		  */
	    0x2000,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    0x0004,			 /* hesync	  */
	    0x0020,			 /* heblnk	  */
	    0x00C0,			 /* hsblnk	  */
	    0x00C7,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF020,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0, 0 },				     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10001400,  384,  480 },	 /* buffer 0 */
	    { (uchar *)0x103C0000, 1024,  288 },	 /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 0			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10A0,0xE016|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 1:	640x480x4,  16 colors,	2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    480,			 /* disp_vres			  */
	    640,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    4,				 /* disp_psize			  */
	    0x0000000Fl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    16, 			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10000A00, 		 /* workspace address		  */
	    0x1000,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    0x0004,			 /* hesync	  */
	    0x001E,			 /* heblnk	  */
	    0x00BE,			 /* hsblnk	  */
	    0x00C7,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10200000, 0x10200000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10000A00,  384,  992 },	 /* buffer 0 */
	    { (uchar *)0x103E0000, 1024,  544 },	 /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 1			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30A0,0xE012|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 2:	640x480x2,  4 colors,  2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000800, 		 /* disp_pitch			  */
	    480,			 /* disp_vres			  */
	    640,			 /* disp_hres			  */
	    27, 			 /* screen_wide     (Taken from   */
	    20, 			 /* screen_high      monitorinfo) */
	    2,				 /* disp_psize			  */
	    0x00000003l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    4,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10000500, 		 /* workspace address		  */
	    0x800,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    0x0004,			 /* hesync	  */
	    0x001B,			 /* heblnk	  */
	    0x00BB,			 /* hsblnk	  */
	    0x00C7,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10100000, 0x10100000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10000500,  384,  992 },	 /* buffer 0 */
	    { (uchar *)0x101F0000, 1024, 2080 },	 /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 2			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10A0,0xE013|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 3:	640x480x1,  2 colors,  2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000400, 		 /* disp_pitch			  */
	    480,			 /* disp_vres			  */
	    640,			 /* disp_hres			  */
	    27, 			 /* screen_wide     (Taken from   */
	    20, 			 /* screen_high      monitorinfo) */
	    1,				 /* disp_psize			  */
	    0x00000001l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    2,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x100F8000, 		 /* workspace address		  */
	    0x400,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    0x0004,			 /* hesync	  */
	    0x0016,			 /* heblnk	  */
	    0x00B6,			 /* hsblnk	  */
	    0x00C7,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF004,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10080000, 0x10080000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x100F8000, 1024, 2080 },	 /* buffer 0 */
	    { (uchar *)0x10000280,  384,  992 },	 /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 3			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30A0,0xE013|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 4:	320x240x8, 256 colors,	2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    240,			 /* disp_vres			  */
	    320,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10000A00, 		 /* workspace address		  */
	    0x1000,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    0x0002,			 /* hesync	  */
	    0x000E,			 /* heblnk	  */
	    0x005E,			 /* hsblnk	  */
	    0x0063,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x100F0000, 0x100F0000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10000A00,  192,  480 },	 /* buffer 0 */
	    { (uchar *)0x101E0000,  512, 1056 },	 /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 4			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10A0,0xE0D6|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 5:	1024x768x8, 256 colors,  1 video page,		 */
    /*			NO statically allocated workspace buffer	 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    0x00002000, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    1,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    0x0006,			 /* hesync	  */
	    0x0020,			 /* heblnk	  */
	    0x00A0,			 /* hsblnk	  */
	    0x00A8,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF020,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0, 0 },				     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 5			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x1098,0xE016,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 6:	1024x768x4,  16 colors,  2 video pages, 	 */
    /*			NO statically allocated workspace buffer	 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    4,				 /* disp_psize			  */
	    0x0000000Fl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    16, 			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    0x0006,			 /* hesync	  */
	    0x0020,			 /* heblnk	  */
	    0x00A0,			 /* hsblnk	  */
	    0x00A8,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10300000, 0x10300000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 6			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x3098,0xE012,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 7:	1024x768x2,  4 colors,	2 video pages,		 */
    /*			NO statically allocated workspace buffer	 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000800, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    2,				 /* disp_psize			  */
	    0x00000003l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    4,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    1,				 /* n of offscreen address blocks */
	    0x10300000, 		 /* workspace address		  */
	    0x800,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    0x0006,			 /* hesync	  */
	    0x001E,			 /* heblnk	  */
	    0x009E,			 /* hsblnk	  */
	    0x00A8,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10300000,  800, 1536 },	 /* buffer 0 */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 7			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x1098,0xE013,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 8:	1024x768x1,   2 colors,  2 video pages, 	 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000400, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    1,				 /* disp_psize			  */
	    0x00000001l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    2,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    1,				 /* n of offscreen address blocks */
	    0x10180000, 		 /* workspace address		  */
	    0x400,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    0x0006,			 /* hesync	  */
	    0x001B,			 /* heblnk	  */
	    0x009B,			 /* hsblnk	  */
	    0x00A8,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF004,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x100C0000, 0x100C0000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10180000, 1024, 4608 },	 /* buffer 0 */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 8			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x3098,0xE013,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 9:	512x384x8, 256 colors,	2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    384,			 /* disp_vres			  */
	    512,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10300000, 		 /* workspace address		  */
	    0x200,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    0x0003,			 /* hesync	  */
	    0x000F,			 /* heblnk	  */
	    0x004F,			 /* hsblnk	  */
	    0x0054,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10300000,  512,   48 },	 /* buffer 0 */
	    { (uchar *)0x10330000,  512,  720 },	 /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 9			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x1098,0xE0D6,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 10:	1024x768x8, 256 colors,  1 video page,		 */
    /*			NO statically allocated workspace buffer,	 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    0x00002000, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    1,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    0x0015,			 /* hesync	  */
	    0x001A,			 /* heblnk	  */
	    0x009A,			 /* hsblnk	  */
	    0x009D,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB040,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0, 0 },				     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 10			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10F8,0xE016,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 11:	1024x768x4,  16 colors,  2 video pages, 	 */
    /*			NO statically allocated workspace buffer,	 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    4,				 /* disp_psize			  */
	    0x0000000Fl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    16, 			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    0x0015,			 /* hesync	  */
	    0x0019,			 /* heblnk	  */
	    0x0099,			 /* hsblnk	  */
	    0x009D,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB020,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10300000, 0x10300000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 11			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30F8,0xE012,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 12:	1024x768x2,  4 colors,	2 video pages,		 */
    /*			NO statically allocated workspace buffer,	 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 12			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000800, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    2,				 /* disp_psize			  */
	    0x00000003l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    4,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    1,				 /* n of offscreen address blocks */
	    0x10300000, 		 /* workspace address		  */
	    0x800,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 12			  */
	/*----------------------------------------------------------------*/
	{
	    0x0015,			 /* hesync	  */
	    0x0018,			 /* heblnk	  */
	    0x0098,			 /* hsblnk	  */
	    0x009D,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 12			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 12			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10300000,  800, 1536 },	 /* buffer 0 */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 12			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10F8,0xE013,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 13:	1024x768x1,   2 colors,  2 video pages, 	 */
    /*			statically allocated workspace buffer,		 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 13			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000400, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    1,				 /* disp_psize			  */
	    0x00000001l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    2,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    1,				 /* n of offscreen address blocks */
	    0x10180000, 		 /* workspace address		  */
	    0x400,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 13			  */
	/*----------------------------------------------------------------*/
	{
	    0x0015,			 /* hesync	  */
	    0x0015,			 /* heblnk	  */
	    0x0095,			 /* hsblnk	  */
	    0x009D,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 13			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x100C0000, 0x100C0000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 13			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10180000, 1024, 4608 },	 /* buffer 0 */
	    { (uchar *)0x00000000,    0,    0 },	 /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 13			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30F8,0xE013,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 14:	512x384x8, 256 colors,	2 video pages,		 */
    /*			statically allocated workspace buffer,		 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 14			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    384,			 /* disp_vres			  */
	    512,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10300000, 		 /* workspace address		  */
	    0x1000,			 /* workspace pitch		  */
	    0				 /* no VRAM block fill		  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 14			  */
	/*----------------------------------------------------------------*/
	{
	    0x000A,			 /* hesync	  */
	    0x000B,			 /* heblnk	  */
	    0x004B,			 /* hsblnk	  */
	    0x004E,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 14			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 14			  */
	/*----------------------------------------------------------------*/
	{
	    { (uchar *)0x10300000,  512,   48 },	 /* buffer 0 */
	    { (uchar *)0x10330000,  512,  720 },	 /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 14			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10F8,0xE0D6,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },
};

