/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test the patnfill_rect function.  Show the fill patterns available
 *   in the patterns.h file as a "stack of cards" display spread across
 *   the screen.  Pattern 0 is at the top left corner of the screen.
 *   Redraw the patterns with new colors once each second.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/26/90...Original version written...................J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

static CONFIG cfg;

main()
{
    int hres, vres, i, w, h, x, y, dx, dy, color0, color1, patn;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_frame_buffer(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Adjust size and displacement parameters to screen dimensions. */
    w = hres/4;
    h = vres/4;
    dx = (hres - w)/(NUM_PATNS - 1);
    dy = (vres - h)/(NUM_PATNS - 1);

    /* Infinite loop below draws geometric primitives to screen. */
    color0 = 0;
    color1 = 1;
    for (;;) {
	x = y = 0;
	for (patn = 0; patn < NUM_PATNS; patn++, x += dx, y += dy) {
	    color0 = (color0 + 7) & 15;
	    color1 = (color1 + 3) & 15;
	    set_colors(color1, color0);
	    current_patn.data = (PTR)&patnbits[patn];
	    set_patn(&current_patn);
	    patnfill_rect(w, h, x, y);
	}
	for (i = 60; i; i--)	  /* 1-second delay */
	    wait_scan(h);
    }
}

