;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   void delay(amount)                                                    ;
;   long amount;                                                          ;
;                                                                         ;
;   This function uses the magic number set up by the delay_set function  ;
;   and executes a loop that amount of time. This will be repeated        ;
;   a number of times specified by the argument "amount".                 ;
;                                                                         ;
;   Notes:- A8 is destroyed                                               ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  01/23/88...Original Version...........................Graham Short     ;
;  07/19/89...Fixed bug in the logic.....................Graham Short     ;
;-------------------------------------------------------------------------;
        .title  'delay funcs.'
        .file   'delay.asm'
;
;   Include GSP register definitions
        .include oem.inc
        .include gspreg.inc
        .mlib    gspmac.lib
;
;   Register usage
Rcnt    equ     A0
Rcount  equ     A1
Rtmp    equ     A8
;
;   Declare function names
;
        def     _delay
        .text
;-------------------------------------------------------------------------;
; delay function                                                          ;
;-------------------------------------------------------------------------;
_delay:
        mmtm    SP,A0,A1,A2,A3,A4
        setf    16,0,0
        Popc    Rcount
;
; for 0 or negative count, return
;
        move    Rcount,Rcount
        jrle    abort
        .if     GSP_34010
;
; wait for end of current frame
;
wait_loop:
        move    @VCOUNT10,Rcnt
        move    @VCOUNT10,Rtmp
        cmp     Rtmp,Rcnt
        jrnz    wait_loop
        move    @VSBLNK10,Rtmp
        cmp     Rtmp,Rcnt
        jrlo    wait_loop
;
; main delay loop
;
delay_loop:
;
; wait for end of current blanking period
;
        move    @VCOUNT10,Rcnt
        move    @VCOUNT10,Rtmp
        cmp     Rtmp,Rcnt
        jrnz    delay_loop
        move    @VSBLNK10,Rtmp
        cmp     Rcnt,Rtmp
        jrls    delay_loop
;
; wait for end of current frame
;
frame_loop:
        move    @VCOUNT10,Rcnt
        move    @VCOUNT10,Rtmp
        cmp     Rtmp,Rcnt
        jrnz    frame_loop
        move    @VSBLNK10,Rtmp
        cmp     Rtmp,Rcnt
        jrlo    frame_loop
        .endif
        .if     GSP_34020
;
; wait for end of current frame
;
wait_loop:
        move    @VCOUNT20,Rcnt
        move    @VCOUNT20,Rtmp
        cmp     Rtmp,Rcnt
        jrnz    wait_loop
        move    @VSBLNK20,Rtmp
        cmp     Rtmp,Rcnt
        jrlo    wait_loop
;
; main delay loop
;
delay_loop:
;
; wait for end of current blanking period
;
        move    @VCOUNT20,Rcnt
        move    @VCOUNT20,Rtmp
        cmp     Rtmp,Rcnt
        jrnz    delay_loop
        move    @VSBLNK20,Rtmp
        cmp     Rcnt,Rtmp
        jrls    delay_loop
;
; wait for end of current frame
;
frame_loop:
        move    @VCOUNT20,Rcnt
        move    @VCOUNT20,Rtmp
        cmp     Rtmp,Rcnt
        jrnz    frame_loop
        move    @VSBLNK20,Rtmp
        cmp     Rtmp,Rcnt
        jrlo    frame_loop
        .endif
;
; repeat until count frames have went by
;
        dsjs    Rcount,delay_loop
        movk    1,A8
        jruc    exit
;
; return to caller
;
abort:
        clrs    A8
exit:
        mmfm    SP,A0,A1,A2,A3,A4
        rets    2

