/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*  oem.h - TDB10 version						 */
/*                                                                       */
/*  This file contains the hardware-specific constants for the		 */
/*  TMS34010 TIGA Development Board.					 */
/*-----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------*/
/* Define GSP part number as either 34010 or 34020.			             */
/*-----------------------------------------------------------------------*/
#define GSP_34010  1	     /* Set to 1 if GSP part number is 34010 */
#define GSP_34020  0	     /* Set to 1 if GSP part number is 34020 */

#define VIDEO_MEMORY_START      0x10000000L
#define VIDEO_MEMORY_END	0x10300000L
#define PALET_ENTRIES           256

#define SHARED_MEM_SIZE         0
#define SHARED_HOST_ADDR        0
#define SHARED_GSP_ADDR         0

/* TMS34092 VGA Interface Chip's map of Bt478 Color Palette registers */
#define B478_READ  0x00003030
#define B478_WRITE 0x00003000
#define B478_VALUE 0x00003010
#define B478_MASK  0x00003020

/*-----------------------------------------------------------------------*/
/*  Define DRAM refresh mode and refresh rate.  This value is or'd       */
/*  with TIGA's default CONTROL value in "config.c".  Check your 340x0   */
/*  user's guide for appropriate bit values.                             */
/*-----------------------------------------------------------------------*/
#define DRAM_RM_RR              0x4

/*--------------------------------------------------------------------------*/
/*  SETUP structure definition                                              */
/*                                                                          */
/*      This structure contains all the mode-dependent information          */
/*      that will be downloaded from host to GSP when the current           */
/*      mode is changed.                                                    */
/*      All the information here is also duplicated on the host side.       */
/*      Changing the information below must be duplicated on the host side. */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#define MAX_PAGES               2     /* maximum number of display pages   */
#define MAX_OFFSCREEN		2     /* maximum number of offscreen areas */

typedef struct
{
   ushort         Monitor;
   ushort         Mode_Info_offset;
   ushort         Monitor_Info_offset;
   ushort         Page_Info_offset;
   ushort         Off_Screen_offset;
   ushort         OEM_Data_offset;                                      
   ushort         endsetup_offset;
} HEADER;

typedef struct
{
   ushort	 CR0, CR1, CR2;    /* 3 TMS34092 registers */
} OEMDATA;

typedef struct
{
   HEADER         header;
   MODEINFO       Mode_Info;
   MONITORINFO10  Monitor_Info;
   PAGE           Page_Info[MAX_PAGES];
   OFFSCREEN_AREA Off_Screen[MAX_OFFSCREEN];
   /*---------------------------------------------------------------*/
   /* Add OEMDATA to the SETUP structure.  The OEMDATA structure    */
   /* contains the values loaded into the TDB's 3 Control Registers.*/
   /*---------------------------------------------------------------*/
   OEMDATA        OEM_Data;                                      
} SETUP;

extern OEMDATA *oemdata;

/* Miscellaneous defs */
#define TIGA_VERSION_NUMBER	20

