;--------------------------------------------------------------------------;
;                                                                          ;
;               TIGA ASSEMBLY LANGUAGE EXAMPLE PROGRAM                     ;
;                                                                          ;
; Draws a series bouncing rectangles to demonstrate the interface to TIGA  ;
; via 8088 macro include files.                                            ;
;                                                                          ;
; REQUIREMENTS:-                                                           ;
;    TIGA version 2.0 installed in directory \tiga                         ;
;    Microsoft Assembler 5.0 or better                                     ;
;                                                                          ;
; To rebuild this demo type:-                                              ;
;    make                                                                  ;
;                                                                          ;
;   05/04/89...Original version written..................Graham Short      ;
;   07/28/89...COM File version written..................Michael Denio     ;
;                                                                          ;
;--------------------------------------------------------------------------;
        Title   ASMTST          
        ;
        ; Local constants
        ;
        ITERATION_COUNT Equ     2000

        ;
        ; Include files
        ;
        Include TYPEDEFS.INC
        Include TIGA_SM.INC
        Include EXTEND.INC

_TEXT   Segment Para Public 'CODE'
        assume  cs:_TEXT,ds:_TEXT,es:_TEXT,ss:_TEXT
	org	100h
entpt:  jmp     _main

        ;
        ; Define Data Here
        ;
myconfig        Db      88 Dup (?)
myfontinfo	Db	58 Dup (?)
str	        Db	'ASSEMBLY LANGUAGE EXAMPLE PROGRAM',  00h 
NO_TIGA         Db      'Error TIGA not initialized', 0Dh, 0Ah, '$'
NO_PRIMITIVES   Db      'Error in loading TIGA extended primitives', 0Dh, 0Ah, '$'

        ;
        ; Code Starts Here
        ;
;--------------------------------------------------------------------------;
;                                                                          ;
;       MAIN CONTROL ROUTINE                                               ;
;                                                                          ;
;--------------------------------------------------------------------------;
_main	PROC NEAR

        ;
        ; We MUST release all memory if using RLM files with COM files
        ;
        mov     ah,4ah
        mov     bx,1000h
        int     21h                     ; Release all but 64k of memory

        mov     dx,CD_OPEN              ; Open the CD
        Tiga_Set dx
        or      ax,ax
        jz      cd_is_open
        lea     dx,NO_TIGA
        mov     ah,09h
        int     21h                     ; Print Error message
        jmp     abort
cd_is_open:
        mov     dx,INIT OR CLR_SCREEN
        Set_Videomode TIGA dx           ; Try to initialize TIGA
	cmp	ax,0
        jne     tiga_installed
not_installed:
        lea     dx,NO_TIGA
        mov     ah,09h
        int     21h                     ; Print Error message
        jmp     Exit
tiga_installed:
        INSTALL_PRIMITIVES
	cmp	ax,0
        jge     primitives_installed
        lea     dx,NO_PRIMITIVES
        mov     ah,09h
        int     21h                     ; Print Error message
        jmp     Exit
primitives_installed:
        lea     dx,myconfig
        GET_CONFIG ds dx
        lea     dx,myfontinfo
        GET_FONTINFO 0 ds dx
	call	header
        mov     ax,WORD PTR myfontinfo.fontinfo_charhigh
        mov     di,ax
        shl     di,1
        add     di,ax                                   ; fontinfo.charhigh*3
        lea     si,myconfig.config_mode
        mov     cx,[si.modeinfo_disp_vres]
        sub     cx,di
        mov     dx,[si.modeinfo_disp_hres]
        SET_CLIP_RECT   dx cx 0 di
	call	_drawing
Exit:
        mov     dx,NO_INIT
        SET_VIDEOMODE PREVIOUS dx
        mov     dx,CD_CLOSE             ; Close the CD
        Tiga_Set dx
abort:
        mov     ah,04Ch                                 ; Return to DOS
        mov     al,001h
        int     021h
_main	Endp

;--------------------------------------------------------------------------;
;                                                                          ;
;       HEADER PROCEDURE                                                   ;
;                                                                          ;
;--------------------------------------------------------------------------;
header  Proc    Near
        push    bp
        push    si
        push    di
        lea     si,myconfig.config_mode
        cmp     WORD PTR [si.modeinfo_disp_psize],1
	jne	psize_ne_1a
        xor     dx,dx
        SET_FCOLOR dx dx
        jmp     continue_2
psize_ne_1a:
        SET_FCOLOR 0 BLUE
continue_2:
        mov     ax,WORD PTR myfontinfo.fontinfo_charhigh
        mov     di,ax
        shl     di,1
        add     di,ax
        FILL_RECT [si.modeinfo_disp_hres] di 0 0
        cmp     WORD PTR [si.modeinfo_disp_psize],1
	jne	psize_ne_1b
        SET_FCOLOR -1 -1
        SET_BCOLOR 0 0
	jmp	continue_3
psize_ne_1b:
        SET_FCOLOR 0 WHITE
        SET_BCOLOR 0 BLUE
continue_3:
        mov     bp,[si.modeinfo_disp_hres]
        dec     bp
        dec     di
        DRAW_RECT bp di 0 0
        sub     bp,6
        sub     di,6
        DRAW_RECT bp di 3 3
        lea     di,str
        TEXT_WIDTH ds di
        neg     ax
        mov     cx,[si.modeinfo_disp_hres]
        add     cx,ax
        shr     cx,1
        TEXT_OUT cx myfontinfo.fontinfo_charhigh ds di
        pop     di
        pop     si
        pop     bp
	ret	
header  Endp
;--------------------------------------------------------------------------;
;                                                                          ;
;       DRAWING PROCEDURE                                                  ;
;                                                                          ;
;--------------------------------------------------------------------------;
Local_Frame	Struc			; Define the local frame
colormax        Dw      ?
fcolor          Dw      ?
i               Dw      ?
w               Dw      ?
h               Dw      ?
x               Dw      ?
y               Dw      ?
wmin            Dw      ?
hmin            Dw      ?
xmin            Dw      ?
ymin            Dw      ?
wmax            Dw      ?
hmax            Dw      ?
xmax            Dw      ?
ymax            Dw      ?
vw              Dw      ?
vh              Dw      ?
vx              Dw      ?
vy              Dw      ?
Local_Frame	Ends			; End of the local frame

_drawing	PROC NEAR
	push	bp
        sub     sp,SIZE Local_Frame     
	mov	bp,sp                           ; Make room for local variables
	push	di
	push	si
        lea     si,myconfig.config_mode         ; set up pointer to config structure
Initialize_locals:
	mov	WORD PTR [bp.xmin],0	        ; xmin = 0
        mov     ax,WORD PTR myfontinfo.fontinfo_charhigh
        mov     dx,ax
        shl     dx,1
        add     ax,dx                                   
	mov	WORD PTR [bp.ymin],ax	        ; ymin = fontinfo.charhigh*3
        mov     ax,[si.modeinfo_disp_hres]
	dec	ax
	mov	WORD PTR [bp.xmax],ax	        ; xmax = disp_hres - 1
        mov     ax,[si.modeinfo_disp_vres]
	dec	ax
	mov	WORD PTR [bp.ymax],ax	        ; ymax = disp_vres - 1
        mov     ax,[si.modeinfo_disp_hres]
	sub	dx,dx
	mov	cx,6
	div	cx
	mov	WORD PTR [bp.wmin],ax	        ; wmin = disp_hres / 6
        mov     ax,[si.modeinfo_disp_vres]
	sub	dx,dx
	mov	cx,5
	div	cx
	mov	WORD PTR [bp.hmin],ax	        ; hmin = disp_vres / 5
        mov     ax,[si.modeinfo_disp_hres]
	sub	dx,dx
	mov	cx,3
	div	cx
	mov	WORD PTR [bp.wmax],ax	        ; wmax = disp_hres / 3
        mov     ax,[si.modeinfo_disp_vres]
	shr	ax,1
	mov	WORD PTR [bp.hmax],ax	        ; hmax = disp_vres / 2
        mov     ax,[si.modeinfo_disp_hres]
	sub	dx,dx
	mov	cx,11
	div	cx
	mov	WORD PTR [bp.vx],ax	        ; vx = disp_hres / 11
        mov     ax,[si.modeinfo_disp_vres]
	sub	dx,dx
	mov	cx,15
	div	cx
	mov	WORD PTR [bp.vy],ax	        ; vy = disp_vres / 15
        mov     ax,[si.modeinfo_disp_hres]
	sub	dx,dx
	mov	cx,29
	div	cx
	mov	WORD PTR [bp.vw],ax	        ; vw = disp_hres / 29
        mov     ax,[si.modeinfo_disp_vres]
	sub	dx,dx
	mov	cx,33
	div	cx
	mov	WORD PTR [bp.vh],ax	        ; vh = disp_vres / 33
	mov	ax,WORD PTR [bp.wmin]	
	mov	WORD PTR [bp.w],ax	        ; w = wmin
	mov	ax,WORD PTR [bp.hmin]	
	mov	WORD PTR [bp.h],ax	        ; h = hmin
	mov	ax,WORD PTR [bp.xmin]	
	add	ax,WORD PTR [bp.xmax]	
	sub	ax,WORD PTR [bp.w]	
	cwd	
	sub	ax,dx
	sar	ax,1
	mov	WORD PTR [bp.x],ax	        ; x = (xmin + xmax - w) / 2;
	mov	ax,WORD PTR [bp.ymin]	
	add	ax,WORD PTR [bp.ymax]	
	sub	ax,WORD PTR [bp.h]	
	cwd	
	sub	ax,dx
	sar	ax,1
	mov	WORD PTR [bp.y],ax	        ; y = (ymin + ymax - h) / 2;
	mov	ax,1
        mov     cx,[si.modeinfo_disp_psize]
	shl	ax,cl
	dec	ax
	mov	WORD PTR [bp.colormax],ax       ; colormax = (1<<config.mode.disp_psize) - 1;
	mov	ax,WORD PTR [bp.colormax]
	mov	WORD PTR [bp.fcolor],ax	        ; fcolor = colormax
	mov	WORD PTR [bp.i],0	
Main_Loop:
        SET_FCOLOR 0 [bp.fcolor]
	dec	WORD PTR [bp.fcolor]	
        FILL_RECT [bp.w] [bp.h] [bp.x] [bp.y]
Set_w:
	mov	ax,WORD PTR [bp.vw]	
	add	WORD PTR [bp.w],ax	        ; w = w + vw;
	mov	ax,WORD PTR [bp.wmin]	
	cmp	WORD PTR [bp.w],ax	
        jge     w_ge_wmin
w_lt_wmin:
	mov	ax,WORD PTR [bp.vw]	
	neg	ax
	mov	WORD PTR [bp.vw],ax	        ; vw = -vw
	mov	ax,WORD PTR [bp.wmin]	
	shl	ax,1
	sub	ax,WORD PTR [bp.w]	
	mov	WORD PTR [bp.w],ax	        ; w = 2*wmin - w;
	jmp	Set_x
w_ge_wmin:
	mov	ax,WORD PTR [bp.wmax]	
	cmp	WORD PTR [bp.w],ax	
	jle     Set_x
w_gt_wmax:
	mov	ax,WORD PTR [bp.vw]	
	neg	ax
	mov	WORD PTR [bp.vw],ax	        ; vw = -vw
	mov	ax,WORD PTR [bp.wmax]	
	shl	ax,1
	sub	ax,WORD PTR [bp.w]	
	mov	WORD PTR [bp.w],ax	        ; w = 2*wmax - w;
Set_x:
	mov	ax,WORD PTR [bp.vx]	
	add	WORD PTR [bp.x],ax	        ; x = x + vx
	mov	ax,WORD PTR [bp.xmin]	
	cmp	WORD PTR [bp.x],ax	
	jge     x_ge_xmin
x_lt_xmin:
	mov	ax,WORD PTR [bp.vx]	
	neg	ax
	mov	WORD PTR [bp.vx],ax	        ; vx = -vx
	mov	ax,WORD PTR [bp.xmin]	
	shl	ax,1
	sub	ax,WORD PTR [bp.x]	
	mov	WORD PTR [bp.x],ax	        ; x = 2*xmin - x;
	jmp	Set_h
x_ge_xmin:
	mov	ax,WORD PTR [bp.xmax]	
	sub	ax,WORD PTR [bp.w]	
	cmp	ax,WORD PTR [bp.x]	
	jge     Set_h
x_gt_xmax:
	mov	ax,WORD PTR [bp.vx]	
	neg	ax
	mov	WORD PTR [bp.vx],ax	        ; vx = -vx
	mov	ax,WORD PTR [bp.xmax]	
	sub	ax,WORD PTR [bp.w]	
	shl	ax,1
	sub	ax,WORD PTR [bp.x]	
	mov	WORD PTR [bp.x],ax	        ; x = 2*xmin - x;
Set_h:
	mov	ax,WORD PTR [bp.vh]	
	add	WORD PTR [bp.h],ax	        ; h = h + vh
	mov	ax,WORD PTR [bp.hmin]	
	cmp	WORD PTR [bp.h],ax	
	jge     h_gt_hmin
	mov	ax,WORD PTR [bp.vh]	
	neg	ax
	mov	WORD PTR [bp.vh],ax	        ; vh = -vh
	mov	ax,WORD PTR [bp.hmin]	
	shl	ax,1
	sub	ax,WORD PTR [bp.h]	
	mov	WORD PTR [bp.h],ax	        ; h = 2*hmin - h;
	jmp	Set_y
h_gt_hmin:
	mov	ax,WORD PTR [bp.hmax]	
	cmp	WORD PTR [bp.h],ax	
        jle     Set_y
h_gt_hmax:
	mov	ax,WORD PTR [bp.vh]
	neg	ax                              
	mov	WORD PTR [bp.vh],ax             ; vh = -vh
	mov	ax,WORD PTR [bp.hmax]
	shl	ax,1
	sub	ax,WORD PTR [bp.h]
	mov	WORD PTR [bp.h],ax              ; h = 2*hmax - h;
Set_y:
	mov	ax,WORD PTR [bp.vy]
	add	WORD PTR [bp.y],ax              ; y = y + vy
	mov	ax,WORD PTR [bp.ymin]
	cmp	WORD PTR [bp.y],ax
	jge     y_ge_ymin
y_lt_ymin:
	mov	ax,WORD PTR [bp.vy]
	neg	ax
	mov	WORD PTR [bp.vy],ax             ; vy = -vy
	mov	ax,WORD PTR [bp.ymin]
	shl	ax,1
	sub	ax,WORD PTR [bp.y]
	mov	WORD PTR [bp.y],ax              ; y = 2*ymin - y;
	jmp	Next_i
y_ge_ymin:
	mov	ax,WORD PTR [bp.ymax]
	sub	ax,WORD PTR [bp.h]
	cmp	ax,WORD PTR [bp.y]
	jge     Next_i
y_ge_ymax:
	mov	ax,WORD PTR [bp.vy]
	neg	ax
	mov	WORD PTR [bp.vy],ax             ; vy = -vy
	mov	ax,WORD PTR [bp.ymax]
	sub	ax,WORD PTR [bp.h]
	shl	ax,1
	sub	ax,WORD PTR [bp.y]
	mov	WORD PTR [bp.y],ax              ; y = 2*(ymax-h) - y;
Next_i:
	inc	WORD PTR [bp.i]	
	cmp	WORD PTR [bp.i],ITERATION_COUNT
	jg      Exit_Drawing   
	jmp	Main_Loop
Exit_Drawing:
	pop	si
	pop	di
        add     bp,SIZE Local_Frame     ;026h
	mov	sp,bp
	pop	bp
	ret	
_drawing	Endp

_TEXT   ends
        end     entpt
