/*---------------------------------------------------------------------------*/
/* Tiga 2.0 Example Programs                                                 */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/* CB340.C      Callback Example Program                                     */
/*                                                                           */
/*      This file contains the Gsp side source of an example of reading      */
/* keyboard input and performing simple host operations from the Gsp         */
/* using callback.                                                           */
/*                                                                           */
/*---------------------------------------------------------------------------*/
#include <gsptiga.h>

/*---------------------------------------------------------------------------*/
/* Define the Callback Globals for Visual Verification                       */
/*---------------------------------------------------------------------------*/
extern void *cb_buffer;
extern long cb_size;

/*---------------------------------------------------------------------------*/
/* Define the host functions to call                                         */
/*---------------------------------------------------------------------------*/
#define read_number()    host_command( 0, 0 )
#define add_numbers(a,b) host_command( 1, 2, __WORD(a), __WORD(b) )
#define read_list(a,b)   host_command( 2, 2, __WORD(a), __INWORD_PTR(a,b) )
#define add_list(a,b)    host_command( 3, 2, __WORD(a), __WORD_PTR(a,b) )
#define double_list(a,b) host_command( 4, 2, __WORD(a), __ALTWORD_PTR(a,b) )

/*---------------------------------------------------------------------------*/
/* Test Routine                                                              */
/*---------------------------------------------------------------------------*/
test_cb()
{
    int   i,j,k;
    short list[5];

    clear_screen(0);

    printf("Gsp Buffer Address = %X\n",cb_buffer);
    printf("Gsp Buffer Size    = %d\n",cb_size);

    printf("\nProgram to add two numbers\n");
    printf("Input Numbers to Add\n");

    printf("Getting a number ... ");
    i = read_number();
    printf("%d\n",i);

    printf("Getting a number ... ");
    j = read_number();
    printf("%d\n",j);

    k = add_numbers(i,j);

    printf("Result of %d + %d is %d\n",i,j,k);

    printf("\nGetting a list of numbers at %X ... ",list);
    read_list( 5, list );
    printf("%d",list[0]);
    for(i=1; i<5; i++)
        printf(", %d",list[i]);

    j = add_list( 5, list );
    printf("\nResult of %d",list[0]);
    for(i=1; i<5; i++)
        printf(" + %d",list[i]);
    printf(" is %d\n",j);

    printf("\nDoubled list is ... ");
    double_list( 5, list );
    printf("%d",list[0]);
    for(i=1; i<5; i++)
        printf(", %d",list[i]);

    j = add_list( 5, list );
    printf("\nResult of %d",list[0]);
    for(i=1; i<5; i++)
        printf(" + %d",list[i]);
    printf(" is %d\n",j);
}
