;-------------------------------------------------------------------------;
;                                    TIGA                                 ;
;          Copyright (C) 1986-1990  Texas Instruments Incorporated.       ;
;                            All Rights Reserved                          ;
;-------------------------------------------------------------------------;
;   TiGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;                                                                         ;
; draw_rect function                                                      ;
;                                                                         ;
;   Draw outline of rectangle given coordinates (xleft, ytop) of top      ;
;   left corner of rectangle, width w, and height h.  Outline is one      ;
;   pixel thick, and is functionally equivalent to the following          ;
;   sequence of calls to the draw_line function:                          ;
;                                                                         ;
;       draw_line(xleft, ytop, xleft+width, ytop);                        ;
;       draw_line(xleft, ytop+height, xleft+width, ytop+height);          ;
;       draw_line(xleft, ytop+1, xleft, ytop+height-2);                   ;
;       draw_line(xleft+width, ytop+1, xleft+width, ytop+height-2);       ;
;----------------------------------------------------------------------   ;
; Usage:  draw_rect(width, height, xleft, ytop)                           ;
;         long width, height, xleft, ytop;                                ;
;                                                                         ;
; Returned in register A8:  Void (undefined)                              ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   2/ 5/86...Original version written...................John Black       ;
;  10/20/86...Added TI copyright notice..................Stanley Acton    ;
;  10/27/86...Corrected border...........................John Black       ;
;   3/09/87...Fixed misaligned stack if w=0 or h=0.......Jerry Van Aken   ;
;   3/20/87...Set field size 0 to 16 in all cases........JV               ;
;   9/15/88...Added TiGA dm, globals and dstbm check.....Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'draw rectangle'
        .file     'drawrect.asm'
;
;  DEFINE GLOBAL FUNCTION NAME
;
        .def      _draw_rect
        .def      _dm_draw_rect

;
;
;  DEFINE GLOBAL VARIABLE NAMES
;
        .globl    _xyorigin
;
;  DIRECT MODE ENTRY POINT
;
_dm_draw_rect:
        SETF      16,0,0              ;
        MMTM      SP,A0,A1,A2         ;
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14
* Get arguments from command buffer data area
        MOVE      *-A14,A8,1          ;get pointer to data area
        SETF      16,0,0
        MOVE      *A8+,A0,0           ;get width argument
        MOVE      *A8+,A1,0           ;get height argument
        MOVE      *A8+,A2,1           ;get xleft and ytop arguments y:x
        jruc      common_ep
;
;  C-PACKET ENTRY POINT
;
_draw_rect:
        SETF      16,0,0              ;
        MMTM      SP,A0,A1,A2         ;
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14
* Pop arguments from operand stack.
        MOVE      *-A14,A0,1          ;get width argument
        MOVE      *-A14,A1,1          ;get height argument
        MOVE      *-A14,A2,1          ;get xleft argument
        MOVE      *-A14,A8,1          ;get ytop argument
* Concatenate xleft and ytop.
        SLL       16,A8
        MOVY      A8,A2
;
;     TWO ENTRY POINTS JOIN HERE
;
common_ep:
        MOVE      @_xyorigin,A8,1             ;get vuport origin displacement
        ADDXY     A8,A2                       ;translate to screen coordinates
* Verify that width > 0 and height > 0.
        MOVI      010001h,A8          ;
        ZEXT      A0,0                ;isolate width in x half of reg.
        JRZ       DEGEN1              ;jump if width <= 0
        SLL       16,A1               ;isolate height in y half of reg.
        JRZ       DEGEN2              ;jump if height <= 0
* Draw top edge of rectangle.
        MOVE      A2,B2               ;load DADDR
        ADDXY     A0,A8               ;DX = width + 1, DY = 1
        MOVE      A8,B7               ;load DYDX
        FILL      XY                  ;draw top edge of rectangle
* Draw bottom edge of rectangle.
        MOVE      A1,A8               ;
        ADDXY     A2,A8               ;x = xleft, y = ytop + height
        MOVE      A8,B2               ;load DADDR
        FILL      XY                  ;draw bottom edge of rectangle
* Draw left side of rectangle.
        ADDI      0FFFF0001h,A1       ;DX = 1, DY = height - 1
        MOVE      A1,B7               ;load DYDX
        ADDI      010000h,A2          ;x = xleft, y = ytop + 1
        MOVE      A2,B2               ;load DADDR
        FILL      XY                  ;draw left edge of rectangle
* Draw right side of rectangle.
        ADDXY     A0,A2               ;x = xleft + width, y = ytop + 1
LASTFILL:
        MOVE      A2,B2               ;load DADDR
        FILL      XY                  ;draw top edge of rectangle
* Restore registers and return.
EXIT:
        MMFM      SP,B2,B7,B10,B11,B12,B13,B14
        MMFM      SP,A0,A1,A2
        RETS      2                   ;
* Handle case in which rectangle degenerates to single line or point.
DEGEN1:
        SLL       16,A1               ;move height into y half of reg.
DEGEN2:
        MOVY      A1,A0               ;DX = width + 1, DY = height + 1
        ADDXY     A8,A0               ;
        MOVE      A0,B7               ;load DYDX
        JRUC      LASTFILL            ;draw line or point, and return
        .end

