/*======================================================================*/
/*  isrfuncs.c                                                          */
/*                                                                      */
/*  This file contains TMS340 functions called by the ISR demo          */
/*  program:                                                            */
/*      o get_isr_service_count()       Return serviced cnt of ISR      */
/*      o invoke_software_trap()        Invoke a software trap          */
/*      o get_last_scanline()           Return last visible scan line # */
/*                                                                      */
/*  Also, the Interrupt Service Routines for the following are          */
/*  included in this file:                                              */
/*                                                                      */
/*      o Display Interrupt             (Trap 10)                       */
/*      o Window Violation interrupt    (Trap 11)                       */
/*      o Host Interrupt                (Trap 09)                       */
/*      o Software trap interrupt       (Trap 16)                       */
/*                                                                      */
/*  Each ISR simply increments a counter every time it is serviced.     */
/*                                                                      */
/*======================================================================*/
#include <gsptypes.h>
#include <gspglobs.h>

short service_count[] = { 0, 0, 0, 0 }; /* Array to contain service cnt */


short get_isr_service_count( isr_index )
register short isr_index;
{
    return( service_count[isr_index] );
}


void invoke_software_trap( trap_num )
register short trap_num;
{
    switch( trap_num )
    {
        case  3:    asm( "  TRAP  3" ); break;
        case  4:    asm( "  TRAP  4" ); break;
        case  5:    asm( "  TRAP  5" ); break;
        case  6:    asm( "  TRAP  6" ); break;
        case  7:    asm( "  TRAP  7" ); break;
        case 12:    asm( "  TRAP 12" ); break;
        case 13:    asm( "  TRAP 13" ); break;
        case 14:    asm( "  TRAP 14" ); break;
        case 15:    asm( "  TRAP 15" ); break;
        case 16:    asm( "  TRAP 16" ); break;
        case 17:    asm( "  TRAP 17" ); break;
        case 18:    asm( "  TRAP 18" ); break;
        case 19:    asm( "  TRAP 19" ); break;
        case 20:    asm( "  TRAP 20" ); break;
        case 21:    asm( "  TRAP 21" ); break;
        case 22:    asm( "  TRAP 22" ); break;
        case 23:    asm( "  TRAP 23" ); break;
        case 24:    asm( "  TRAP 24" ); break;
        case 25:    asm( "  TRAP 25" ); break;
        case 26:    asm( "  TRAP 26" ); break;
        case 27:    asm( "  TRAP 27" ); break;
        case 28:    asm( "  TRAP 28" ); break;
        case 29:    asm( "  TRAP 29" ); break;
        case 31:    asm( "  TRAP 31" ); break;
    }               
}


short get_last_scanline()
{
    return( *pVSBLNK );
}


void di_isr()
{
    service_count[0]++;
}


void wv_isr()
{
    service_count[1]++;
}


void hi_isr()
{
    service_count[2]++;
}


void swtrap_isr()
{
    service_count[3]++;
}
