#include <tiga.h>                   /* All apps MUST include this file  */
#include <typedefs.h>
#include <extend.h>

static short oldmode;               /* Storage for old videomode        */

/*----------------------------------------------------------------------*/
/*  term_tiga                                                           */
/*                                                                      */
/*  syntax      void term_tiga( void )                                  */
/*                                                                      */
/*  This function properly terminates a TIGA application by restoring   */
/*  the previous video mode and closing the TIGA CD.  It must be        */
/*  called prior to returning to DOS.                                   */
/*----------------------------------------------------------------------*/
void term_tiga()
{
    printf( "Press any key to return to DOS... " );
    getch();
    set_videomode(oldmode,INIT);    /* Return mode to prev state        */
    tiga_set(CD_CLOSE);             /* Close the TIGA CD                */
    exit(0);                        /* Exit back to DOS                 */
}

/*----------------------------------------------------------------------*/
/*  init_tiga                                                           */
/*                                                                      */
/*  syntax      void init_tiga( load_graphics_lib )                     */
/*              short load_graphics_lib;                                */
/*                                                                      */
/*  This function properly initializes the TIGA environment and loads   */
/*  the graphics library functions if the argument load_graphics_lib is */
/*  non-zero.  This function should be called prior to calling any      */
/*  other TIGA function.                                                */
/*----------------------------------------------------------------------*/
void init_tiga( load_graphics_lib )
short load_graphics_lib;
{
    short   v;

    /*------------------------------------------------------------------*/
    /*  Open TIGA Communications Driver                                 */
    /*------------------------------------------------------------------*/
    if( (v = tiga_set(CD_OPEN)) != 0 )
    {
        printf( "TIGA CD error: %d\n", v );
        exit(0);                    /* Exit back to DOS                 */
    }                                
    /*------------------------------------------------------------------*/
    /*  Go into TIGA mode                                               */
    /*------------------------------------------------------------------*/
    oldmode = get_videomode();      /* Save current videomode for later */
    if( (v = set_videomode(TIGA,INIT | CLR_SCREEN)) == 0 )
    {
        printf( "TIGA GM error: %d\n", v );
        tiga_set(CD_CLOSE);         /* Be sure to close the open TIGA CD*/        
        exit(0);                    /* before exiting to DOS            */
    }
    /*------------------------------------------------------------------*/
    /*  Load graphics library functions if specified to do so           */
    /*------------------------------------------------------------------*/
    if( load_graphics_lib && (v=install_primitives()) < 0 )
    {
        printf( "Graphics Library load error: %d\n", v );
        term_tiga();
    }
}
