/*----------------------------------------------------------------------*/
/*  External variable and function declarations                         */
/*----------------------------------------------------------------------*/
extern  unsigned long   phys_color[];
extern  short           max_colors, iscolor;
extern  void            init_colors(short,short);
extern  void            set_dither(unsigned long);

/*----------------------------------------------------------------------*/
/*  Define color attribute functions.  These functions either select    */
/*  a solid color or a dithered pattern based on the flag "iscolor".    */
/*----------------------------------------------------------------------*/
#define set_phys_fcolor(a)          \
        (iscolor ? set_fcolor(a) : set_dither(a))
#define set_phys_colors(a,b)        \
        (iscolor ? set_colors(a,b) : set_dither(a))

/*----------------------------------------------------------------------*/
/*  Define entry points to drawing functions which can output in        */
/*  either solid color or a dithered pattern.  The actual TIGA function */
/*  which is called is determined by the flag "iscolor".                */
/*----------------------------------------------------------------------*/
#define c_pen_line(a,b,c,d)         \
        (iscolor ? pen_line(a,b,c,d) : patnpen_line(a,b,c,d))
#define c_fill_rect(a,b,c,d)        \
        (iscolor ? fill_rect(a,b,c,d) : patnfill_rect(a,b,c,d))
#define c_fill_oval(a,b,c,d)        \
        (iscolor ? fill_oval(a,b,c,d) : patnfill_oval(a,b,c,d))
#define c_fill_convex(a,b)          \
        (iscolor ? fill_convex(a,b) : patnfill_convex(a,b))
#define c_frame_rect(a,b,c,d,e,f)   \
        (iscolor ? frame_rect(a,b,c,d,e,f) : patnframe_rect(a,b,c,d,e,f))
#define c_fill_polygon(a,b)         \
        (iscolor ? fill_polygon(a,b) : patnfill_polygon(a,b))

/*----------------------------------------------------------------------*/
/*  Physical color equates.  Physical colors are derived from their     */
/*  logical rgbi definitions in the init_colors() function in colors.c  */
/*----------------------------------------------------------------------*/
#define _BLACK                  phys_color[ 0]
#define _BLUE                   phys_color[ 1]
#define _GREEN                  phys_color[ 2]
#define _CYAN                   phys_color[ 3]
#define _RED                    phys_color[ 4]
#define _MAGENTA                phys_color[ 5]
#define _BROWN                  phys_color[ 6]
#define _LIGHT_GRAY             phys_color[ 7] 
#define _DARK_GRAY              phys_color[ 8] 
#define _LIGHT_BLUE             phys_color[ 9] 
#define _LIGHT_GREEN            phys_color[10] 
#define _LIGHT_CYAN             phys_color[11] 
#define _LIGHT_RED              phys_color[12] 
#define _LIGHT_MAGENTA          phys_color[13] 
#define _YELLOW                 phys_color[14]
#define _WHITE                  phys_color[15]
#define _AQUAMARINE             phys_color[16]
#define _BLUE_VIOLET            phys_color[17]
#define _CADET_BLUE             phys_color[18]
#define _CORAL                  phys_color[19]
#define _CORNFLOWER_BLUE        phys_color[20]
#define _DARK_GREEN             phys_color[21]
#define _DARK_OLIVE_GREEN       phys_color[22]
#define _DARK_ORCHID            phys_color[23]
#define _DARK_SLATE_BLUE        phys_color[24]
#define _DARK_SLATE_GRAY        phys_color[25]
#define _DARK_TURQUOISE         phys_color[26]
#define _DIM_GRAY               phys_color[27]
#define _FIREBRICK              phys_color[28]
#define _FOREST_GREEN           phys_color[29]
#define _GOLD                   phys_color[30]
#define _GOLDENROD              phys_color[31]
#define _GRAY                   phys_color[32]
#define _GREEN_YELLOW           phys_color[33]
#define _INDIAN_RED             phys_color[34]
#define _KHAKI                  phys_color[35]
#define _LIGHT_STEEL_BLUE       phys_color[36]
#define _LIME_GREEN             phys_color[37]
#define _MAROON                 phys_color[38]
#define _MEDIUM_AQUAMARINE      phys_color[39]
#define _MEDIUM_BLUE            phys_color[40]
#define _MEDIUM_FOREST_GREEN    phys_color[41]
#define _MEDIUM_GOLDENROD       phys_color[42]
#define _MEDIUM_ORCHID          phys_color[43] 
#define _MEDIUM_SEA_GREEN       phys_color[44]
#define _MEDIUM_SLATE_BLUE      phys_color[45]
#define _MEDIUM_SPRING_GREEN    phys_color[46]
#define _MEDIUM_TURQUOISE       phys_color[47]
#define _MEDIUM_VIOLET_RED      phys_color[48]
#define _MIDNIGHT_BLUE          phys_color[49]
#define _NAVY                   phys_color[50]
#define _NAVY_BLUE              phys_color[51]
#define _ORANGE                 phys_color[52]
#define _ORANGE_RED             phys_color[53]
#define _ORCHID                 phys_color[54]
#define _PALE_GREEN             phys_color[55]
#define _PINK                   phys_color[56]
#define _PLUM                   phys_color[57]
#define _SALMON                 phys_color[58]
#define _SEA_GREEN              phys_color[59]
#define _SIENNA                 phys_color[60]
#define _SKY_BLUE               phys_color[61]
#define _SLATE_BLUE             phys_color[62]
#define _SPRING_GREEN           phys_color[63]
#define _STEEL_BLUE             phys_color[64]
#define _TAN                    phys_color[65]
#define _THISTLE                phys_color[66]
#define _TURQUOISE              phys_color[67]
#define _VIOLET                 phys_color[68]
#define _VIOLET_RED             phys_color[69]
#define _WHEAT                  phys_color[70]
#define _YELLOW_GREEN           phys_color[71]
#define NUM_LOG_COLORS          72
/*----------------------------------------------------------------------*/
/*  Colors used in title area on demo screens                           */
/*----------------------------------------------------------------------*/
#define TITLE               _WHITE
#define BORDER              _WHITE
#define TITLE_BACKGROUND    _BLUE
/*----------------------------------------------------------------------*/
/*  Colors used in TIBUG and blit demos                                 */
/*----------------------------------------------------------------------*/
#define TI_SYMBOL           _WHITE    
#define SUN                 _YELLOW
#define SEA                 _BLUE
#define CLOUDS              _WHITE
#define HULL                _BROWN
#define SAILS               _LIGHT_GRAY
#define SKY                 _CYAN
#define FRAME               _RED
