/********************************************************************/
/* math.h   v5.01                                                   */
/* Copyright (c) 1990 Texas Instruments Inc.                        */
/********************************************************************/
#ifndef _MATH
#define _MATH

#ifdef _TMS340_IEEE
#define HUGE_VAL  1.7976931348623124e+308   /* SAME AS DBL_MAX */
#else
#define HUGE_VAL  8.9884656743115620e+307   /* SAME AS DBL_MAX */
#endif

double asin(double _x);
double acos(double _x);
double atan(double _x);
double atan2(double _y, double _x);
double ceil(double _x);
double cos(double _x);
double cosh(double _x);
double exp(double _x);
double fabs(double _x);
double floor(double _x);
double fmod(double _x, double _y);
double frexp(double _x, int *_exp);
double ldexp(double _x, int _exp);
double log(double _x);
double log10(double _x);
double modf(double _x, double *_iptr);
double pow(double _x, double _y);
double sin(double _x);
double sinh(double _x);
double sqrt(double _x);
double tan(double _x);
double tanh(double _x);

#ifndef EDOM
#define EDOM   1
#endif

#ifndef ERANGE
#define ERANGE 2
#endif

#endif
