****************************************************************************
*  boot   V6.60
*  Copyright (c) 1988-1995 Texas Instruments Inc.
****************************************************************************

****************************************************************************
*
*   This module contains the following definitions :
*
*         __stack    - Stack memory area
*         _c_int0    - Boot function
*         _var_init  - Function which processes initialization tables
*
****************************************************************************
	.global  _c_int0, cinit
	.global  _main, _abort
	.global	.bss, end

****************************************************************************
* FOR C50, DEFINE ADDRESSES OF MEMORY MAPPED REGISTERS 
****************************************************************************
	.if	.tms32050
	.mmregs
	.endif

****************************************************************************
* CONST COPY OPTION
* If your system cannot support allocating an initialized section to data
* memory, and you want the boot routine to copy .const from program to
* data memory, then set this CONST_COPY variable to 1
*
* Note the code that does the copy depends on you having the following
* in your linker command file
*
*	MEMORY
*	{
*	  PAGE 0 : PROG : ...	/* 'PROG' AND 'DATA' ARE EXAMPLE NAMES */
*	  PAGE 1 : DATA : ...
*	  ...
*       }
*
*	SECTIONS
*	{
*	  ...
*	  .const : load = PROG PAGE 0, run = DATA PAGE 1
*		   { 
*		     __const_run = .
*		     *(.c_mark)
*		     *(.const)
*		     __const_length = . - __const_run
*		   }
*	  ...
*	}
****************************************************************************
CONST_COPY	.set	0

****************************************************************************
* FOR CONST COPY, DEFINE THE LOAD ADDRESS OF THE .const SECTION 
* DEPENDS ON LINKER COMMAND FILE BEING WRITTEN AS ABOVE
****************************************************************************
	.if	CONST_COPY
	.sect	".c_mark"
	.label	__const_load

	.global	__const_run, __const_length

	.text
	.endif ; CONST_COPY

****************************************************************************
* DECLARE THE STACK.  SIZE IS DETERMINED BY THE LINKER OPTION -stack
****************************************************************************
__stack:	.usect	".stack",0

****************************************************************************
* FUNCTION DEF : _c_int0
*
*   1) Set up stack
*   2) Set up proper status
*   3) If "cinit" is not -1, init global variables
*   4) call users' program
*
****************************************************************************
_c_int0:

****************************************************************************
*  SET UP INITIAL STACK AND FRAME POINTERS
****************************************************************************
	LRLK    AR0,__stack		; set up frame pointer
	LRLK    AR1,__stack		; set up stack pointer

****************************************************************************
* INITIALIZE STATUS BIT FIELDS *NOT* INITIALIZED AT RESET                   
****************************************************************************
	ROVM				; turn off overflow mode

****************************************************************************
* INITIALIZE STATUS BIT FIELDS WHICH ARE SET TO THESE SAME VALUES BY RESET.
* IF YOU RUN THIS ROUTINE FROM RESET, YOU CAN COMMENT OUT THIS CODE.
****************************************************************************
	SPM     0			; product shift count of zero

	.if	.tms32050
	LDPK	0			; access memory mapped regs
	APL	#0fff9h,PMST		; set NDX = 0 and TRM = 0
	.endif

	SSXM				; set SXM=1 for next instruction
****************************************************************************
*  IF cinit IS NOT -1, PROCESS INITIALIZATION TABLES
****************************************************************************
	LALK    cinit			; get pointer to init tables
	ADDK    1
	BZ      skip			; if (cinit == -1)

	CALL    _var_init,AR1		; var_init() 

****************************************************************************
*  CALL USER'S PROGRAM
****************************************************************************
skip:
	.if	CONST_COPY
	CALL	const_copy
	.endif

	CALL    _main,AR1
forever b       forever                         ;After return from main

	.page
****************************************************************************
* FUNCTION DEF : _var_init
*
*  PROCESS INITIALIZATION TABLES.  TABLES ARE IN
*  PROGRAM MEMORY IN THE FOLLOWING FORMAT :
*
*       .word  <length of init data in words>
*       .word  <address of variable to initialize>
*       .word  <init data>
*       .word  ...
*
*  The init table is terminated with a zero length
*
****************************************************************************

_var_init:

****************************************************************************
* C2x/C2xx VERSION
****************************************************************************
	.if	.tms32025 | .tms3202xx
        ADRK    2			; allocate two words of local memory
        LALK    cinit			; load accumulator with base of table
	LARP    AR0

****************************************************************************
*  READ INIT RECORD HEADER
*  AN INIT RECORD WITH A ZERO LENGTH TERMINATES LIST
****************************************************************************
loop:
	TBLR    *+			; read length 
	ADDK    1
	TBLR    *			; read address

	LAR     AR2,*-			; load variable address into ar2
	LAR     AR3,*,AR3		; load count into ar3
	BANZ    copy,*-,AR2		; check for end of table
 
****************************************************************************
*  AT END OF LIST, RETURN TO CALLER
****************************************************************************
        LARP    AR1 
	SBRK    2			; deallocate locals
	RET				; return to _c_int0

****************************************************************************
*  PERFORM THE COPY OF DATA FROM PROGRAM TO DATA
****************************************************************************
copy:
	ADDK    1			; increment pointer to data     
	TBLR    *+,AR3			; copy data from program to variable
	BANZ    copy,*-,AR2		; until count is zero

	ADDK    1			; point to beginning of next record
	B       loop,AR0		; go process next record

	.endif ; .tms32025 | .tms3202xx

****************************************************************************
* C5x VERSION
****************************************************************************
	.if	.tms32050

        LALK    cinit			; load accumulator with base of table
	LDPK	0			; set page to 0 for AR2 ==> BRCR

****************************************************************************
*  READ INIT RECORD HEADER
*  AN INIT RECORD WITH A ZERO LENGTH TERMINATES LIST
****************************************************************************
loop:
	TBLR	*			; read length
	ADDK	1
	LAR	AR2,*,AR2		; into AR2
	BANZ	continue,*-,AR1		; continue if not zero, decrement

****************************************************************************
*  AT END OF LIST, RETURN TO CALLER
****************************************************************************
	RET

continue:
	LMMR	BRCR,AR2		; BRCR = AR2 = length - 1
	TBLR	*
	ADDK	1
	LAR	AR2,*,AR2		; AR2  = address

****************************************************************************
*  PERFORM THE COPY OF DATA FROM PROGRAM TO DATA
****************************************************************************
	RPTB	copy - 1
	TBLR	*+
	ADDK	1
	NOP
copy:
	B       loop,AR1		; go process next record

	.endif ; .tms32050

	.page

****************************************************************************
* CONST COPY ROUTINE - COPIES THE .const SECTION FROM PROGRAM TO DATA MEMORY
****************************************************************************
	.if CONST_COPY
const_copy:

****************************************************************************
* C2x/C2xx VERSION - MUST USE 'RPT *' BECAUSE RPTK COUNT ISN'T BIG ENOUGH
****************************************************************************
	.if	.tms32025 | .tms3202xx
	LALK	#__const_length		; load length of const section
	BZ	quit			; if 0, quit
	LRLK	AR2,#__const_run	; AR2 = const address in data
	LALK	#__const_length-1	; load length - 1
	SACL	*			; write to temp

	RPT	*,AR2			; repeat length times
	BLKP	#__const_load,*+	; block copy from program

	LARP	AR1			; restore ARP to SP
quit:
	RET				; return
	.endif ; .tms32025 | .tms3202xx	

****************************************************************************
* C5x VERSION - USES RPTK
****************************************************************************
	.if	.tms32050
	LALK	#__const_length		; load length of const section
	BZ	quit			; if 0, quit
	LRLK	AR2,#__const_run	; AR2 = const address in data
	LARP	AR2

	RPT	#__const_length-1	; repeat length times
	BLKP	#__const_load,*+	; block copy from program

	LARP	AR1			; restore ARP to SP
quit:
	RET				; return
	.endif ; .tms32050

	.endif ; CONST_COPY

	.end
