;
; Initialization of DSP hardware
;
; Portions Copyright (C) Texas Instruments Inc, 1992
;

        .global _c_int0,scratch
        .mmregs
        .text

;
; Interrupt vector table follows
;
***********************************************************************
* Reset section, resides at location 0h, use "reset" handle to place  *
* this section at location 0h via the linker			      *
***********************************************************************

reset:	 b	   initcpu	 ;0

***********************************************************************
* vector section, can reside on any 2K word boundary, use "vectors"   *
* handle to place this section on any 2K word boundary via the linker.*
* Remember to set the IPTR bits of the PMST register to correspond to *
* the location where this vector table is located.		      *
***********************************************************************
;
int1:	 b	   _dummy	 ;2
int2:	 b	   _dummy	 ;4
int3:	 b	   _dummy	 ;6
tint:	 b	   _dummy	 ;8
rint:	 b	   _dummy	 ;A
xint:	 b	   _dummy	 ;C
trnt:	 b	   _dummy	 ;E
txint:	 b	   _dummy	 ;10
int4:	 b	   _dummy	 ;12
	 b	   _dummy	 ;14
	 b	   _dummy	 ;16
	 b	   _dummy	 ;18
	 b	   _dummy	 ;1A
	 b	   _dummy	 ;1C
	 b	   _dummy	 ;1E
	 b	   _dummy	 ;20
trap:	 b	   _dummy	 ;22
nmi:	 b	   _dummy	 ;24
	 b	   _dummy	 ;26
	 b	   _dummy	 ;28
	 b	   _dummy	 ;2A
	 b	   _dummy	 ;2C
	 b	   _dummy	 ;2E
	 b	   _dummy	 ;30
	 b	   _dummy	 ;32
	 b	   _dummy	 ;34
	 b	   _dummy	 ;36
	 b	   _dummy	 ;38
	 b	   _dummy	 ;3A
	 b	   _dummy	 ;3C
	 b	   _dummy	 ;3E

;
; Dummy interrupt
;

_dummy  b       _dummy

;
; DSP initialization follows
;

initcpu
         dint	                ; Disable interrupts
         ldp    #0

 	 opl    #0038h,PMST     ;Set OVLY, RAM and MP/MC
         sst    #1,scratch      ;Get ST1
         lacc   scratch
         or     #1000h          ;Set CNF bit
         sacl   scratch
         lst    #1,scratch      ;Load new ST1

         lar    ar3,#0F800h     ;Point to IIC controller
         lacc   #0              ;Clear accumulator
         mar    *,ar3           ;Use AR3
         sacl   *               ;First write to IIC controller sets 8080 mode

         lacc   #001Eh
         sacl   cwsr            ;Set BIG = 1, Long wait states in DATA space
         lacc   #0FAAAh
         sacl   iowsr           ;Set I/O to 1 wait state, except for IIC
         lacc   #0EAAAh
         sacl   pdwsr           ;Data 2 waits (except IIC), FLASH to 2 waits

        b      _c_int0                  ;Go to boot loader

;
; End of program
;

        .end
