
         .global _suspend,receive,_burnloc16
         .global _eraseblk,scratch,_burnloc32,_burnsram
	 .version 50
	 .mmregs
         .sect  ".ramcode"

;
; Suspend execution via a program loop
;

_suspend:
        popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,0           ;Size of Frame is zero
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lark    ar2,-3          ;Offset to argument
        mar     *0+             ;Point to argument
        lar     ar3,*,ar3       ;Load suspend value
suspend0  banz    suspend0      ;Execute suspend

        larp    ar1             ;Pop off frame
        sbrk    1
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; Write AAAA/5555 to program memory - command in accl
;

setup   splk    #05555h,BMAR    ;Set up BMAR
        splk    #0aaaah,scratch ;Temp register
        bldp    scratch
        splk    #02aaah,BMAR
        splk    #05555h,scratch
        bldp    scratch
        splk    #05555h,BMAR
        sacl    scratch
        bldp    scratch
        ret

;
; Write AAAA/SA to block
;

setupadr
        mar     *,ar3
        splk    #05555h,BMAR    ;Set up BMAR
        splk    #0aaaah,scratch ;Temp register
        bldp    scratch
        splk    #02aaah,BMAR
        splk    #05555h,scratch
        bldp    scratch
        splk    #0030h,scratch
        sacl    BMAR
        lark    ar3,#5000               ; Delay fixes strange bug w/F100
setup0  banz    setup0
        bldp    scratch
        lark    ar3,#5000
setup1  banz    setup1
        ret

;
; Wait for program function complete
;

wait    blpd    BMAR,scratch    ;Read Toggle bit
        lacl    scratch
        blpd    BMAR,scratch    ;Get toggle bit again
        xor     scratch
        and     #0040h          ;Mask all but D6
        bnz     wait            ;Wait until no more toggle
        ret

;----------------------------------------------------------------------
;  BURN: Burn FLASH location
;----------------------------------------------------------------------

_burnloc16
        popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,2           ;Size of frame
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lark    ar2,-3          ;Offset of arguments
        mar     *0+             ;Point to argument

        lar     ar4,*-          ;Load address from C stack (ar4 is prog addr)
        ldp     #0              ;Point to pg 0
        lacl    #00a0h          ;Load program command
        call    setup           ;Write command to FLASH memory
        sar     ar4,BMAR        ;Store FLASH program address in BMAR
        lacc    *-,ar4          ;Load data from C stack (acc is data)
        sacl    scratch         ;Save in scratch memory
        bldp    scratch         ;Write programming data
        call    wait            ;Wait for program cycle complete

        mar     *,ar0
        larp    ar1             ;Pop off frame
        sbrk    3
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

_burnloc32
        popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,3           ;Size of frame
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lark    ar2,-3          ;Offset of arguments
        mar     *0+             ;Point to argument

        lar     ar4,*-          ;Load address from C stack (ar4 is prog addr)
        ldp     #0              ;Point to pg 0
        lacl    #00a0h          ;Load program command
        call    setup           ;Write command to FLASH memory
        sar     ar4,BMAR        ;Store FLASH program address in BMAR
        lacc    *-
        lacc    *+,ar4          ;Load data from C stack (acc is data)
        sacl    scratch         ;Save in scratch memory
        bldp    scratch         ;Write programming data
        call    wait            ;Wait for program cycle complete
        lacl    #00a0h          ;Load program command
        call    setup           ;Write command to FLASH memory
        mar     *,ar2
        lacc    *-,ar4          ;Get next word
        mar     *+
        sar     ar4,BMAR        ;Store FLASH program address in BMAR
        sacl    scratch         ;Save data in scratch memory
        bldp    scratch         ;Write programming data
        call    wait            ;Wait for program cycle complete

        mar     *,ar0
        larp    ar1             ;Pop off frame
        sbrk    4
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; Erase entire flash contents
;

_eraseblk
        popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,1           ;Size of frame
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lark    ar2,-3          ;Offset of arguments
        mar     *0+             ;Point to argument

        ldp     #0              ;Point to pg 0
        lacl    #0080h          ;Load sector erase command
        call    setup
        lacl    *               ;Get sector address
        call    setupadr
        call    wait            ;Wait for erase complete

        mar     *,ar0
        larp    ar1             ;Pop off frame
        sbrk    2
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; Erase entire flash contents
;

_erase  popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,0           ;Size of frame
        lar     ar0,*0+,ar2     ;Set up FP and SP

        lacl    #0080h          ;Load chip erase command
        call    setup
        lacl    #0010h
        call    setup
        call    wait            ;Wait for erase complete

        mar     *,ar0
        larp    ar1             ;Pop off frame
        sbrk    1
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; Burn entire contents of FLASH memory with SRAM
;

_burnsram
        lacl    #0080h          ;Load chip erase command
        call    setup
        lacl    #0010h
        call    setup
        call    wait            ;Wait for erase complete
        lark    ar4,#1000h      ;Load start address in SRAM
        ldp     #0              ;Point to pg 0
burnsr0 lacl    #00a0h          ;Load program command
        call    setup           ;Write command to FLASH memory
        sar     ar4,BMAR        ;Store FLASH program address in BMAR
        lacl    BMAR
        subk    #1000h          ;Subtract offset
        sacl    BMAR            ;Save back in BMAR
        mar     *,ar4
        lacc    *+,ar4          ;Get data from SRAM
        sacl    scratch         ;Save in scratch memory
        bldp    scratch         ;Write programming data
        call    wait            ;Wait for program cycle complete
        cpl     #0efffh,ar4     ;Are we done?
        bcnd    burnsr0,ntc     ;Loop back if not
        b       0               ;Restart monitor

;
; End of file
;

	 .end
