<sheet>

<!-- SET FOREGROUND OF HTML TAGS IN TEXT BEFORE/AFTER TO RED -->
<style name="#TEXT-BEFORE">
   <foreground> #ff0000 </>
</style>
<style name="#TEXT-AFTER">
   <foreground> #ff0000 </>
</style>


<!-- **** VARIOUS RAINBOW EMISSIONS THAT SHOULD BE HIDDEN **** -->

<style name="RBW-SYSATTRS">
    <hide>All</>
</style>
<style name="RBW-SYSOBJ">
    <hide>All</>
</style>


<!-- **** TABLES
The latest IETF draft is very CALS-like.  However, few (if any) Web
clients have implemented it yet.  The older HTML 3.0 tables can be
done with "rowspan" and "colspan" attributes on <td> or <th> elements.
Client manufacturers' adoption of the IETF draft model will
make life a lot easier. 
Please note that borders and cell widths have NOT been mapped from 
CALS to HTML. This was done to keep this, already complicated 
transformation, relatively manageable.
Furthermore, instead of using COLGROUP and COL elements in the HTML, 
we specify spanning through through the colspan and rowspan attributes
on the TD and/or TH elements. This obviously has the previously mentioned 
side effect of not retaining cell widths.
**** -->

<style name="RBW-TABLE">
   <break-before> Line </>
   <text-before><TABLE BORDER="2"></>
   <text-after>join('<','/TABLE>')</>
</style>

<style name="THEAD">
   <break-before> Line </>   
   <font-weight>  bold   </>
   <text-before><THEAD></>
   <text-after>join('<','/THEAD>')</>
</style>

<style name="TFOOT">
   <break-before> Line </>   
   <font-weight>   bold   </>
   <text-before><TFOOT></>
   <text-after>join('<','/TFOOT>')</>
</style>

<style name="TBODY">
   <text-before><TBODY></>
   <text-after>join('<','/TBODY>')</>
</style>

<style name="RBW-ROW">
   <break-before> Line </>   
   <hrule>Surround</>
   <vrule>Children</>
   <text-before><TR></>
   <text-after>join('<','/TR>')</>
</style>

<!-- **** Handling ENTRY to TD or TH mapping:
 If the <entry> is in a <thead> or <tfoot>, you probably want it to
 be a <th>, otherwise a <td>.  So, qualify the ENTRY style. **** -->
<!-- **** Determine if horizontal or vertical or no-span ENTRY:
 If the <entry> has the "spanname" attribute set, the <td> or <th>
 should have the "colspan" attribute set.  Use the select property. **** -->

<style name="TBODY,RBW-ROW,ENTRY">
   <select> if(attr(spanname),TD.SPAN,TD.NOSPAN) </>
</style>

<style name="THEAD,RBW-ROW,ENTRY">
   <select> if(attr(spanname),TH.SPAN,TH.NOSPAN) </>
</style>

<style name="TFOOT,RBW-ROW,ENTRY">
   <select> if(attr(spanname),TH.SPAN,TH.NOSPAN) </>
</style>

<!-- **** Deal with vertical or no-span ENTRY:
 For non-horizontally-spanning cells, there is still vertical
 spanning to consider.  CALS uses the "morerows" attribute, which is
 the number of *additional* rows, i.e., rows more than one, which
 the cell should span.  HTML 3.0 uses the "rowspan" attribute, which is
 the *total* number of rows that should be spanned.  Add one to
 "morerows" to get "rowspan". **** -->

<style name="TD.NOSPAN">
   <column> True </>
   <left-indent>   +=tableinfo(cals,left-indent,4)   </>
   <width>   tableinfo(cals,width,4)   </>
   <justification>   tableinfo(cals,justification)   </>
   <text-before> <TD rowspan=incr(attr(morerows))> </>
   <text-after>join('<','/TD'>)</>
</style>

<style name="TH.NOSPAN">
   <column> True </>
   <left-indent>   +=tableinfo(cals,left-indent,4)   </>
   <width>   tableinfo(cals,width,4)   </>
   <justification>   tableinfo(cals,justification)   </>
   <text-before> <TH rowspan=incr(attr(morerows))> </>
   <text-after>join('<','/TH'>)</>
</style>

<!-- **** Horizontal Span ENTRY - number of cols:
 For the horizontally spanning cells, we need to find out how many
 columns are spanned.  For DynaText, we already require the
 <colspec> elements to fall in sequential order.  So, find the
 referenced <colspec>s, find the difference in cnum()s, and add one:
 incr(sub(cnum([end]),cnum([start]))).  Use the same "rowspan" as for
 non-spanning cells. **** -->
<!-- **** Horizontal Span ENTRY - right colspec:
 To find the correct <colspec>s, we use the attrchild() property-
 value function, working from the "namest" and "nameend" attributes
 of the referenced <spanspec> which reference the "colname"
 attribute of the <colspec>s.  The PVF for finding the proper
 <colspec> is:
 attrchild(colname,attr(nameend,[spanspec]),ancestor(tgroup)) (or
 "namest" instead of "nameend" for the starting <colspec>). **** -->
<!-- **** Horizontal Span ENTRY - referenced spanspec:
 To find the referenced <spanspec>, we again use attrchild() based
 on the "spanname" attribute of the CALS <entry>.  The <spanname>
 can be found with:
 attrchild(spanname,attr(spanname),ancestor(tgroup)). **** -->

<style name="TD.SPAN">
   <column> True </>
   <left-indent>   +=tableinfo(cals,left-indent,4)   </>
   <width>   tableinfo(cals,width,4)   </>
   <justification>   tableinfo(cals,justification)   </>
   <text-before> <td colspan=incr(sub(cnum(attrchild(colname,attr(nameend,
                attrchild(spanname,attr(spanname),ancestor(tgroup))),
                ancestor(tgroup))),cnum(attrchild(colname,attr(namest,
                attrchild(spanname,attr(spanname),ancestor(tgroup))),
                ancestor(tgroup))))) rowspan=incr(attr(morerows))>  </>
   <text-after>join('<','/TD'>)</>
</style>

<style name="TH.SPAN">
   <column> True </>
   <left-indent>   +=tableinfo(cals,left-indent,4)   </>
   <width>   tableinfo(cals,width,4)   </>
   <justification>   tableinfo(cals,justification)   </>
   <text-before> <th colspan=incr(sub(cnum(attrchild(colname,attr(nameend,
                attrchild(spanname,attr(spanname),ancestor(tgroup))),
                ancestor(tgroup))),cnum(attrchild(colname,attr(namest,
                attrchild(spanname,attr(spanname),ancestor(tgroup))),
                ancestor(tgroup))))) rowspan=incr(attr(morerows))>  </>
   <text-after>join('<','/TH'>)</>
</style>


<!-- **** HYPERTEXT/HYPERMEDIA *** -->

<style name="RBW-GRAPHIC">
   <select> if(index(attr(filename),'.cgm'),rbw-vector,rbw-raster) </>
</style>

<style name="RBW-RASTER">
   <icon-position> Left </>
	<icon-type> raster </>
   <script> ebt-raster filename=attr(filename) </>
</style>

<style name="RBW-VECTOR">
   <icon-position> Left </>
	<icon-type> vector </>
   <script> ebt-vector filename=attr(filename) </>
</style>

<style name="RBW-NOTE">
   <hide> children </>
   <icon-type> footnote </>
   <icon-position> Inline </>
   <script> ebt-reveal title="Note" stylesheet=fulltext</>
</style>

<!-- A cross-reference is represented by an icon if it does not have
     any associated text; otherwise, its associated text is shown in 
     green to represent the cross-reference -->

<group name="xref-descendent">
   <script> ebt-link target=idmatch(id,attr(refid,parent(RBW-XREF))) </>
</group>

<style name="RBW-XREF">
   <select> if(strip(content(),' ','B'),xref-hot,xref-icon) </>
</style>

<style name="xref-icon">
   <script> ebt-link target=idmatch(id,attr(refid)) </>
   <icon-type> inlink </>
   <icon-position> inline </>
</style>

<!-- The following style determines how "hot-text" cross-references look.
     The "factory setting" is simply that the color is set to green.
     You might wish to add emboldening, etc. -->
<style name="xref-hot">
   <script> ebt-link target=idmatch(id,attr(refid)) </>
   <foreground> #008800 </>
</style>




<!-- **** HTML GROUPS **** -->

<group name="B">
	<font-weight>	Bold	</>
	<text-before><b></>
	<text-after>join('<','/b>')</>
</group>
<group name="I">
	<font-slant>	Italics	</>
	<text-before><i></>
	<text-after>join('<','/i>')</>
</group>
<group name="TT">
	<font-family>	courier	</>
	<font-size>	10	</>
	<text-before><tt></>
	<text-after>join('<','/tt>')</>
</group>
<group name="address">
	<font-family>	Times New Roman	</>
	<font-size>	12	</>
	<font-slant>	Italics	</>
	<break-before>	Line	</>
	<text-before><address></>
	<text-after>join('<','/address>')</>
</group>
<group name="blockquote">
	<left-indent>	+=10	</>
	<space-before>	14	</>
	<break-before>	Line	</>
	<text-before><blockquote></>
	<text-after>join('<','/blockquote>')</>
</group>
<group name="br">
	<break-before>	Line	</>
	<text-before><br></>
</group>
<group name="cite">
	<font-slant>	Italics	</>
	<text-before><cite></>
	<text-after>join('<','/cite>')</>
</group>
<group name="code">
	<font-family>	courier	</>
	<font-size>	10	</>
	<text-before><code></>
	<text-after>join('<','/code>')</>
</group>
<group name="dfn">
	<text-before><dfn></>
	<text-after>join('<','/dfn>')</>
</group>
<group name="dl">
	<space-before>	14	</>
	<break-before>	Line	</>
	<text-before><dl></>
	<text-after>join('<','/dl>')</>
</group>
<group name="dir">
	<left-indent>	+=10	</>
	<space-before>	14	</>
	<break-before>	Line	</>
	<text-before><dir></>
	<text-after>join('<','/dir>')</>
</group>
<group name="dd">
	<font-family>	Times New Roman	</>
	<font-size>	12	</>
	<left-indent>	+=55	</>
	<text-before><dd></>
</group>
<group name="dt">
	<font-family>	Times New Roman	</>
	<font-size>	12	</>
	<width>	50	</>
	<break-before>	Line	</>
	<text-before><dt></>
</group>
<group name="em">
	<font-slant>	Italics	</>
	<text-before><em></>
	<text-after>join('<','/em>')</>
</group>
<group name="h1">
	<font-family>	Times New Roman	</>
	<font-weight>	Bold	</>
	<font-size>	24	</>
	<break-before>	Line	</>
	<line-spacing>	29	</>
	<text-before><h1></>
	<text-after>join('<','/h1>')</>
</group>
<group name="h2">
	<font-family>	Times New Roman	</>
	<font-weight>	Bold	</>
	<font-size>	20	</>
	<break-before>	Line	</>
	<line-spacing>	22	</>
	<text-before><h2></>
	<text-after>join('<','/h2>')</>
</group>
<group name="h3">
	<font-family>	Times New Roman	</>
	<font-weight>	Bold	</>
	<font-size>	16	</>
	<break-before>	Line	</>
	<text-before><h3></>
	<text-after>join('<','/h3>')</>
</group>
<group name="h4">
	<font-family>	Times New Roman	</>
	<font-weight>	Bold	</>
	<font-size>	12	</>
	<break-before>	Line	</>
	<line-spacing>	14	</>
	<text-before><h4></>
	<text-after>join('<','/h4>')</>
</group>
<group name="h5">
	<font-family>	Times New Roman	</>
	<font-weight>	Bold	</>
	<font-size>	10	</>
	<break-before>	Line	</>
	<line-spacing>	12	</>
	<text-before><h5></>
	<text-after>join('<','/h5>')</>
</group>
<group name="h6">
	<font-family>	Times New Roman	</>
	<font-weight>	Bold	</>
	<font-size>	8	</>
	<break-before>	Line	</>
	<line-spacing>	10	</>
	<text-before><h6></>
	<text-after>join('<','/h6>')</>
</group>
<group name="hr">
	<hrule>	Before	</>
	<text-before><hr></>
</group>
<group name="kbd">
	<font-family>	courier	</>
	<font-size>	10	</>
	<text-before><kbd></>
	<text-after>join('<','/kbd>')</>
</group>
<group name="li">
	<font-family>	Times New Roman	</>
	<font-size>	12	</>
	<left-indent>	+=10	</>
	<first-indent>	-10	</>
	<break-before>	Line	</>
	<text-before><li></>
</group>
<group name="menu">
	<left-indent>	+=10	</>
	<space-before>	14	</>
	<break-before>	Line	</>
	<text-before><menu></>
	<text-after>join('<','/menu>')</>
</group>
<group name="ol">
	<left-indent>	+=10	</>
	<space-before>	14	</>
	<break-before>	Line	</>
	<text-before><ol></>
	<text-after>join('<','/ol>')</>
</group>
<group name="strike">
	<text-before><strike></>
	<text-after>join('<','/strike>')</>
</group>
<group name="P">
	<font-family>	Times New Roman	</>
	<font-size>	12	</>
	<space-before>	14	</>
	<break-before>	Line	</>
	<text-before><p></>
	<text-after>join('<','/p>')</>
</group>
<group name="pre">
	<font-family>	courier	</>
	<font-size>	10	</>
	<space-before>	14	</>
	<justification>	Verbatim	</>
	<break-before>	Line	</>
	<text-before><pre></>
	<text-after>join('<','/pre>')</>
</group>
<group name="samp">
	<font-family>	courier	</>
	<font-size>	10	</>
	<text-before><samp></>
	<text-after>join('<','/samp>')</>
</group>
<group name="strong">
	<font-weight>	Bold	</>
	<text-before><strong></>
	<text-after>join('<','/strong>')</>
</group>
<group name="u">
	<text-before><u></>
	<text-after>join('<','/u>')</>
</group>
<group name="ul">
	<text-before><ul></>
	<text-after>join('<','/ul>')</>
</group>
<group name="var">
	<text-before><var></>
	<text-after>join('<','/var>')</>
</group>




<!-- **** DYNAWEB SPECIAL STYLES **** -->

<style name="#ROOT">
	<break-before>	Line	</>
</style>

<style name="#SDATA">
   <text-before>gamut(attr(name),'bull bul trade mdash','&#183;','&#183;','(TM)','--',join('&',attr(name),';'))</>
</style>

<style name="#TAGS">
	<font-weight>	Bold	</>
</style>





<!-- ****************************************** -->
<!-- ****************************************** -->
<!-- ****************************************** -->
<!-- ****************************************** -->
<!-- WHAT FOLLOWS ARE THE AUTO-GENERATED STYLES -->

<style name="RBWSECT-HEADING.1,HEADING.1" group="h1"></>

<style name="RBWSECT-HEADING.2,HEADING.2" group="h2"></>

<style name="RBWSECT-HEADING.3,HEADING.3" group="h3"></>

<style name="HEADING.1">
  <text-before><P><B></>
  <text-after>join('<','/B>','<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
   <font-weight>Bold</>
</style>

<style name="HEADING.2">
  <text-before><P><B><I></>
  <text-after>join('<','/I>','<','/B>','<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
   <font-weight>Bold</>
   <font-slant>Italics</>
</style>

<style name="TABLE">
  <text-before><P><B></>
  <text-after>join('<','/B>','<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
   <font-weight>Bold</>
</style>

<style name="HEADING.3">
  <text-before><P><B></>
  <text-after>join('<','/B>','<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
   <font-weight>Bold</>
</style>

<style name="BULLETED.LIST">
  <text-before><P></>
  <text-after>join('<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
</style>

<style name="PARA">
  <text-before><P></>
  <text-after>join('<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
</style>

<style name="RBWAUTO-0001">
  <text-before><P></>
  <text-after>join('<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
</style>

<style name="RBWAUTO-0007">
  <text-before><I></>
  <text-after>join('<','/I>','')</>
   <font-slant>Italics</>
</style>

<style name="RBWAUTO-0014">
  <text-before><P><B></>
  <text-after>join('<','/B>','<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
   <font-weight>Bold</>
</style>

<style name="RBWAUTO-0013">
  <text-before><P></>
  <text-after>join('<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
</style>

<style name="BULLETED.LIST,RBW-MARKER" group="hide"></>

<style name="RBWAUTO-0001,RBW-MARKER" group="hide"></>

<style name="NORMAL">
  <text-before><P></>
  <text-after>join('<','/P>','')</>
   <font-family>Times New Roman</>
   <font-size>12</>
   <space-before>14</>
   <break-before>Line</>
</style>


