***************************************************************************
**  Property of Texas Instruments Incorporated                            *
**                                                                        *
**  Unauthorized reproduction and/or distribution is strictly             *
**  prohibited.  (C) Copyright 1994 Texas Instruments Incorporated.       *
**  All rights reserved.                                                  *
**                                                                        *
**  These commodities, technical data, and software may be U.S. export    *
**  license controlled.  As such, prior to export or re-export, U.S.      *
**  Government approval and authorization may be required.                *
**                                                                        *
**  PLEASE BE AWARE THAT IN THE ABSENCE OF A SIGNED, WRITTEN AGREEMENT    *
**  TO THE CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
**  MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR IMPLIED.        *
**  Further, TI assumes no liability for: 1) the accuracy of the SPICE    *
**  models provided to your company; 2) the proper functioning of these   *
**  SPICE models in your design or for any resulting applications;  or    *
**  3) infringement of patents, copyrights or intellectual property       *
**  rights resulting from your use of these SPICE models.                 *
**                                                                        *
**  TI provides SPICE models as a service to our customers.  You and      *
**  your company shall not distribute, convey, sell or give these         *
**  models to anyone else without receiving prior written permission      *
**  from TI.                                                              *
**                                                                        *
**  TI reserves the right to make changes to its products or to           *
**  discontinue any semiconductor product or service without notice,      *
**  and advises its customers to obtain the latest version of relevant    *
**  information to verify, before placing orders, that the information    *
**  being relied on is current.                                           *
**                                                                        *
**  Please be aware that your receipt and subsequent use of the SPICE     *
**  information provided shall serve as acceptance of the terms and       *
**  conditions of this agreement.  If you do not accept these terms,      *
**  you should return the SPICE model and any other accompanying          *
**  information immediately.                                              *
***************************************************************************
**CDC351 SPICE I/O Model
**Advanced System Logic, Texas Instruments
****************************************************************
*
*NOTE:
*   The following files must be present to use this SPICE model:
*      351.CDC                 (netlist)
*      EPIC2BS.LIB             (Library file for process models)
*      EPIC2BSN.13             (Nominal process models, CMOS Level 13)
*      EPIC2BSS.13             (Strong  process models, CMOS Level 13)
*      EPIC2BSW.13             (Weak    process models, CMOS Level 13)
*      EPIC2BSN.3              (Nominal process models, CMOS Level 3)
*      EPIC2BSS.3              (Strong  process models, CMOS Level 3)
*      EPIC2BSW.3              (Weak    process models, CMOS Level 3)
*      PKGS.LIB                (Library file for packages)
*      SOIC24.PKG              (Package parasitics)
*      READ.ME                 (General use, release notes, ...)
*
*INSTRUCTIONS:
*   To use this SPICE model, include the following lines in your main netlist:
*      .
*      .
*      .
*      .INCLUDE '351.CDC'
*      XCDC351_IN     1     2     199   100               CDC351IN
*      XCDC351_OUT    4     5     6     199   100         CDC351OUT
*      .
*      .
*      .
*
*   The diagrams below describe the nodes for the subcircuits:
*
*                                                   /|\
*                     ----                           |
*                     |   \                          |
*      Node 1  _______|    \___  Node 2          Node 199(VCC)
*                     |    /                     Node 100(GND)
*                     |   /                          |
*                     ----                           |
*                                                   ---
*               CDC351IN (Input Buffer)               -
* 
*
*                      | Node 6                     /|\
*                      |                             |
*                      O                             |
*                     ----                       Node 199(VCC)
*                    /    |                      Node 100(GND)
*      Node 5  _____/     |___  Node 4               |
*                   \     |                          |
*                    \    |                         ---
*                     ----                           -
*
*               CDC351OUT (Output Buffer)
*
*       
*   Please refer to the 'READ.ME' file for general instructions for use.
*
*    CDC351 SPICE I/O MODEL SUBCIRCUIT
*    LSI 
*    ADVANCED SYSTEM LOGIC, TEXAS INSTRUMENTS
*
*    SUBCIRCUITS:  CDC351IN, CDC351OUT
*
*    PACKAGE PARASITICS
        .LIB 'PKGS.LIB'   SOIC24
*
*    PROCESS MODELS 
	.LIB 'EPIC2BS.LIB' NOMINAL_L13
*       .LIB 'EPIC2BS.LIB' STRONG_L13
*       .LIB 'EPIC2BS.LIB' WEAK_L13
*
* CDC351 INPUT SUBCIRCUIT
*    NODES:        INPUT NODE
*                  |     INTERNAL OUTPUT NODE 
*                  |     |     VCC
*                  |     |     |     GND
*                  |     |     |     |
.SUBCKT CDC351IN   1     2     199   100  
 X_PKGIN           1     1001                    SOIC24_06
 X_PKGVCC          199   1199                    SOIC24_03
 X_PKGGND          100   1100                    SOIC24_01
 XCDC351IN         1001  2     1199  1100        CDC351__IN
.ENDS CDC351IN
*                         
* CDC351 OUTPUT SUBCIRCUIT   
*    NODES:        INTERNAL INPUT NODE
*                  |     OUTPUT NODE
*                  |     |     INTERNAL OE NODE
*                  |     |     |     VCC
*                  |     |     |     |     GND
*                  |     |     |     |     |
.SUBCKT CDC351OUT  4     5     6     199   100  
 X_PKGOUT          5     1005                    SOIC24_02
 X_PKGVCC          199   1199                    SOIC24_03
 X_PKGGND          100   1100                    SOIC24_01
 XCDC351OUT        4     1005  6     1199  1100  CDC351__OUT
.ENDS CDC351OUT
*
.SUBCKT CDC351__IN  551 552 599 500
XP1    552 502 599 599  PM  WP=600U LP=0.8U
XN1    552 502 500 500  NM  WN=284U LN=0.8U
XINV1  503 552 599 500  INV WP1=25U WN1=20U
XINV2  552 503 599 500  INV WP1=15U WN1=5U
QESD1  551 500 500      Q7_NPN 200
QESD2  502 501 500      Q5_NPN 48
R2     551 502          50
R3     501 500          758
CP     551 500          0.3P
.ENDS CDC351__IN
*
.SUBCKT CDC351__OUT  551 552 553 599 500
XP1     512 507 509 599     PM     WP=150U  LP=0.8U
XP2     599 553 512 599     PM     WP=250U  LP=0.8U
XP3     521 553 551 599     PM     WP=40U   LP=0.8U
XP5     508 551 512 599     PM     WP=75U   LP=0.8U
XP100   510 555 599 599     PM     WP=100U  LP=0.8U
XP101   510 554 599 599     PM     WP=100U  LP=0.8U
XP102   552 510 599 599     PM     WP=1300U LP=0.8U
XN2     509 551 501 500     NM     WN=130U  LN=0.8U
XN3     501 554 500 500     NM     WN=40U   LN=0.8U
XN4     501 553 500 500     NM     WN=60U   LN=0.8U
XN5     508 551 500 500     NM     WN=30U   LN=0.8U
XN6     508 553 500 500     NM     WN=30U   LN=0.8U
XN9     521 517 551 500     NM     WN=20U   LN=0.8U
XN10    521 553 500 500     NM     WN=30U   LN=0.8U
XN11    522 521 500 500     NM     WN=150U  LN=0.8U
XN100   510 555 511 500     NM     WN=100U  LN=0.8U
XN101   511 554 500 500     NM     WN=100U  LN=0.8U
XINV1   553 517 599 500     INV    WP1=15U  WN1=5U
XINV2   555 503 599 500     INV    WP1=6U   WN1=6U
XINV4   505 506 599 500     INV    WP1=6U   WN1=6U
XINV5   506 507 599 500     INV    WP1=6U   WN1=6U
XINV6   553 555 599 500     INV    WP1=160U WN1=80U
XINVM6  551 554 599 500     INV    WP1=45U  WN1=45U
XR2     509 512 512 512     RMOS   WR=6U    RES=1.5K
XNOR    503 554 505 599 500 NOR2   WP1=15U  WP2=15U  WN1=15U  WN2=15U
Q1      502 508 504         Q2_NPN 10
Q2      599 553 510         Q2_NPN 10
Q3      502 504 552         Q100   100
Q4      552 501 500         Q300   250
Q5      599 551 510         Q2_NPN 10
QESD    552 500 500         Q7_NPN 200
QD3     504 504 508         Q1_NPN 5 
D1      501 552             D400   600
D6      508 502             D100   100
D5      599 502             D900   800
D10     599 502             D900   800
RESD    522 552                    100
.ENDS CDC351__OUT
*
.SUBCKT INV  551 552 599 500  WP1=10U WN1=10U
XP      552 551 599 599  PM WP='WP1' LP=0.8U
XN      552 551 500 500  NM WN='WN1' LN=0.8U
.ENDS INV
*
.SUBCKT NOR2  551 552 553 599 500  WP1=20U WP2=20U WN1=4U WN2=4U
XP1     501 552 599 599  PM WP='WP1' LP=0.8U
XP2     553 551 501 599  PM WP='WP2' LP=0.8U
XN1     553 551 500 500  NM WN='WN1' LN=0.8U
XN2     553 552 500 500  NM WN='WN2' LN=0.8U
.ENDS NOR2
*                                                CDC35196047GL
