/*  File:       minpal.h


    Function:   Logic Minimization for PAL type devices.


    Omission:   If you don't include this header, no functions are
                minimized.


    Example:    Statements conditioned by an if-else statement are
                minimized.  Thus the statement

                        if (1) a= expression;

                  yields

                        a = minimized expression;

                  and

                        MINIMIZE {
                            x=...;
                            y=...;
                        }

                  yields minimized expressions for all statements
                  within the block.


    Method:     The '_Minimize' attribute is applied by the user, the compiler
                or by other attribute blocks to those functions which require
                minimization.  Perform PAL minimization on these functions.


    Revision:   89.4.10 */


define MINIMIZE = if (1);


_Attribute _Minimize(_Any) {
    /* apply sum-of-products minimization as it occurs */
    _Vref*=_Mpal _Minimize _Var;
}
