/*  File:       moe.h

    Function:   Automatic Tri-State Buffer Enable for COMBINATORIAL
                P22V10-type Macrocells

    Example:    On the p22v10, if you write an assignment for

                    ! pin23 = ... ;
                or
                    pin23 = ... ;

                but don't write one for

                    pin23.oe = ... ;

                this header file creates an automatic

                    pin23.oe = 1 ;

    Omitting this header:

                If you don't include this header file, you'll need to write
                output enable signals for all the macrocells because the signal
                specification defaults to unprogrammed.

    Related headers:

                poe.h is used for p16l8-type combinatorial outputs.

    Method:     The Device Description Header applies the '_moe' attribute
                to output macrocells of p22v10-type devices.

    Revision:   88.4.10 */

_Attribute _moe {
if (_Vsignal.oe _Dfunction _Size==0) {
    /* there is no assignment to <signal>.oe */
    if (_Vsignal."" _Dfunction _Size==1)
        /* there is a combinatorial user assignment to the macrocell */
        if (_Vsignal."" _Dfunction _Value != q)
            /* it is not a polarity control for a register */
            _Vsignal.oe=1;
    _Vref*=_moe _Var;
    }
}
