// 2011.07.01 V1.0
//****************************************
//**  Copyright  (C)  W.ch  1999-2011   **
//**  Web:  http://www.winchiphead.com  **
//****************************************
//**  DLL for PCI interface chip CH367/8**
//**  C, VC5.0                          **
//****************************************
//
// PCIe߽ӿоƬCH367Ӧòӿڿ V1.0
// Ͼߺ޹˾ : TECH30 2011.07
// CH367-DLL  V1.0 ,    Support: IO/MEM/INT
// л: Windows 98/ME, Windows 2000/XP/7
//
/* !!ע:
     1.CH367DLLӿӦCH367&CH368оƬ,CH367ͷĺCH367CH368,CH368ͷĺֻCH368оƬ,CH367.   
     2.CH368֧PCֽڣ˫֣ΪλI/O ˿ڻߴ洢жд
       CH367mReadIoWord/CH367mWriteIoWordֲʱʼַǻַΧڵֱ߽ĵַ2 ı
       CH367mReadIoDword/CH367mWriteIoDword/CH368ReadMemDword/CH368WriteMemDwordֽڴȡʱʼַǻַΧڵ˫ֱ߽ĵַ4 ı
*/

#ifndef		_CH367_DLL_H
#define		_CH367_DLL_H

#ifdef __cplusplus
extern "C" {
#endif


#define		mOFFSET( s, m )			( (ULONG_PTR) & ( ( ( s * ) 0 ) -> m ) )	// ȡṹԱƫƵַĺ

#ifndef		max
#define		max( a, b )				( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )	// ϴֵ
#endif

#ifndef		min
#define		min( a, b )				( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )	// Сֵ
#endif

#ifdef		ExAllocatePool
#undef		ExAllocatePool						// ɾTAGڴ
#endif

#ifndef		NTSTATUS
typedef		LONG	NTSTATUS;					// ״̬
#endif


typedef	struct	_PCI_CONFIG {					// PCIÿռݽṹ
	USHORT			mPcVendorId;				// 00H Ӧ̱ʶ
	USHORT			mPcDeviceId;				// 02H 豸ʶ
	USHORT			mPcCommandReg;				// 04H Ĵ
	USHORT			mPcStatusReg;				// 06H ״̬Ĵ
	UCHAR			mPcRevisionId;				// 08H ޸ıʶ
	UCHAR			mPcProgramIf;				// 09H Ĵ̽ӿ
	UCHAR			mPcSubClass;				// 0AH 
	UCHAR			mPcBaseClass;				// 0BH 
	UCHAR			mPcCacheLine;				// 0CH г
	UCHAR			mPcLatenTimer;				// 0DH ӳټ
	UCHAR			mPcHeaderType;				// 0EH ͷ
	UCHAR			mPcBistReg;					// 0FH ںԲԼĴ
	ULONG			mPcBaseAddr0;				// 10H ַĴ0
	ULONG			mPcBaseAddr1;				// 14H ַĴ1
	ULONG			mPcBaseAddr2;				// 18H ַĴ2
	ULONG			mPcBaseAddr3;				// 1CH ַĴ3
	ULONG			mPcBaseAddr4;				// 20H ַĴ4
	ULONG			mPcBaseAddr5;				// 24H ַĴ5
	ULONG			mPcCardCis;					// 28H
	USHORT			mPcSubSysVen;				// 2CH ϵͳӦ̱ʶ
	USHORT			mPcSubSysDev;				// 2EH ϵͳ豸ʶ
	ULONG			mPcExpansRom;				// 30H չROMַĴ
	UCHAR			mPcCapPtr;					// 34H
	UCHAR			mPcReserved1[3];			// 35H
	ULONG			mPcReserved2;				// 38H
	UCHAR			mPcInterLine;				// 3CH ж߼Ĵ
	UCHAR			mPcInterPin;				// 3DH жżĴ
	UCHAR			mPcMinGrant;				// 3EH
	UCHAR			mPcMaxLatency;				// 3FH
} mPCI_CONFIG, *mPPCI_CONFIG;

typedef	struct	_PCI_EXP_ROM {					// PCIչROMݽṹ
	UCHAR			mPerRomSig[4];				// 00H PCIչROMǩַ'PCIR'
	USHORT			mPerVendorId;				// 04H Ӧ̱ʶ
	USHORT			mPerDeviceId;				// 06H 豸ʶ
	USHORT			mPerVpdPtr;					// 08H ҪƷָ
	USHORT			mPerStrucLen;				// 0AH PCIչROMݽṹĳ
	UCHAR			mPerRevision;				// 0CH PCIչROMݽṹ޸İ汾
	UCHAR			mPerProgramIf;				// 0DH Ĵ̽ӿ
	UCHAR			mPerSubClass;				// 0EH 
	UCHAR			mPerBaseClass;				// 0FH 
	USHORT			mPerImageLen;				// 10H ӳ񳤶
	USHORT			mPerImageRev;				// 12H ӳд/ݵ޸İ汾
	UCHAR			mPerCodeType;				// 14H 
	UCHAR			mPerIndicator;				// 15H ӳָʾ־
	USHORT			mPerReserved;				// 16H
} mPCI_EXP_ROM, *mPPCI_EXP_ROM;

typedef	struct	_CH367_IO_REG {	                //CH367оƬI/OռĴ
	UCHAR mCH367IoPort[0xE8];                     //00H-E7H,232ֽΪ׼I/O˿
	UCHAR mCH367GPOR;	                        //E8H ͨĴ
	UCHAR mCH367GPVR;	                        //E9H ͨñĴ
	UCHAR mCH367GPIR;	                        //EAH ͨĴ
	UCHAR mCH367IntCtr;	                        //EBH жϿƼĴ
	union{
		UCHAR mCH367IoBuf8;                     //ECH 8λнӿݻ
		ULONG mCH367IoBuf32;                    //ECH 32λнӿݻ
	};
	union{
		USHORT mCH368MemAddr;                   //F0H 洢ӿ: A15-A0ַ趨Ĵ ??
		struct{
			UCHAR mCH368MemAddrL;               //F0H 洢ӿ: A7-A0ַ趨Ĵ
			union{
				UCHAR mCH368MemAddrH;           //F1H 洢ӿ: A15-A8ַ趨Ĵ
				UCHAR mCH367GPOR2;              //F1H ͨĴ2 ??
			};
		}ASR;
	};
	UCHAR mCH367IORESV2;                        //F2H
	UCHAR mCH368MemData;                        //F3H 洢ӿ: 洢ݴȡĴ
	union{
		UCHAR mCH367Data8Sta;                   //F4H D7-D0˿״̬Ĵ
		ULONG mCH367SData32Sta;                 //F4H D31-D0˿״̬Ĵ
	};
	UCHAR mCH367Status;                         //F8H ƺ״̬Ĵ
	UCHAR mCH367IO_RESV3;                       //F9H
	UCHAR mCH367Speed;                          //FAH дٶȿƼĴ
	UCHAR mCH367PDataCtrl;                      //FBH нӿڿƼĴ
	UCHAR mCH367IoTime;                         //FCH ӲѭĴ
	UCHAR mCH367SPICtrl;                        //FDH SPIƼĴ
	UCHAR mCH367SPIData;                        //FEH SPIݼĴ
	UCHAR mCH367IO_RESV4;                       //FFH
} mCH367_IO_REG, *mPCH367_IO_REG;

typedef	struct	_CH368_MEM_REG {				// CH367оƬĴ洢ռ
	UCHAR			mCH368MemPort[0x8000];		// 0000H-7FFFH,32768ֽΪ׼Ĵ洢Ԫ
} mCH368_MEM_REG, *mPCH368_MEM_REG;

typedef	struct	_WIN32_COMMAND {				// WIN32ӿڽṹ
	union	{
		ULONG		mFunction;					// ʱָܴ
		NTSTATUS	mStatus;					// ʱز״̬
	};
	ULONG			mLength;					// ȡ,غݵĳ
	union	{
		PVOID			mAddress;				// ʼַ,صַ
		ULONGLONG		mAddress64;				// ʼַ,صַ
	};
	UCHAR			mBuffer[8];					// ݻ,Ϊ032KB
} mWIN32_COMMAND, *mPWIN32_COMMAND;

// WIN32Ӧòӿ
#define		IOCTL_CH367_COMMAND		( FILE_DEVICE_UNKNOWN << 16 | FILE_ANY_ACCESS << 14 | 0x0f36 << 2 | METHOD_BUFFERED )	// רýӿ

#define		mWIN32_COMMAND_HEAD		mOFFSET( mWIN32_COMMAND, mBuffer )	// WIN32ӿڵͷ

#define		mCH367_MAX_NUMBER		16			// ͬʱӵCH367

#define		mMAX_BUFFER_LENGTH		max( sizeof( mCH367_IO_REG ), sizeof( mCH368_MEM_REG ) )	// ݻ󳤶

#define		mMAX_COMMAND_LENGTH		( mWIN32_COMMAND_HEAD + mMAX_BUFFER_LENGTH )	// ݳȼṹͷĳ

#define		mCH368_MEM_BASE_AUTO	( (PVOID)(ULONG_PTR)0xffffffff )	// Զ趨CH368Ĵ洢ַ

#define		mCH367_INT_LINE_AUTO	0xffffffff				// ԶCH367жϺ

// Ĵλ
//0xE8
#define		mBitI2cSdaOut           0x01        //趨SDA ŵֵ(1),1*:high,0:low
#define		mBitI2cSclOut           0x02        //趨SCL ŵֵ(1)
#define		mBitSpiScsOut           0x04        //趨SCS ŵֵ(1)
#define		mBitBeWakenEnable       0x32        //ʹֱ֧ǿƻ(0)
#define		mBitSetSpiSdxDir        0x64        //趨SDX ŵݷ(0)
//0xEA
#define		mBitSpiSdxOut           0x01        //SDA ŵ״̬(1)
#define		mBitIntStatus           0x08        //INT#ŵ״̬(1)
#define		mBitRDStatus            0x10        //RD#ŵ״̬(1)
#define		mBitWRStatus            0x20        //WR#ŵ״̬(1)
#define		mBitAddrStatus          0x40        //ADDR ŵ״̬(1)
#define		mBitSdxStatus           0x80        //SDX ŵ״̬(1)
//0xEB
#define		mBitGlobalIntEnable     0x02        //ȫжʹ(0)
#define		mBitIntPolarity         0x04        //INT#жļ(0),0:͵ƽ/;1:ߵƽ/½
#define		mBitIntInType           0x08        //INT#ж(0)
//0xF8:
#define		mBitAddr15Out           0x01        //趨A15 ŵֵ(1)
#define		mBitIntAction           0x04        //жϼ״̬(0)
#define		mBitIntStatus           0x08        //INT#ŵ״̬(1)     
#define		mBitRST0Out             0x80        //趨RSTO ŵֵ(1)
//0xFA
#define		mBitSpeedInact          0xFA        //ʱͱʱĶдźܿ(0111)
#define		mBitDataAddrOutCreate   0x10        //ݺ͵ַʱ(0),0:15nS,1:45nS
#define		mBitDataAddrOutKeep     0x20        //ݺ͵ַʱ(0),0:15nS,1:45nS
#define		mBitLocalBusWidth       0x40        //߿(0),0:8λ,1:32λ
//0xFD
#define		mBitHWCountH4           0x0F        //Ӳѭĸ4 λ(XXXX),ӲѭĴCNTR һ12 λ
#define		mBitSpiTransportStatus  0x10        //SPI ڽ״̬(0),0:,1:ڴ
#define		mBitSpiClockFreq        0x20        //ѡSPI ʱƵ(0),0:31.3MHz,1:15.6MHz
#define		mBitSelSpiInPin         0x40        //ѡSPI (0),0:SDK,1:ADDR
#define		mBitStartNewSPITrans    0x80        //ʹܶSPIDR ´(0),0:,1:


// ӦòӿڵĹܴ
#define		mFuncNoOperation		0x00000000	// ޲
#define		mFuncGetVersion			0x00000001	// ȡ汾
#define		mFuncGetIoBaseAddr		0x00000004	// ȡI/O˿ڻַ
#define		mFuncSetIoBaseAddr		0x00000005	// I/O˿ڻַ
#define		mFuncGetMemBaseAddr		0x00000006	// ȡ洢ַ
#define		mFuncSetMemBaseAddr		0x00000007	// ô洢ַ,Զ趨洢ַ
#define		mFuncGetInterLine		0x00000008	// ȡжϺ
#define		mFuncSetInterLine		0x00000009	// жϺ,ԶжϺ
#define		mFuncWaitInterrupt		0x0000000a	// ȴж,ֱCH367ж
#define		mFuncAbortWaitInter		0x0000000b	// ȴж,ֹȴ
#define		mFuncSetExclusive		0x0000000c	// öռʹ
#define		mFuncReadIoByte			0x00000010	// ȡ˿,ͬһ˿ڵַֽΪλȡ
#define		mFuncReadIoWord			0x00000011	// ȡ˿,ͬһ˿ڵַΪλȡ
#define		mFuncReadIoDword		0x00000012	// ȡ˿,ͬһ˿ڵַ˫Ϊλȡ
#define		mFuncReadIoBlock		0x00000013	// ȡ˿,ÿȡһֽ,˿ڵַһ
#define		mFuncReadIo32Block		0x00000028	// ȡ˿,ÿȡֽ,˿ڵַ,󳤶232B(ƫƵַ00HE7H)
#define		mFuncWriteIoByte		0x00000014	// д˿,ͬһ˿ڵַֽΪλд
#define		mFuncWriteIoWord		0x00000015	// д˿,ͬһ˿ڵַΪλд
#define		mFuncWriteIoDword		0x00000016	// д˿,ͬһ˿ڵַ˫Ϊλд
#define		mFuncWriteIoBlock		0x00000017	// д˿,ÿдһֽ,˿ڵַһ
#define		mFuncWriteIo32Block		0x00000029	// д˿,ÿдһֽ,˿ڵַ,󳤶232B(ƫƵַ00HдE7H)
#define		mFuncReadMemByte		0x00000018	// ȡ洢/Ĵ
#define		mFuncReadMemDword		0x0000001a	// ȡ洢/Ĵ
#define		mFuncWriteMemByte		0x0000001c	// д洢/Ĵ
#define		mFuncWriteMemDword		0x0000001e	// д洢/Ĵ
#define		mFuncReadConfig			0x00000020	// ȡPCIÿռ
#define		mFuncWriteConfig		0x00000021	// дPCIÿռ
#define		mFuncReadBuffer1		0x00000024	// ȡж1
#define		mFuncWriteBuffer1		0x00000025	// дж1
#define		mFuncReadBuffer2		0x00000026	// ȡж2
#define		mFuncWriteBuffer2		0x00000027	// дж2

#define		mFuncStreamSPI	    	0x0000002A	// SPI亯
#define		mFuncSetStreamMode    	0x0000002B	// SPIΪSPI3SPI4
#define		mFuncSetInterMode    	0x0000002C	// жϼԼ


#define		mFuncFlashLock    	0x0000002D	// Flash-ROM洢д趨 
#define		mFuncFlashRead    	0x0000002E	// Flash-ROM洢ȡݿ
#define		mFuncFlashErase    	0x0000002F	// Flash-ROM洢ָв,ÿ4096ֽڼ4KΪһ,Сλ
#define		mFuncFlashWrite    	0x00000030	// Flash-ROM洢дݿ

typedef		VOID	( CALLBACK	* mPCH367_INT_ROUTINE ) ( VOID );		// жϷ



HANDLE	WINAPI	CH367OpenDevice(  // CH367豸,ؾ,Ч
	BOOL			iEnableMemory,  // ǷҪִ֧洢,CH367оƬ֧,CH368оƬ֧
	BOOL			iEnableInterrupt,  // ǷҪ֧ж
    UCHAR           iInterruptMode ); // λ0:жļ1:ߵƽ/½;0:͵ƽ/;λ1:ж 1:,0:ƽ


VOID	WINAPI	CH367CloseDevice( );  // رCH367豸


ULONG	WINAPI	CH367GetVersion( );  // DLL汾,ذ汾


ULONG	WINAPI	CH367DriverCommand(  // ֱӴ,򷵻0,򷵻ݳ
	mPWIN32_COMMAND	ioCommand );  // ṹָ
// óڵú󷵻ݳ,Ȼṹ,Ƕ,ݷṹ,
// صݳڲʧʱΪ0,ɹʱΪṹĳ,һֽ,򷵻mWIN32_COMMAND_HEAD+1,
// ṹڵǰ,ֱṩ:ܴ,ʼַ(ѡ),ȡݵĳ(ѡ),
// ṹڵú,ֱ𷵻:״̬,صĻַ(ѡ),ݵĳ(ѡ),
// ״̬WINDOWSĴ,ԲοNTSTATUS.H,
// صĻַֻ:ȡI/Oַ,ȡ洢ַ,ȡжϺ,򱣳ʱʼַ
// ݵĳָصݳ,ݴĻ,дһΪ0

ULONG	WINAPI	CH367GetDrvVersion( );  // 汾,ذ汾,򷵻0


BOOL	WINAPI	CH367GetIoBaseAddr(  // ȡI/O˿ڵĻַ
	mPCH367_IO_REG	*oIoBaseAddr );  // I/O˿ڻַĵԪַ


BOOL	WINAPI	CH367SetIoBaseAddr(  // 趨I/O˿ڵĻַ
	mPCH367_IO_REG	iIoBaseAddr );  // ָI/O˿ڻַ


BOOL	WINAPI	CH368GetMemBaseAddr(  // ȡ洢Ļַ
	mPCH368_MEM_REG	*oMemBaseAddr );  // 洢ַĵԪַ


BOOL	WINAPI	CH368SetMemBaseAddr(  // 趨洢Ļַ
	mPCH368_MEM_REG	iMemBaseAddr );  // ָ洢ַ,Ϊ0رմ洢,Ϊ-1Զ趨


BOOL	WINAPI	CH367GetIntLine(  // ȡжϺ
	PULONG			oIntLine );  // жϺŵĵԪַ


BOOL	WINAPI	CH367SetIntLine(  // 趨жϺ
	ULONG			iIntLine,  // ָжϺ,Ϊ0رж,Ϊ-1ԶⲢ趨
	UCHAR           iInterruptMode ); // λ0:жļ1:ߵƽ½;0:͵ƽ;λ1:ж 1:,0:ж


BOOL	WINAPI	CH367WaitInterrupt( );  // ȴж¼


BOOL	WINAPI	CH367AbortWaitInt( );  // ȴж


BOOL	WINAPI	CH367SetIntRoutine(  // 趨жϷ
	mPCH367_INT_ROUTINE	iIntRoutine );  // ָжϷ,ΪNULLȡжϷ,жʱøó


BOOL	WINAPI	CH367ReadIntCommand(  // ȡж
	mPWIN32_COMMAND	oCommand,  // ָһ㹻Ļ,ڱȡṹ
	ULONG			iCmdIndex );  // ж,Ϊ12


BOOL	WINAPI	CH367WriteIntCommand(  // дж
	mPWIN32_COMMAND	iCommand,  // ָΪжṹ
	ULONG			iCmdIndex );  // ж,Ϊ12


BOOL	WINAPI	CH367ReadIoByte(  // I/O˿ڶȡһֽ
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH367ReadIoWord(  // I/O˿ڶȡһ
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	PUSHORT			oWord );  // ָһֵԪ,ڱȡ


BOOL	WINAPI	CH367ReadIoDword(  // I/O˿ڶȡһ˫
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	PULONG			oDword );  // ָһ˫ֵԪ,ڱȡ˫


BOOL	WINAPI	CH367WriteIoByte(  // I/O˿дһֽ
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH367WriteIoWord(  // I/O˿дһ
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	USHORT			iWord );  // д


BOOL	WINAPI	CH367WriteIoDword(  // I/O˿дһ˫
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	ULONG			iDword );  // д˫


BOOL	WINAPI	CH368ReadMemByte(  // Ӵ洢ȡһֽ
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH368ReadMemDword(  // Ӵ洢ȡһ˫
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	PULONG			oDword );  // ָһ˫ֵԪ,ڱȡ˫


BOOL	WINAPI	CH368WriteMemByte(  // 洢дһֽ
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH368WriteMemDword(  // 洢дһ˫
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	ULONG			iDword );  // д˫


BOOL	WINAPI	CH367ReadConfig(  // ÿռȡһֽ
	PVOID			iOffset,  // ָƫƵַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH367WriteConfig(  // ÿռдһֽ
	PVOID			iOffset,  // ָƫƵַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH368SetA15_A8(  // øߵַ,A15-A8
	UCHAR			iA15_A8 );  // λ7-λ0ӦA15-A8,1Ϊߵƽ,0Ϊ͵ƽ


BOOL	WINAPI	CH367ReadI2C(  // I2Cӿڶȡһֽ
	UCHAR			iDevice,  // 7λָI2C豸ַ
	UCHAR			iAddr,  // ָݵԪĵַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH367WriteI2C(  // I2Cӿдһֽ
	UCHAR			iDevice,  // 7λָI2C豸ַ
	UCHAR			iAddr,  // ָݵԪĵַ
	UCHAR			iByte );  // дֽ


  HANDLE	WINAPI	CH367mOpenDevice(  // CH367豸,ؾ,Ч
	ULONG			iIndex,  // ָCH367豸,0Ӧһ豸
	BOOL			iEnableMemory,  // ǷҪִ֧洢,CH367оƬ֧,CH368оƬ֧
	BOOL			iEnableInterrupt,  // ǷҪ֧ж
    UCHAR           iInterruptMode ); // λ0:жļ1:ߵƽ/½;0:͵ƽ/;λ1:ж 1:,0:ƽ

VOID	WINAPI	CH367mCloseDevice(  // رCH367豸
	ULONG			iIndex );  // ָCH367豸


ULONG	WINAPI	CH367mDriverCommand(  // ֱӴ,򷵻0,򷵻ݳ
	ULONG			iIndex,  // ָCH367豸
	mPWIN32_COMMAND	ioCommand );  // ṹָ
// óڵú󷵻ݳ,Ȼṹ,Ƕ,ݷṹ,
// صݳڲʧʱΪ0,ɹʱΪṹĳ,һֽ,򷵻mWIN32_COMMAND_HEAD+1,
// ṹڵǰ,ֱṩ:ܴ,ʼַ(ѡ),ȡݵĳ(ѡ),
// ṹڵú,ֱ𷵻:״̬,صĻַ(ѡ),ݵĳ(ѡ),
//   ״̬WINDOWSĴ,ԲοNTSTATUS.H,
//   صĻַֻ:ȡI/Oַ,ȡ洢ַ,ȡжϺ,򱣳ʱʼַ
//   ݵĳָصݳ,ݴĻ,дһΪ0


BOOL	WINAPI	CH367mGetIoBaseAddr(  // ȡI/O˿ڵĻַ
	ULONG			iIndex,  // ָCH367豸
	mPCH367_IO_REG	*oIoBaseAddr );  // I/O˿ڻַĵԪַ


BOOL	WINAPI	CH367mSetIoBaseAddr(  // 趨I/O˿ڵĻַ
	ULONG			iIndex,  // ָCH367豸
	mPCH367_IO_REG	iIoBaseAddr );  // ָI/O˿ڻַ


BOOL	WINAPI	CH368mGetMemBaseAddr(  // ȡ洢Ļַ
	ULONG			iIndex,  // ָCH367豸
	mPCH368_MEM_REG	*oMemBaseAddr );  // 洢ַĵԪַ


BOOL	WINAPI	CH368mSetMemBaseAddr(  // 趨洢Ļַ
	ULONG			iIndex,  // ָCH367豸
	mPCH368_MEM_REG	iMemBaseAddr );  // ָ洢ַ,Ϊ0رմ洢,Ϊ-1Զ趨


BOOL	WINAPI	CH367mGetIntLine(  // ȡжϺ
	ULONG			iIndex,  // ָCH367豸
	PULONG			oIntLine );  // жϺŵĵԪַ


BOOL	WINAPI	CH367mSetIntLine(  // 趨жϺ
	ULONG			iIndex,  // ָCH367豸
	ULONG			iIntLine, // ָжϺ,Ϊ0رж,Ϊ-1ԶⲢ趨
	UCHAR           iInterruptMode ); // λ0:жļ1:ߵƽ½;0:͵ƽ;λ1:ж 1:,0:ж


BOOL	WINAPI	CH367mWaitInterrupt(  // ȴж¼
	ULONG			iIndex );  // ָCH367豸


BOOL	WINAPI	CH367mAbortWaitInt(  // ȴж
	ULONG			iIndex );  // ָCH367豸


BOOL	WINAPI	CH367mSetIntRoutine(  // 趨жϷ
	ULONG			iIndex,  // ָCH367豸
	mPCH367_INT_ROUTINE	iIntRoutine );  // ָжϷ,ΪNULLȡжϷ,жʱøó


BOOL	WINAPI	CH367mReadIntCommand(  // ȡж
	ULONG			iIndex,  // ָCH367豸
	mPWIN32_COMMAND	oCommand,  // ָһ㹻Ļ,ڱȡṹ
	ULONG			iCmdIndex );  // ж,Ϊ12


BOOL	WINAPI	CH367mWriteIntCommand(  // дж
	ULONG			iIndex,  // ָCH367豸
	mPWIN32_COMMAND	iCommand,  // ָΪжṹ
	ULONG			iCmdIndex );  // ж,Ϊ12


BOOL	WINAPI	CH367mReadIoByte(  // I/O˿ڶȡһֽ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH367mReadIoWord(  // I/O˿ڶȡһ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	PUSHORT			oWord );  // ָһֵԪ,ڱȡ


BOOL	WINAPI	CH367mReadIoDword(  // I/O˿ڶȡһ˫
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	PULONG			oDword );  // ָһ˫ֵԪ,ڱȡ˫


BOOL	WINAPI	CH367mWriteIoByte(  // I/O˿дһֽ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH367mWriteIoWord(  // I/O˿дһ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	USHORT			iWord );  // д


BOOL	WINAPI	CH367mWriteIoDword(  // I/O˿дһ˫
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָI/O˿ڵĵַ
	ULONG			iDword );  // д˫


BOOL	WINAPI	CH368mReadMemByte(  // Ӵ洢ȡһֽ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH368mReadMemDword(  // Ӵ洢ȡһ˫
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	PULONG			oDword );  // ָһ˫ֵԪ,ڱȡ˫


BOOL	WINAPI	CH368mWriteMemByte(  // 洢дһֽ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH368mWriteMemDword(  // 洢дһ˫
	ULONG			iIndex,  // ָCH367豸
	PVOID			iAddr,  // ָ洢ĵַ,ַ
	ULONG			iDword );  // д˫


BOOL	WINAPI	CH367mReadConfig(  // ÿռȡһֽ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iOffset,  // ָƫƵַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH367mWriteConfig(  // ÿռдһֽ
	ULONG			iIndex,  // ָCH367豸
	PVOID			iOffset,  // ָƫƵַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH368mSetA15_A8(  // øߵַ,A15-A8
	ULONG			iIndex,  // ָCH367豸
	UCHAR			iA15_A8 );  // λ7-λ0ӦA15-A8,1Ϊߵƽ,0Ϊ͵ƽ


BOOL	WINAPI	CH367mReadI2C(  // I2Cӿڶȡһֽ
	ULONG			iIndex,  // ָCH367豸
	UCHAR			iDevice,  // 7λָI2C豸ַ
	UCHAR			iAddr,  // ָݵԪĵַ
	PUCHAR			oByte );  // ָһֽڵԪ,ڱȡֽ


BOOL	WINAPI	CH367mWriteI2C(  // I2Cӿдһֽ
	ULONG			iIndex,  // ָCH367豸
	UCHAR			iDevice,  // 7λָI2C豸ַ
	UCHAR			iAddr,  // ָݵԪĵַ
	UCHAR			iByte );  // дֽ


BOOL	WINAPI	CH367DelayUS(  // ʱָ΢
	ULONG			iDelay );  // ָҪʱ΢,ʱС10ϴ


BOOL	WINAPI	CH367mAccessBlock(  // ȡдݿ
	ULONG			iIndex,  // ָCH367豸
	ULONG			iAccessMode,  // ο˵
	PVOID			iAddr,  // ָI/O˿ڻߴ洢ĵַ
	PVOID			ioBuffer,  // ָĻ
	ULONG			iLength );  // ݿ鳤,ҲǶȡдֽ,Ȳ32KB

// iAccessMode 
// #define		mFuncReadIoByte			0x00000010	// ȡ˿,ͬһ˿ڵַֽΪλȡ,󳤶32KB
// #define		mFuncReadIoWord			0x00000011	// ȡ˿,ͬһ˿ڵַΪλȡ,󳤶32KB
// #define		mFuncReadIoDword		0x00000012	// ȡ˿,ͬһ˿ڵַ˫Ϊλȡ,󳤶32KB
// #define		mFuncReadIoBlock		0x00000013	// ȡ˿,ÿȡһֽ,˿ڵַһ,󳤶232B(ƫƵַ00HE7H)
// #define		mFuncReadIo32Block		0x0000001f	// ȡ˿,ÿȡһֽ,˿ڵַһ//,󳤶232B(ƫƵַ00HE7H)
// #define		mFuncWriteIoByte		0x00000014	// д˿,ͬһ˿ڵַֽΪλд,󳤶32KB
// #define		mFuncWriteIoWord		0x00000015	// д˿,ͬһ˿ڵַΪλд,󳤶32KB
// #define		mFuncWriteIoDword		0x00000016	// д˿,ͬһ˿ڵַ˫Ϊλд,󳤶32KB
// #define		mFuncWriteIoBlock		0x00000017	// д˿,ÿдһֽ,˿ڵַһ,󳤶232B(ƫƵַ00HдE7H)
// #define		mFuncWriteIo32Block		0x00000020	// д˿,ÿдһֽ,˿ڵַһ//,󳤶232B(ƫƵַ00HдE7H)
// #define		mFuncReadMemByte		0x00000018	// ȡ洢/Ĵ,ֽΪλ,ÿȡһֽ,ַһ,󳤶32KB(ƫƵַ0000H7FFFH)
// #define		mFuncReadMemDword		0x0000001a	// ȡ洢/Ĵ,˫Ϊλ,ÿȡһֽ,ַ,󳤶32KB(ƫƵַ0000H7FFFH)
// #define		mFuncWriteMemByte		0x0000001c	// д洢/Ĵ,ֽΪλд,ÿȡһֽ,ַһ,󳤶32KB(ƫƵַ0000Hд7FFFH)
// #define		mFuncWriteMemDword		0x0000001e	// д洢/Ĵ,˫Ϊλд,ÿȡһ˫,ַ,󳤶32KB(ƫƵַ0000Hд7FFFH)
// ʽ֧,ļCH367DLL.H


BOOL	WINAPI	CH367mSetExclusive(  // öռʹõǰCH367豸
	ULONG			iIndex,  // ָCH367豸
	ULONG			iExclusive );  // Ϊ0豸Թʹ,0ռʹ

BOOL	WINAPI	CH367SetStream(  // ôģʽ
	ULONG			iIndex,      // ָCH367豸
	ULONG			iMode );     // ָģʽ,
// λ0:     SPIʱƵ,0=31.3MHZ,1=15.6MHZ
// λ1:     SPII/O/IO, 0=SPI3(SCS/SCL/SDX),1=SPI4(SCS/SCL/SDX/SDI)
// ,Ϊ0

BOOL	WINAPI	CH367StreamSPI(  // SPI,3߽ӿ,ʱΪSCL,ΪSDX,,ӴFlashROMоƬ25FXXSDO/SDI;ƬѡΪSCS
							     //4߽ӿ,ΪSDI,ΪSDX,ʱΪSCL,ƬѡΪSDA
                                 /* SPIʱ: SCLΪʱ, ĬΪ͵ƽ, ʱ֮ǰĵ͵ƽڼ, ʱ½֮ǰĸߵƽڼ */
                ULONG			iIndex,  // ָCH367豸	
                ULONG			iWriteLength,  // д,׼дĳ
                PVOID			iWriteBuffer,  // ָһ,׼д
                PULONG			oReadLength,   // ָ򳤶ȵԪ,غΪʵʶȡĳ
				PVOID			oReadBuffer );  // ָһ㹻Ļ,ڱȡ


BOOL	WINAPI	CH364mLockFlash(
		ULONG			iIndex,        // ָCH367豸
		UCHAR			WRLock);	   // ʽ(Ϊ00Hд,Ϊ8CHд/ֻ,Ϊ0FFHд/ȫ,ֻڸλܽ)

BOOL	WINAPI	CH364mReadFlash(
		ULONG			iIndex,        // ָCH367豸
		ULONG			iAddr,         // ָFLASHĵַ
		PVOID			oBuffer,	   // ָһ,ڱȡֽ
		ULONG			iLength);       // ȡݳ
		
BOOL	WINAPI	CH364mEarseFlash(
		ULONG			iIndex,        // ָCH367豸
		ULONG			iAddr,         // ָFLASHĵַ
		ULONG			iLength );	   // ָĳȣÿ4096ֽڼ4KΪһ,Сλ

BOOL	WINAPI	CH364mWriteFlash(
		ULONG			iIndex,        // ָCH367豸
		ULONG			iAddr,         // ָI/O˿ڵĵַ,õַΪIOƫƵַ(<=0xE7);IOַ
		PVOID			iBuffer,	   // ָһֽڵԪ,ڱȡֽ
		ULONG			iLength);  

#ifdef __cplusplus
}
#endif

#endif		// _CH367_DLL_H
