
primitive U_FD_P_R_S_NO_I1 (Q, D, CP, R, S, NOTIFIER_REG); 

    output Q;  
    input  NOTIFIER_REG,
           D, CP, R, S;

`protect

    reg    Q; 

// FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
//            ASYNCHRONOUS SET AND RESET.  ( Q OUTPUT UDP )
        
// Initalize the output pin Q to a logical value 1

initial
    Q=1'b1;

     table
 
    //  D   CP      R   S      NOTIFIER_REG  :   Qt  :   Qt+1

        1   (01)    0   0         ?          :   ?   :   1;  // clocked data
        1   (01)    0   x         ?          :   ?   :   1;  // pessimism
        ?    ?      0   x         ?          :   1   :   1;  // pessimism

        0   (01)    0   0         ?          :   ?   :   0;  // clocked data
        0   (01)    x   0         ?          :   ?   :   0;  // pessimism
        ?    ?      x   0         ?          :   0   :   0;  // pessimism
                                                           
        1   (x1)    0   0         ?          :   1   :   1;  // reducing pessimism
        0   (x1)    0   0         ?          :   0   :   0;                          
        1   (0x)    0   0         ?          :   1   :   1;  
        0   (0x)    0   0         ?          :   0   :   0;  

        ?   ?       1   ?         ?          :   ?   :   0;  // asynchronous clear
        ?   ?       0   1         ?          :   ?   :   1;  // asynchronous set

        ?   (?0)    0   0         ?          :   ?   :   -;  // ignore falling clock
        ?   (1x)    0   0         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?   ?         ?          :   ?   :   -;  // ignore data edges 

        ?   ?     (?0)  ?         ?          :   ?   :   -;  // ignore the edges on 
        ?   ?       ?  (?0)       ?          :   ?   :   -;  //       set and clear                  
        
        ?   ?       ?   ?         *          :   ?   :   x;

    endtable

`endprotect

endprimitive
