/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC3000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-LATCH WITH GLOBAL RESET (GR)
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/


`delay_mode_path

`timescale  1 ns / 100 ps
`celldefine 
module ild (q, d, g, gr);

    parameter size = 1;
    
    output   q;
    
    input    d, g, gr;

`protect

    // if not connected, default to 1
`ifdef SYNTH
`else
    tri1     gr;
`endif

    reg  NOTIFY_REG;
  
  
    U_LD_P_RB_NO
            INST1 (q, d, g, gr, NOTIFY_REG);
            
    specify
    
    // Specify path delays
     
	if (gr && g)
	    (d +=> q) = (1, 1);

	if (gr)
	    (posedge g  => (q +: d))    = (1, 1);
  
	(negedge gr => (q +: 1'b0)) = (1, 1);

	if (g)
	    (posedge gr => (q +: d))    = (1, 1);
       
      
     // Timing Checks
     
	// setup and hold checks between d and the falling edge of g 
	// when gr=1 clr=0 pre=0
	$setuphold(negedge g &&& gr, d, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the rising edge of gr and the falling edge of g
	$setuphold(negedge g &&& gr, gr, 1, 1, NOTIFY_REG);

	// g high time when gr=1
	$width(posedge g &&& gr, 1, 1, NOTIFY_REG);

	// gr low time
	$width(negedge gr, 1, 1, NOTIFY_REG);
   
    endspecify

`endprotect

endmodule
`endcelldefine
    


