/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : OSCILLATOR
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`timescale  1 ns / 100 ps 
`celldefine     
module osc4 (f8m, f500k, f16k, f490, f15);

  parameter size = 1;

  output     f8m, f500k, f16k, f490, f15;

`protect
    
  reg        R8M, R500K, R16K, R490, R15;
  time       T8M, T500K, T16K, T490, T15;

  // time variables are unsigned 32 bit variables
  // so they don't overflow (I hope)

  buf b1 (f8m,   B8M);
  buf b2 (f500k, B500K);
  buf b3 (f16k,  B16K);
  buf b4 (f490,  B490);
  buf b5 (f15,   B15);

  assign B8M = R8M;
  assign B500K = R500K;
  assign B16K = R16K;
  assign B490 = R490;
  assign B15 = R15;

`ifdef SYNTH
`else
  initial
    begin
      T8M   = 1250/2;           // 8   MHz
      T500K = 20000/2;          // 500 KHz
      T16K  = 625000/2;         // 16  KHz
      T490  = 20408000/2;       // 490 Hz
      T15   = 666666666/2;      // 15  Hz
    end

  initial
    begin
      R8M   = 0;
      R500K = 0;
      R16K  = 0;
      R490  = 0;
      R15   = 0;
    end

  always
    begin
      #T8M R8M = 1;
      #T8M R8M = 0;
    end

  always
    begin
      #T500K R500K = 1;
      #T500K R500K = 0;
    end

  always
    begin
      #T16K R16K = 1;
      #T16K R16K = 0;
    end

  always
    begin
      #T490 R490 = 1;
      #T490 R490 = 0;
    end

  always
    begin
      #T15 R15 = 1;
      #T15 R15 = 0;
    end
`endif

`endprotect

endmodule
`endcelldefine
