/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000E Library
FUNCTION       : Output D-FLIP-FLOP in the IOB with clock enable
REFERENCE      : Xilinx Simulation Guide
                 
DESIGNER       : Sanjeev Aggarwal
DATE GENERATED : July 28, 1995

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
       
`timescale  1 ns / 100 ps 
`celldefine 

module ofdx (q, c, ce, d, gsr, gts);

    parameter size = 1;
    
    output   q;

    input    c, ce, d, gsr, gts;

`protect

`ifdef SYNTH
`else
    tri0 gsr, gts;
`endif

    reg  NOTIFY_REG;
    reg  PWR_UP_RST;

    wire d_int;
 
    U_MUX_2_1 INST_MUX (d_int, q, d, ce);
 
    
	// use a FF UDP that is reset to 0 on simulation time 0
	U_FD_P_R_S_NO_I0
	    INST1 (Q_int, d_int, c, gsr, 1'b0, NOTIFY_REG, PWR_UP_RST);

	bufif0 BUFFER1 (q, Q_int, gts);
 
    initial
        PWR_UP_RST = 0;

    // Generating signal for specifying condition in setuphold timing
    // check between c and d
 
    not (_gsr, gsr);
    and (clock_enable, _gsr, ce);

    specify
    
`ifdef SYNTH    
    specparam Area = 1; 
`endif   

    // Specify path delays

	// d->q delay on posedge of clock
	if (!gts && !gsr && ce)
	    (posedge c => (q +: d)) = (1, 1);

	// reset FF,  q->0 delay
	if (!gts)
	    (posedge gsr => (q +: 1'b0)) = (1, 1);

	// gts delay
	(gts => q) = (1, 1, 0);
      
    // Timing Checks
     
	    // setup and hold checks between d and the rising edge of
        // clock when gsr=0
	$setuphold(posedge c &&& clock_enable, d, 1, 1, NOTIFY_REG);

        // setup and hold checks between the rising edge of ce and the
        // rising edge of clock when gsr = 0
    $setuphold(posedge c &&& ~gsr, posedge ce, 1, 1, NOTIFY_REG);
 
	    // setup and hold checks between the falling edge of gsr
        // and the rising edge of clock
	$setuphold(posedge c &&& ce, negedge gsr, 1, 1, NOTIFY_REG);
 
    // pulse width checks

	    // clock high time when gsr=0
	$width(posedge c &&& clock_enable, 1, 1, NOTIFY_REG);

	    // clock low time when gsr=0
	$width(negedge c &&& clock_enable, 1, 1, NOTIFY_REG); 

	    // gsr high time
	$width(posedge gsr, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine


