/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC5200 Library
FUNCTION       : D-LATCH WITH GLOBAL RESET (gr)
REFERENCE      : Xilinx XC5000 Libraries Guide Supplement.
                 
DESIGNER       : Sanjeev Aggarwal
DATE GENERATED : August 31, 1995

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps
`celldefine 
module ldce (q, clr, d, g, ge, gr);

    parameter size = 1;
    
    output   q;
    
    input    clr, d, g, ge, gr;
    
`protect

    // if not connected, default to 0
`ifdef SYNTH
`else
    tri0 gr;
`endif

    reg  NOTIFY_REG;

    wire d_int;  

    U_MUX_2_1 INST_MUX (d_int, q, d, ge);

    or (clear, gr, clr); 
    not (_g, g);
 
	// use a LATCH UDP that is reset to 0 on simulation time 0
	U_LD_N_S_R_NO_I0
            INST1 (q, d_int, _g, clear, 1'b0, NOTIFY_REG);

    not (_gr, gr);
    not (_clr, clr);
    and (latch_en, _clr, _gr, ge);
    and (TimChk_g_gr, _clr, ge);
    and (TimChk_g_clr, _gr, ge);

    specify

`ifdef SYNTH
    specparam Area = 1;
`endif

     // Specify path delays
     
	// d->q delay
	if (!gr && !clr && ge && g)
	    (d +=> q) = (1, 1);

	if (!gr && !clr && ge)
	    (posedge g => (q +: d)) = (1, 1);
  
	if (!gr && !clr && g)
	    (posedge ge => (q +: d)) = (1, 1);
  
	(posedge gr => (q +: 1'b0)) = (1, 1);
	(posedge clr => (q +: 1'b0)) = (1, 1);

      
     // Timing Checks
     
        // setup and hold checks between d and the falling edge of g 
        // when gr=0
	$setuphold(negedge g &&& latch_en, d, 1, 1, NOTIFY_REG);

        // setup and hold checks between the rising edge 
        // of ge and the falling edge of g
    $setuphold(negedge g &&& ~clear, posedge ge, 1, 1, NOTIFY_REG);

        // setup and hold checks between the falling edge 
        // of gr and the falling edge of g
    $setuphold(negedge g &&& TimChk_g_gr, negedge gr, 1, 1, NOTIFY_REG);

        // setup and hold checks between the falling edge 
        // of clr and the falling edge of g
    $setuphold(negedge g &&& TimChk_g_clr, negedge clr, 1, 1, NOTIFY_REG);

    // pulse width checks

	    // g high and low time when gr=0
	$width(posedge g &&& latch_en, 1, 1, NOTIFY_REG);
	$width(negedge g &&& latch_en, 1, 1, NOTIFY_REG); 

	    // gr high time
	$width(posedge gr, 1, 1, NOTIFY_REG);

	    // clr high time
	$width(posedge clr, 1, 1, NOTIFY_REG);

   
    endspecify

`endprotect

endmodule
`endcelldefine
