#!/bin/nawk -f

## Sub-script for RegSchem, gets schematic registry information

BEGIN {

  in_interface = 0
  in_model_list = 0
  in_model_entry = 0
  last_model_entry = -1
  default_interface = ""
  OUTFILE = ".registry"

  system("/bin/rm -f " OUTFILE)
}

{

## Check if line begins with "COMPONENT" (header)
## If so, the sixth field is the name of the default interface

  if ($1 == "COMPONENT")
    default_interface = $6

## If this is the start of an interface description, check to see if
## it is the one for the default interface

  if ($1 == "INTERFACE:") {
    in_model_list = 0
    in_model_entry = 0
    if ($2 == default_interface)
      in_interface = 1
    else
      in_interface = 0
  }

  if (($1 == "INTERFACE") && ($2 == "MODEL") && ($3 == "ENTRIES:") \
      && (in_interface == 1))
    in_model_list = 1

  if ($1 ~ /[0-9]+/) {
    last_model_entry = $1
    if (in_model_list == 1) {
      if ($4 == MODEL) {
	print "Entry: " $1 > OUTFILE
	  in_model_entry = 1
      }
      else
	in_model_entry = 0
    }
  }

  if (($1 == "Labels:") && (in_model_entry == 1))
    for (i = 2; i <= NF ; i++) {
      label = $i
      gsub ("'", "", label)
      print label >> OUTFILE
    }
}

END {
  print "Last: " last_model_entry >> OUTFILE
}

