
module simbench_small;

    parameter count=200, d=100;

    reg ig23, ip23;
    gate2and3 g23(ig23);
    prim2and3 p23(ip23);

    integer saveevents;
    time savetime;

    initial #d
        begin
            saveevents = $simevents;
            savetime = $cputime;
            repeat(count) begin #d ig23 = 0; #d ig23 = 1; end
            $display(
                "gate average is %0d EPS, dE=%0d, dT=%0d",
                10*($simevents-saveevents)/($cputime-savetime),
                $simevents-saveevents, $cputime-savetime);

            saveevents = $simevents;
            savetime = $cputime;
            repeat(count) begin #d ip23 = 0; #d ip23 = 1; end
            $display(
                "UDprimitive average is %0d EPS, dE=%0d, dT=%0d",
                10*($simevents-saveevents)/($cputime-savetime),
                $simevents-saveevents, $cputime-savetime);
		$finish(2);
        end
endmodule



module gate2and3(i);
input i;
nand #3
(a0,a1,1),(a1,a2,1),(a2,a3,1),(a3,a4,1),(a4,a5,1),
(a5,a6,1),(a6,a7,1),(a7,a8,1),(a8,a9,1),(a9,a10,1),
(a10,a11,1),(a11,a12,1),(a12,a13,1),(a13,a14,1),(a14,a15,1),
(a15,a16,1),(a16,a17,1),(a17,a18,1),(a18,a19,1),(a19,a20,1),
(a20,a21,1),(a21,a22,1),(a22,a23,1),(a23,a24,1),(a24,a25,1),
(a25,a26,1),(a26,a27,1),(a27,a28,1),(a28,a29,1),(a29,i,1),
(wa0,a0,0),(wa1,a1,0),(wa2,a2,0),(wa3,a3,0),(wa4,a4,0),
(wa5,a5,0),(wa6,a6,0),(wa7,a7,0),(wa8,a8,0),(wa9,a9,0),
(wa10,a10,0),(wa11,a11,0),(wa12,a12,0),(wa13,a13,0),(wa14,a14,0),
(wa15,a15,0),(wa16,a16,0),(wa17,a17,0),(wa18,a18,0),(wa19,a19,0),
(wa20,a20,0),(wa21,a21,0),(wa22,a22,0),(wa23,a23,0),(wa24,a24,0),
(wa25,a25,0),(wa26,a26,0),(wa27,a27,0),(wa28,a28,0),(wa29,a29,0),

(b0,b1,1),(b1,b2,1),(b2,b3,1),(b3,b4,1),(b4,b5,1),
(b5,b6,1),(b6,b7,1),(b7,b8,1),(b8,b9,1),(b9,b10,1),
(b10,b11,1),(b11,b12,1),(b12,b13,1),(b13,b14,1),(b14,b15,1),
(b15,b16,1),(b16,b17,1),(b17,b18,1),(b18,b19,1),(b19,b20,1),
(b20,b21,1),(b21,b22,1),(b22,b23,1),(b23,b24,1),(b24,b25,1),
(b25,b26,1),(b26,b27,1),(b27,b28,1),(b28,b29,1),(b29,i,1),
(wb0,b0,0),(wb1,b1,0),(wb2,b2,0),(wb3,b3,0),(wb4,b4,0),
(wb5,b5,0),(wb6,b6,0),(wb7,b7,0),(wb8,b8,0),(wb9,b9,0),
(wb10,b10,0),(wb11,b11,0),(wb12,b12,0),(wb13,b13,0),(wb14,b14,0),
(wb15,b15,0),(wb16,b16,0),(wb17,b17,0),(wb18,b18,0),(wb19,b19,0),
(wb20,b20,0),(wb21,b21,0),(wb22,b22,0),(wb23,b23,0),(wb24,b24,0),
(wb25,b25,0),(wb26,b26,0),(wb27,b27,0),(wb28,b28,0),(wb29,b29,0),

(c0,c1,1),(c1,c2,1),(c2,c3,1),(c3,c4,1),(c4,c5,1),
(c5,c6,1),(c6,c7,1),(c7,c8,1),(c8,c9,1),(c9,c10,1),
(c10,c11,1),(c11,c12,1),(c12,c13,1),(c13,c14,1),(c14,c15,1),
(c15,c16,1),(c16,c17,1),(c17,c18,1),(c18,c19,1),(c19,c20,1),
(c20,c21,1),(c21,c22,1),(c22,c23,1),(c23,c24,1),(c24,c25,1),
(c25,c26,1),(c26,c27,1),(c27,c28,1),(c28,c29,1),(c29,i,1),
(wc0,c0,0),(wc1,c1,0),(wc2,c2,0),(wc3,c3,0),(wc4,c4,0),
(wc5,c5,0),(wc6,c6,0),(wc7,c7,0),(wc8,c8,0),(wc9,c9,0),
(wc10,c10,0),(wc11,c11,0),(wc12,c12,0),(wc13,c13,0),(wc14,c14,0),
(wc15,c15,0),(wc16,c16,0),(wc17,c17,0),(wc18,c18,0),(wc19,c19,0),
(wc20,c20,0),(wc21,c21,0),(wc22,c22,0),(wc23,c23,0),(wc24,c24,0),
(wc25,c25,0),(wc26,c26,0),(wc27,c27,0),(wc28,c28,0),(wc29,c29,0),

(d0,d1,1),(d1,d2,1),(d2,d3,1),(d3,d4,1),(d4,d5,1),
(d5,d6,1),(d6,d7,1),(d7,d8,1),(d8,d9,1),(d9,d10,1),
(d10,d11,1),(d11,d12,1),(d12,d13,1),(d13,d14,1),(d14,d15,1),
(d15,d16,1),(d16,d17,1),(d17,d18,1),(d18,d19,1),(d19,d20,1),
(d20,d21,1),(d21,d22,1),(d22,d23,1),(d23,d24,1),(d24,d25,1),
(d25,d26,1),(d26,d27,1),(d27,d28,1),(d28,d29,1),(d29,i,1),
(wd0,d0,0),(wd1,d1,0),(wd2,d2,0),(wd3,d3,0),(wd4,d4,0),
(wd5,d5,0),(wd6,d6,0),(wd7,d7,0),(wd8,d8,0),(wd9,d9,0),
(wd10,d10,0),(wd11,d11,0),(wd12,d12,0),(wd13,d13,0),(wd14,d14,0),
(wd15,d15,0),(wd16,d16,0),(wd17,d17,0),(wd18,d18,0),(wd19,d19,0),
(wd20,d20,0),(wd21,d21,0),(wd22,d22,0),(wd23,d23,0),(wd24,d24,0),
(wd25,d25,0),(wd26,d26,0),(wd27,d27,0),(wd28,d28,0),(wd29,d29,0),

(e0,e1,1),(e1,e2,1),(e2,e3,1),(e3,e4,1),(e4,e5,1),
(e5,e6,1),(e6,e7,1),(e7,e8,1),(e8,e9,1),(e9,e10,1),
(e10,e11,1),(e11,e12,1),(e12,e13,1),(e13,e14,1),(e14,e15,1),
(e15,e16,1),(e16,e17,1),(e17,e18,1),(e18,e19,1),(e19,e20,1),
(e20,e21,1),(e21,e22,1),(e22,e23,1),(e23,e24,1),(e24,e25,1),
(e25,e26,1),(e26,e27,1),(e27,e28,1),(e28,e29,1),(e29,i,1),
(we0,e0,0),(we1,e1,0),(we2,e2,0),(we3,e3,0),(we4,e4,0),
(we5,e5,0),(we6,e6,0),(we7,e7,0),(we8,e8,0),(we9,e9,0),
(we10,e10,0),(we11,e11,0),(we12,e12,0),(we13,e13,0),(we14,e14,0),
(we15,e15,0),(we16,e16,0),(we17,e17,0),(we18,e18,0),(we19,e19,0),
(we20,e20,0),(we21,e21,0),(we22,e22,0),(we23,e23,0),(we24,e24,0),
(we25,e25,0),(we26,e26,0),(we27,e27,0),(we28,e28,0),(we29,e29,0),

(f0,f1,1),(f1,f2,1),(f2,f3,1),(f3,f4,1),(f4,f5,1),
(f5,f6,1),(f6,f7,1),(f7,f8,1),(f8,f9,1),(f9,f10,1),
(f10,f11,1),(f11,f12,1),(f12,f13,1),(f13,f14,1),(f14,f15,1),
(f15,f16,1),(f16,f17,1),(f17,f18,1),(f18,f19,1),(f19,f20,1),
(f20,f21,1),(f21,f22,1),(f22,f23,1),(f23,f24,1),(f24,f25,1),
(f25,f26,1),(f26,f27,1),(f27,f28,1),(f28,f29,1),(f29,i,1),
(wf0,f0,0),(wf1,f1,0),(wf2,f2,0),(wf3,f3,0),(wf4,f4,0),
(wf5,f5,0),(wf6,f6,0),(wf7,f7,0),(wf8,f8,0),(wf9,f9,0),
(wf10,f10,0),(wf11,f11,0),(wf12,f12,0),(wf13,f13,0),(wf14,f14,0),
(wf15,f15,0),(wf16,f16,0),(wf17,f17,0),(wf18,f18,0),(wf19,f19,0),
(wf20,f20,0),(wf21,f21,0),(wf22,f22,0),(wf23,f23,0),(wf24,f24,0),
(wf25,f25,0),(wf26,f26,0),(wf27,f27,0),(wf28,f28,0),(wf29,f29,0),

(g0,g1,1),(g1,g2,1),(g2,g3,1),(g3,g4,1),(g4,g5,1),
(g5,g6,1),(g6,g7,1),(g7,g8,1),(g8,g9,1),(g9,g10,1),
(g10,g11,1),(g11,g12,1),(g12,g13,1),(g13,g14,1),(g14,g15,1),
(g15,g16,1),(g16,g17,1),(g17,g18,1),(g18,g19,1),(g19,g20,1),
(g20,g21,1),(g21,g22,1),(g22,g23,1),(g23,g24,1),(g24,g25,1),
(g25,g26,1),(g26,g27,1),(g27,g28,1),(g28,g29,1),(g29,i,1),
(wg0,g0,0),(wg1,g1,0),(wg2,g2,0),(wg3,g3,0),(wg4,g4,0),
(wg5,g5,0),(wg6,g6,0),(wg7,g7,0),(wg8,g8,0),(wg9,g9,0),
(wg10,g10,0),(wg11,g11,0),(wg12,g12,0),(wg13,g13,0),(wg14,g14,0),
(wg15,g15,0),(wg16,g16,0),(wg17,g17,0),(wg18,g18,0),(wg19,g19,0),
(wg20,g20,0),(wg21,g21,0),(wg22,g22,0),(wg23,g23,0),(wg24,g24,0),
(wg25,g25,0),(wg26,g26,0),(wg27,g27,0),(wg28,g28,0),(wg29,g29,0),

(h0,h1,1),(h1,h2,1),(h2,h3,1),(h3,h4,1),(h4,h5,1),
(h5,h6,1),(h6,h7,1),(h7,h8,1),(h8,h9,1),(h9,h10,1),
(h10,h11,1),(h11,h12,1),(h12,h13,1),(h13,h14,1),(h14,h15,1),
(h15,h16,1),(h16,h17,1),(h17,h18,1),(h18,h19,1),(h19,h20,1),
(h20,h21,1),(h21,h22,1),(h22,h23,1),(h23,h24,1),(h24,h25,1),
(h25,h26,1),(h26,h27,1),(h27,h28,1),(h28,h29,1),(h29,i,1),
(wh0,h0,0),(wh1,h1,0),(wh2,h2,0),(wh3,h3,0),(wh4,h4,0),
(wh5,h5,0),(wh6,h6,0),(wh7,h7,0),(wh8,h8,0),(wh9,h9,0),
(wh10,h10,0),(wh11,h11,0),(wh12,h12,0),(wh13,h13,0),(wh14,h14,0),
(wh15,h15,0),(wh16,h16,0),(wh17,h17,0),(wh18,h18,0),(wh19,h19,0),
(wh20,h20,0),(wh21,h21,0),(wh22,h22,0),(wh23,h23,0),(wh24,h24,0),
(wh25,h25,0),(wh26,h26,0),(wh27,h27,0),(wh28,h28,0),(wh29,h29,0),

(i0,i1,1),(i1,i2,1),(i2,i3,1),(i3,i4,1),(i4,i5,1),
(i5,i6,1),(i6,i7,1),(i7,i8,1),(i8,i9,1),(i9,i10,1),
(i10,i11,1),(i11,i12,1),(i12,i13,1),(i13,i14,1),(i14,i15,1),
(i15,i16,1),(i16,i17,1),(i17,i18,1),(i18,i19,1),(i19,i20,1),
(i20,i21,1),(i21,i22,1),(i22,i23,1),(i23,i24,1),(i24,i25,1),
(i25,i26,1),(i26,i27,1),(i27,i28,1),(i28,i29,1),(i29,i,1),
(wi0,i0,0),(wi1,i1,0),(wi2,i2,0),(wi3,i3,0),(wi4,i4,0),
(wi5,i5,0),(wi6,i6,0),(wi7,i7,0),(wi8,i8,0),(wi9,i9,0),
(wi10,i10,0),(wi11,i11,0),(wi12,i12,0),(wi13,i13,0),(wi14,i14,0),
(wi15,i15,0),(wi16,i16,0),(wi17,i17,0),(wi18,i18,0),(wi19,i19,0),
(wi20,i20,0),(wi21,i21,0),(wi22,i22,0),(wi23,i23,0),(wi24,i24,0),
(wi25,i25,0),(wi26,i26,0),(wi27,i27,0),(wi28,i28,0),(wi29,i29,0),

(j0,j1,1),(j1,j2,1),(j2,j3,1),(j3,j4,1),(j4,j5,1),
(j5,j6,1),(j6,j7,1),(j7,j8,1),(j8,j9,1),(j9,j10,1),
(j10,j11,1),(j11,j12,1),(j12,j13,1),(j13,j14,1),(j14,j15,1),
(j15,j16,1),(j16,j17,1),(j17,j18,1),(j18,j19,1),(j19,j20,1),
(j20,j21,1),(j21,j22,1),(j22,j23,1),(j23,j24,1),(j24,j25,1),
(j25,j26,1),(j26,j27,1),(j27,j28,1),(j28,j29,1),(j29,i,1),
(wj0,j0,0),(wj1,j1,0),(wj2,j2,0),(wj3,j3,0),(wj4,j4,0),
(wj5,j5,0),(wj6,j6,0),(wj7,j7,0),(wj8,j8,0),(wj9,j9,0),
(wj10,j10,0),(wj11,j11,0),(wj12,j12,0),(wj13,j13,0),(wj14,j14,0),
(wj15,j15,0),(wj16,j16,0),(wj17,j17,0),(wj18,j18,0),(wj19,j19,0),
(wj20,j20,0),(wj21,j21,0),(wj22,j22,0),(wj23,j23,0),(wj24,j24,0),
(wj25,j25,0),(wj26,j26,0),(wj27,j27,0),(wj28,j28,0),(wj29,j29,0),

(k0,k1,1),(k1,k2,1),(k2,k3,1),(k3,k4,1),(k4,k5,1),
(k5,k6,1),(k6,k7,1),(k7,k8,1),(k8,k9,1),(k9,k10,1),
(k10,k11,1),(k11,k12,1),(k12,k13,1),(k13,k14,1),(k14,k15,1),
(k15,k16,1),(k16,k17,1),(k17,k18,1),(k18,k19,1),(k19,k20,1),
(k20,k21,1),(k21,k22,1),(k22,k23,1),(k23,k24,1),(k24,k25,1),
(k25,k26,1),(k26,k27,1),(k27,k28,1),(k28,k29,1),(k29,i,1),
(wk0,k0,0),(wk1,k1,0),(wk2,k2,0),(wk3,k3,0),(wk4,k4,0),
(wk5,k5,0),(wk6,k6,0),(wk7,k7,0),(wk8,k8,0),(wk9,k9,0),
(wk10,k10,0),(wk11,k11,0),(wk12,k12,0),(wk13,k13,0),(wk14,k14,0),
(wk15,k15,0),(wk16,k16,0),(wk17,k17,0),(wk18,k18,0),(wk19,k19,0),
(wk20,k20,0),(wk21,k21,0),(wk22,k22,0),(wk23,k23,0),(wk24,k24,0),
(wk25,k25,0),(wk26,k26,0),(wk27,k27,0),(wk28,k28,0),(wk29,k29,0),

(l0,l1,1),(l1,l2,1),(l2,l3,1),(l3,l4,1),(l4,l5,1),
(l5,l6,1),(l6,l7,1),(l7,l8,1),(l8,l9,1),(l9,l10,1),
(l10,l11,1),(l11,l12,1),(l12,l13,1),(l13,l14,1),(l14,l15,1),
(l15,l16,1),(l16,l17,1),(l17,l18,1),(l18,l19,1),(l19,l20,1),
(l20,l21,1),(l21,l22,1),(l22,l23,1),(l23,l24,1),(l24,l25,1),
(l25,l26,1),(l26,l27,1),(l27,l28,1),(l28,l29,1),(l29,i,1),
(wl0,l0,0),(wl1,l1,0),(wl2,l2,0),(wl3,l3,0),(wl4,l4,0),
(wl5,l5,0),(wl6,l6,0),(wl7,l7,0),(wl8,l8,0),(wl9,l9,0),
(wl10,l10,0),(wl11,l11,0),(wl12,l12,0),(wl13,l13,0),(wl14,l14,0),
(wl15,l15,0),(wl16,l16,0),(wl17,l17,0),(wl18,l18,0),(wl19,l19,0),
(wl20,l20,0),(wl21,l21,0),(wl22,l22,0),(wl23,l23,0),(wl24,l24,0),
(wl25,l25,0),(wl26,l26,0),(wl27,l27,0),(wl28,l28,0),(wl29,l29,0),

(m0,m1,1),(m1,m2,1),(m2,m3,1),(m3,m4,1),(m4,m5,1),
(m5,m6,1),(m6,m7,1),(m7,m8,1),(m8,m9,1),(m9,m10,1),
(m10,m11,1),(m11,m12,1),(m12,m13,1),(m13,m14,1),(m14,m15,1),
(m15,m16,1),(m16,m17,1),(m17,m18,1),(m18,m19,1),(m19,m20,1),
(m20,m21,1),(m21,m22,1),(m22,m23,1),(m23,m24,1),(m24,m25,1),
(m25,m26,1),(m26,m27,1),(m27,m28,1),(m28,m29,1),(m29,i,1),
(wm0,m0,0),(wm1,m1,0),(wm2,m2,0),(wm3,m3,0),(wm4,m4,0),
(wm5,m5,0),(wm6,m6,0),(wm7,m7,0),(wm8,m8,0),(wm9,m9,0),
(wm10,m10,0),(wm11,m11,0),(wm12,m12,0),(wm13,m13,0),(wm14,m14,0),
(wm15,m15,0),(wm16,m16,0),(wm17,m17,0),(wm18,m18,0),(wm19,m19,0),
(wm20,m20,0),(wm21,m21,0),(wm22,m22,0),(wm23,m23,0),(wm24,m24,0),
(wm25,m25,0),(wm26,m26,0),(wm27,m27,0),(wm28,m28,0),(wm29,m29,0),

(n0,n1,1),(n1,n2,1),(n2,n3,1),(n3,n4,1),(n4,n5,1),
(n5,n6,1),(n6,n7,1),(n7,n8,1),(n8,n9,1),(n9,n10,1),
(n10,n11,1),(n11,n12,1),(n12,n13,1),(n13,n14,1),(n14,n15,1),
(n15,n16,1),(n16,n17,1),(n17,n18,1),(n18,n19,1),(n19,n20,1),
(n20,n21,1),(n21,n22,1),(n22,n23,1),(n23,n24,1),(n24,n25,1),
(n25,n26,1),(n26,n27,1),(n27,n28,1),(n28,n29,1),(n29,i,1),
(wn0,n0,0),(wn1,n1,0),(wn2,n2,0),(wn3,n3,0),(wn4,n4,0),
(wn5,n5,0),(wn6,n6,0),(wn7,n7,0),(wn8,n8,0),(wn9,n9,0),
(wn10,n10,0),(wn11,n11,0),(wn12,n12,0),(wn13,n13,0),(wn14,n14,0),
(wn15,n15,0),(wn16,n16,0),(wn17,n17,0),(wn18,n18,0),(wn19,n19,0),
(wn20,n20,0),(wn21,n21,0),(wn22,n22,0),(wn23,n23,0),(wn24,n24,0),
(wn25,n25,0),(wn26,n26,0),(wn27,n27,0),(wn28,n28,0),(wn29,n29,0),

(o0,o1,1,1),(o1,o2,1,1),(o2,o3,1,1),(o3,o4,1,1),(o4,o5,1,1),
(o5,o6,1,1),(o6,o7,1,1),(o7,o8,1,1),(o8,o9,1,1),(o9,o10,1,1),
(o10,o11,1,1),(o11,o12,1,1),(o12,o13,1,1),(o13,o14,1,1),(o14,o15,1,1),
(o15,o16,1,1),(o16,o17,1,1),(o17,o18,1,1),(o18,o19,1,1),(o19,o20,1,1),
(o20,o21,1,1),(o21,o22,1,1),(o22,o23,1,1),(o23,o24,1,1),(o24,o25,1,1),
(o25,o26,1,1),(o26,o27,1,1),(o27,o28,1,1),(o28,o29,1,1),(o29,i,1,1),
(wo0,o0,0,0),(wo1,o1,0,0),(wo2,o2,0,0),(wo3,o3,0,0),(wo4,o4,0,0),
(wo5,o5,0,0),(wo6,o6,0,0),(wo7,o7,0,0),(wo8,o8,0,0),(wo9,o9,0,0),
(wo10,o10,0,0),(wo11,o11,0,0),(wo12,o12,0,0),(wo13,o13,0,0),(wo14,o14,0,0),
(wo15,o15,0,0),(wo16,o16,0,0),(wo17,o17,0,0),(wo18,o18,0,0),(wo19,o19,0,0),
(wo20,o20,0,0),(wo21,o21,0,0),(wo22,o22,0,0),(wo23,o23,0,0),(wo24,o24,0,0),
(wo25,o25,0,0),(wo26,o26,0,0),(wo27,o27,0,0),(wo28,o28,0,0),(wo29,o29,0,0),
(wo0,o0,0,0),(wo1,o1,0,0),(wo2,o2,0,0),(wo3,o3,0,0),(wo4,o4,0,0),
(wo5,o5,0,0),(wo6,o6,0,0),(wo7,o7,0,0),(wo8,o8,0,0),(wo9,o9,0,0),
(wo10,o10,0,0),(wo11,o11,0,0),(wo12,o12,0,0),(wo13,o13,0,0),(wo14,o14,0,0),
(wo15,o15,0,0),(wo16,o16,0,0),(wo17,o17,0,0),(wo18,o18,0,0),(wo19,o19,0,0),
(wo20,o20,0,0),(wo21,o21,0,0),(wo22,o22,0,0),(wo23,o23,0,0),(wo24,o24,0,0),
(wo25,o25,0,0),(wo26,o26,0,0),(wo27,o27,0,0),(wo28,o28,0,0),(wo29,o29,0,0),

(p0,p1,1,1),(p1,p2,1,1),(p2,p3,1,1),(p3,p4,1,1),(p4,p5,1,1),
(p5,p6,1,1),(p6,p7,1,1),(p7,p8,1,1),(p8,p9,1,1),(p9,p10,1,1),
(p10,p11,1,1),(p11,p12,1,1),(p12,p13,1,1),(p13,p14,1,1),(p14,p15,1,1),
(p15,p16,1,1),(p16,p17,1,1),(p17,p18,1,1),(p18,p19,1,1),(p19,p20,1,1),
(p20,p21,1,1),(p21,p22,1,1),(p22,p23,1,1),(p23,p24,1,1),(p24,p25,1,1),
(p25,p26,1,1),(p26,p27,1,1),(p27,p28,1,1),(p28,p29,1,1),(p29,i,1,1),
(wp0,p0,0,0),(wp1,p1,0,0),(wp2,p2,0,0),(wp3,p3,0,0),(wp4,p4,0,0),
(wp5,p5,0,0),(wp6,p6,0,0),(wp7,p7,0,0),(wp8,p8,0,0),(wp9,p9,0,0),
(wp10,p10,0,0),(wp11,p11,0,0),(wp12,p12,0,0),(wp13,p13,0,0),(wp14,p14,0,0),
(wp15,p15,0,0),(wp16,p16,0,0),(wp17,p17,0,0),(wp18,p18,0,0),(wp19,p19,0,0),
(wp20,p20,0,0),(wp21,p21,0,0),(wp22,p22,0,0),(wp23,p23,0,0),(wp24,p24,0,0),
(wp25,p25,0,0),(wp26,p26,0,0),(wp27,p27,0,0),(wp28,p28,0,0),(wp29,p29,0,0),
(wp0,p0,0,0),(wp1,p1,0,0),(wp2,p2,0,0),(wp3,p3,0,0),(wp4,p4,0,0),
(wp5,p5,0,0),(wp6,p6,0,0),(wp7,p7,0,0),(wp8,p8,0,0),(wp9,p9,0,0),
(wp10,p10,0,0),(wp11,p11,0,0),(wp12,p12,0,0),(wp13,p13,0,0),(wp14,p14,0,0),
(wp15,p15,0,0),(wp16,p16,0,0),(wp17,p17,0,0),(wp18,p18,0,0),(wp19,p19,0,0),
(wp20,p20,0,0),(wp21,p21,0,0),(wp22,p22,0,0),(wp23,p23,0,0),(wp24,p24,0,0),
(wp25,p25,0,0),(wp26,p26,0,0),(wp27,p27,0,0),(wp28,p28,0,0),(wp29,p29,0,0),

(q0,q1,1,1),(q1,q2,1,1),(q2,q3,1,1),(q3,q4,1,1),(q4,q5,1,1),
(q5,q6,1,1),(q6,q7,1,1),(q7,q8,1,1),(q8,q9,1,1),(q9,q10,1,1),
(q10,q11,1,1),(q11,q12,1,1),(q12,q13,1,1),(q13,q14,1,1),(q14,q15,1,1),
(q15,q16,1,1),(q16,q17,1,1),(q17,q18,1,1),(q18,q19,1,1),(q19,q20,1,1),
(q20,q21,1,1),(q21,q22,1,1),(q22,q23,1,1),(q23,q24,1,1),(q24,q25,1,1),
(q25,q26,1,1),(q26,q27,1,1),(q27,q28,1,1),(q28,q29,1,1),(q29,i,1,1),
(wq0,q0,0,0),(wq1,q1,0,0),(wq2,q2,0,0),(wq3,q3,0,0),(wq4,q4,0,0),
(wq5,q5,0,0),(wq6,q6,0,0),(wq7,q7,0,0),(wq8,q8,0,0),(wq9,q9,0,0),
(wq10,q10,0,0),(wq11,q11,0,0),(wq12,q12,0,0),(wq13,q13,0,0),(wq14,q14,0,0),
(wq15,q15,0,0),(wq16,q16,0,0),(wq17,q17,0,0),(wq18,q18,0,0),(wq19,q19,0,0),
(wq20,q20,0,0),(wq21,q21,0,0),(wq22,q22,0,0),(wq23,q23,0,0),(wq24,q24,0,0),
(wq25,q25,0,0),(wq26,q26,0,0),(wq27,q27,0,0),(wq28,q28,0,0),(wq29,q29,0,0),
(wq0,q0,0,0),(wq1,q1,0,0),(wq2,q2,0,0),(wq3,q3,0,0),(wq4,q4,0,0),
(wq5,q5,0,0),(wq6,q6,0,0),(wq7,q7,0,0),(wq8,q8,0,0),(wq9,q9,0,0),
(wq10,q10,0,0),(wq11,q11,0,0),(wq12,q12,0,0),(wq13,q13,0,0),(wq14,q14,0,0),
(wq15,q15,0,0),(wq16,q16,0,0),(wq17,q17,0,0),(wq18,q18,0,0),(wq19,q19,0,0),
(wq20,q20,0,0),(wq21,q21,0,0),(wq22,q22,0,0),(wq23,q23,0,0),(wq24,q24,0,0),
(wq25,q25,0,0),(wq26,q26,0,0),(wq27,q27,0,0),(wq28,q28,0,0),(wq29,q29,0,0),

(r0,r1,1,1),(r1,r2,1,1),(r2,r3,1,1),(r3,r4,1,1),(r4,r5,1,1),
(r5,r6,1,1),(r6,r7,1,1),(r7,r8,1,1),(r8,r9,1,1),(r9,r10,1,1),
(r10,r11,1,1),(r11,r12,1,1),(r12,r13,1,1),(r13,r14,1,1),(r14,r15,1,1),
(r15,r16,1,1),(r16,r17,1,1),(r17,r18,1,1),(r18,r19,1,1),(r19,r20,1,1),
(r20,r21,1,1),(r21,r22,1,1),(r22,r23,1,1),(r23,r24,1,1),(r24,r25,1,1),
(r25,r26,1,1),(r26,r27,1,1),(r27,r28,1,1),(r28,r29,1,1),(r29,i,1,1),
(wr0,r0,0,0),(wr1,r1,0,0),(wr2,r2,0,0),(wr3,r3,0,0),(wr4,r4,0,0),
(wr5,r5,0,0),(wr6,r6,0,0),(wr7,r7,0,0),(wr8,r8,0,0),(wr9,r9,0,0),
(wr10,r10,0,0),(wr11,r11,0,0),(wr12,r12,0,0),(wr13,r13,0,0),(wr14,r14,0,0),
(wr15,r15,0,0),(wr16,r16,0,0),(wr17,r17,0,0),(wr18,r18,0,0),(wr19,r19,0,0),
(wr20,r20,0,0),(wr21,r21,0,0),(wr22,r22,0,0),(wr23,r23,0,0),(wr24,r24,0,0),
(wr25,r25,0,0),(wr26,r26,0,0),(wr27,r27,0,0),(wr28,r28,0,0),(wr29,r29,0,0),
(wr0,r0,0,0),(wr1,r1,0,0),(wr2,r2,0,0),(wr3,r3,0,0),(wr4,r4,0,0),
(wr5,r5,0,0),(wr6,r6,0,0),(wr7,r7,0,0),(wr8,r8,0,0),(wr9,r9,0,0),
(wr10,r10,0,0),(wr11,r11,0,0),(wr12,r12,0,0),(wr13,r13,0,0),(wr14,r14,0,0),
(wr15,r15,0,0),(wr16,r16,0,0),(wr17,r17,0,0),(wr18,r18,0,0),(wr19,r19,0,0),
(wr20,r20,0,0),(wr21,r21,0,0),(wr22,r22,0,0),(wr23,r23,0,0),(wr24,r24,0,0),
(wr25,r25,0,0),(wr26,r26,0,0),(wr27,r27,0,0),(wr28,r28,0,0),(wr29,r29,0,0),

(s0,s1,1,1),(s1,s2,1,1),(s2,s3,1,1),(s3,s4,1,1),(s4,s5,1,1),
(s5,s6,1,1),(s6,s7,1,1),(s7,s8,1,1),(s8,s9,1,1),(s9,s10,1,1),
(s10,s11,1,1),(s11,s12,1,1),(s12,s13,1,1),(s13,s14,1,1),(s14,s15,1,1),
(s15,s16,1,1),(s16,s17,1,1),(s17,s18,1,1),(s18,s19,1,1),(s19,s20,1,1),
(s20,s21,1,1),(s21,s22,1,1),(s22,s23,1,1),(s23,s24,1,1),(s24,s25,1,1),
(s25,s26,1,1),(s26,s27,1,1),(s27,s28,1,1),(s28,s29,1,1),(s29,i,1,1),
(ws0,s0,0,0),(ws1,s1,0,0),(ws2,s2,0,0),(ws3,s3,0,0),(ws4,s4,0,0),
(ws5,s5,0,0),(ws6,s6,0,0),(ws7,s7,0,0),(ws8,s8,0,0),(ws9,s9,0,0),
(ws10,s10,0,0),(ws11,s11,0,0),(ws12,s12,0,0),(ws13,s13,0,0),(ws14,s14,0,0),
(ws15,s15,0,0),(ws16,s16,0,0),(ws17,s17,0,0),(ws18,s18,0,0),(ws19,s19,0,0),
(ws20,s20,0,0),(ws21,s21,0,0),(ws22,s22,0,0),(ws23,s23,0,0),(ws24,s24,0,0),
(ws25,s25,0,0),(ws26,s26,0,0),(ws27,s27,0,0),(ws28,s28,0,0),(ws29,s29,0,0),
(ws0,s0,0,0),(ws1,s1,0,0),(ws2,s2,0,0),(ws3,s3,0,0),(ws4,s4,0,0),
(ws5,s5,0,0),(ws6,s6,0,0),(ws7,s7,0,0),(ws8,s8,0,0),(ws9,s9,0,0),
(ws10,s10,0,0),(ws11,s11,0,0),(ws12,s12,0,0),(ws13,s13,0,0),(ws14,s14,0,0),
(ws15,s15,0,0),(ws16,s16,0,0),(ws17,s17,0,0),(ws18,s18,0,0),(ws19,s19,0,0),
(ws20,s20,0,0),(ws21,s21,0,0),(ws22,s22,0,0),(ws23,s23,0,0),(ws24,s24,0,0),
(ws25,s25,0,0),(ws26,s26,0,0),(ws27,s27,0,0),(ws28,s28,0,0),(ws29,s29,0,0),

(t0,t1,1,1),(t1,t2,1,1),(t2,t3,1,1),(t3,t4,1,1),(t4,t5,1,1),
(t5,t6,1,1),(t6,t7,1,1),(t7,t8,1,1),(t8,t9,1,1),(t9,t10,1,1),
(t10,t11,1,1),(t11,t12,1,1),(t12,t13,1,1),(t13,t14,1,1),(t14,t15,1,1),
(t15,t16,1,1),(t16,t17,1,1),(t17,t18,1,1),(t18,t19,1,1),(t19,t20,1,1),
(t20,t21,1,1),(t21,t22,1,1),(t22,t23,1,1),(t23,t24,1,1),(t24,t25,1,1),
(t25,t26,1,1),(t26,t27,1,1),(t27,t28,1,1),(t28,t29,1,1),(t29,i,1,1),
(wt0,t0,0,0),(wt1,t1,0,0),(wt2,t2,0,0),(wt3,t3,0,0),(wt4,t4,0,0),
(wt5,t5,0,0),(wt6,t6,0,0),(wt7,t7,0,0),(wt8,t8,0,0),(wt9,t9,0,0),
(wt10,t10,0,0),(wt11,t11,0,0),(wt12,t12,0,0),(wt13,t13,0,0),(wt14,t14,0,0),
(wt15,t15,0,0),(wt16,t16,0,0),(wt17,t17,0,0),(wt18,t18,0,0),(wt19,t19,0,0),
(wt20,t20,0,0),(wt21,t21,0,0),(wt22,t22,0,0),(wt23,t23,0,0),(wt24,t24,0,0),
(wt25,t25,0,0),(wt26,t26,0,0),(wt27,t27,0,0),(wt28,t28,0,0),(wt29,t29,0,0),
(wt0,t0,0,0),(wt1,t1,0,0),(wt2,t2,0,0),(wt3,t3,0,0),(wt4,t4,0,0),
(wt5,t5,0,0),(wt6,t6,0,0),(wt7,t7,0,0),(wt8,t8,0,0),(wt9,t9,0,0),
(wt10,t10,0,0),(wt11,t11,0,0),(wt12,t12,0,0),(wt13,t13,0,0),(wt14,t14,0,0),
(wt15,t15,0,0),(wt16,t16,0,0),(wt17,t17,0,0),(wt18,t18,0,0),(wt19,t19,0,0),
(wt20,t20,0,0),(wt21,t21,0,0),(wt22,t22,0,0),(wt23,t23,0,0),(wt24,t24,0,0),
(wt25,t25,0,0),(wt26,t26,0,0),(wt27,t27,0,0),(wt28,t28,0,0),(wt29,t29,0,0),

(u0,u1,1,1),(u1,u2,1,1),(u2,u3,1,1),(u3,u4,1,1),(u4,u5,1,1),
(u5,u6,1,1),(u6,u7,1,1),(u7,u8,1,1),(u8,u9,1,1),(u9,u10,1,1),
(u10,u11,1,1),(u11,u12,1,1),(u12,u13,1,1),(u13,u14,1,1),(u14,u15,1,1),
(u15,u16,1,1),(u16,u17,1,1),(u17,u18,1,1),(u18,u19,1,1),(u19,u20,1,1),
(u20,u21,1,1),(u21,u22,1,1),(u22,u23,1,1),(u23,u24,1,1),(u24,u25,1,1),
(u25,u26,1,1),(u26,u27,1,1),(u27,u28,1,1),(u28,u29,1,1),(u29,i,1,1),
(wu0,u0,0,0),(wu1,u1,0,0),(wu2,u2,0,0),(wu3,u3,0,0),(wu4,u4,0,0),
(wu5,u5,0,0),(wu6,u6,0,0),(wu7,u7,0,0),(wu8,u8,0,0),(wu9,u9,0,0),
(wu10,u10,0,0),(wu11,u11,0,0),(wu12,u12,0,0),(wu13,u13,0,0),(wu14,u14,0,0),
(wu15,u15,0,0),(wu16,u16,0,0),(wu17,u17,0,0),(wu18,u18,0,0),(wu19,u19,0,0),
(wu20,u20,0,0),(wu21,u21,0,0),(wu22,u22,0,0),(wu23,u23,0,0),(wu24,u24,0,0),
(wu25,u25,0,0),(wu26,u26,0,0),(wu27,u27,0,0),(wu28,u28,0,0),(wu29,u29,0,0),
(wu0,u0,0,0),(wu1,u1,0,0),(wu2,u2,0,0),(wu3,u3,0,0),(wu4,u4,0,0),
(wu5,u5,0,0),(wu6,u6,0,0),(wu7,u7,0,0),(wu8,u8,0,0),(wu9,u9,0,0),
(wu10,u10,0,0),(wu11,u11,0,0),(wu12,u12,0,0),(wu13,u13,0,0),(wu14,u14,0,0),
(wu15,u15,0,0),(wu16,u16,0,0),(wu17,u17,0,0),(wu18,u18,0,0),(wu19,u19,0,0),
(wu20,u20,0,0),(wu21,u21,0,0),(wu22,u22,0,0),(wu23,u23,0,0),(wu24,u24,0,0),
(wu25,u25,0,0),(wu26,u26,0,0),(wu27,u27,0,0),(wu28,u28,0,0),(wu29,u29,0,0),

(v0,v1,1,1),(v1,v2,1,1),(v2,v3,1,1),(v3,v4,1,1),(v4,v5,1,1),
(v5,v6,1,1),(v6,v7,1,1),(v7,v8,1,1),(v8,v9,1,1),(v9,v10,1,1),
(v10,v11,1,1),(v11,v12,1,1),(v12,v13,1,1),(v13,v14,1,1),(v14,v15,1,1),
(v15,v16,1,1),(v16,v17,1,1),(v17,v18,1,1),(v18,v19,1,1),(v19,v20,1,1),
(v20,v21,1,1),(v21,v22,1,1),(v22,v23,1,1),(v23,v24,1,1),(v24,v25,1,1),
(v25,v26,1,1),(v26,v27,1,1),(v27,v28,1,1),(v28,v29,1,1),(v29,i,1,1),
(wv0,v0,0,0),(wv1,v1,0,0),(wv2,v2,0,0),(wv3,v3,0,0),(wv4,v4,0,0),
(wv5,v5,0,0),(wv6,v6,0,0),(wv7,v7,0,0),(wv8,v8,0,0),(wv9,v9,0,0),
(wv10,v10,0,0),(wv11,v11,0,0),(wv12,v12,0,0),(wv13,v13,0,0),(wv14,v14,0,0),
(wv15,v15,0,0),(wv16,v16,0,0),(wv17,v17,0,0),(wv18,v18,0,0),(wv19,v19,0,0),
(wv20,v20,0,0),(wv21,v21,0,0),(wv22,v22,0,0),(wv23,v23,0,0),(wv24,v24,0,0),
(wv25,v25,0,0),(wv26,v26,0,0),(wv27,v27,0,0),(wv28,v28,0,0),(wv29,v29,0,0),
(wv0,v0,0,0),(wv1,v1,0,0),(wv2,v2,0,0),(wv3,v3,0,0),(wv4,v4,0,0),
(wv5,v5,0,0),(wv6,v6,0,0),(wv7,v7,0,0),(wv8,v8,0,0),(wv9,v9,0,0),
(wv10,v10,0,0),(wv11,v11,0,0),(wv12,v12,0,0),(wv13,v13,0,0),(wv14,v14,0,0),
(wv15,v15,0,0),(wv16,v16,0,0),(wv17,v17,0,0),(wv18,v18,0,0),(wv19,v19,0,0),
(wv20,v20,0,0),(wv21,v21,0,0),(wv22,v22,0,0),(wv23,v23,0,0),(wv24,v24,0,0),
(wv25,v25,0,0),(wv26,v26,0,0),(wv27,v27,0,0),(wv28,v28,0,0),(wv29,v29,0,0),

(w0,w1,1,1),(w1,w2,1,1),(w2,w3,1,1),(w3,w4,1,1),(w4,w5,1,1),
(w5,w6,1,1),(w6,w7,1,1),(w7,w8,1,1),(w8,w9,1,1),(w9,w10,1,1),
(w10,w11,1,1),(w11,w12,1,1),(w12,w13,1,1),(w13,w14,1,1),(w14,w15,1,1),
(w15,w16,1,1),(w16,w17,1,1),(w17,w18,1,1),(w18,w19,1,1),(w19,w20,1,1),
(w20,w21,1,1),(w21,w22,1,1),(w22,w23,1,1),(w23,w24,1,1),(w24,w25,1,1),
(w25,w26,1,1),(w26,w27,1,1),(w27,w28,1,1),(w28,w29,1,1),(w29,i,1,1),
(ww0,w0,0,0),(ww1,w1,0,0),(ww2,w2,0,0),(ww3,w3,0,0),(ww4,w4,0,0),
(ww5,w5,0,0),(ww6,w6,0,0),(ww7,w7,0,0),(ww8,w8,0,0),(ww9,w9,0,0),
(ww10,w10,0,0),(ww11,w11,0,0),(ww12,w12,0,0),(ww13,w13,0,0),(ww14,w14,0,0),
(ww15,w15,0,0),(ww16,w16,0,0),(ww17,w17,0,0),(ww18,w18,0,0),(ww19,w19,0,0),
(ww20,w20,0,0),(ww21,w21,0,0),(ww22,w22,0,0),(ww23,w23,0,0),(ww24,w24,0,0),
(ww25,w25,0,0),(ww26,w26,0,0),(ww27,w27,0,0),(ww28,w28,0,0),(ww29,w29,0,0),
(ww0,w0,0,0),(ww1,w1,0,0),(ww2,w2,0,0),(ww3,w3,0,0),(ww4,w4,0,0),
(ww5,w5,0,0),(ww6,w6,0,0),(ww7,w7,0,0),(ww8,w8,0,0),(ww9,w9,0,0),
(ww10,w10,0,0),(ww11,w11,0,0),(ww12,w12,0,0),(ww13,w13,0,0),(ww14,w14,0,0),
(ww15,w15,0,0),(ww16,w16,0,0),(ww17,w17,0,0),(ww18,w18,0,0),(ww19,w19,0,0),
(ww20,w20,0,0),(ww21,w21,0,0),(ww22,w22,0,0),(ww23,w23,0,0),(ww24,w24,0,0),
(ww25,w25,0,0),(ww26,w26,0,0),(ww27,w27,0,0),(ww28,w28,0,0),(ww29,w29,0,0),

(x0,x1,1,1),(x1,x2,1,1),(x2,x3,1,1),(x3,x4,1,1),(x4,x5,1,1),
(x5,x6,1,1),(x6,x7,1,1),(x7,x8,1,1),(x8,x9,1,1),(x9,x10,1,1),
(x10,x11,1,1),(x11,x12,1,1),(x12,x13,1,1),(x13,x14,1,1),(x14,x15,1,1),
(x15,x16,1,1),(x16,x17,1,1),(x17,x18,1,1),(x18,x19,1,1),(x19,x20,1,1),
(x20,x21,1,1),(x21,x22,1,1),(x22,x23,1,1),(x23,x24,1,1),(x24,x25,1,1),
(x25,x26,1,1),(x26,x27,1,1),(x27,x28,1,1),(x28,x29,1,1),(x29,i,1,1),
(wx0,x0,0,0),(wx1,x1,0,0),(wx2,x2,0,0),(wx3,x3,0,0),(wx4,x4,0,0),
(wx5,x5,0,0),(wx6,x6,0,0),(wx7,x7,0,0),(wx8,x8,0,0),(wx9,x9,0,0),
(wx10,x10,0,0),(wx11,x11,0,0),(wx12,x12,0,0),(wx13,x13,0,0),(wx14,x14,0,0),
(wx15,x15,0,0),(wx16,x16,0,0),(wx17,x17,0,0),(wx18,x18,0,0),(wx19,x19,0,0),
(wx20,x20,0,0),(wx21,x21,0,0),(wx22,x22,0,0),(wx23,x23,0,0),(wx24,x24,0,0),
(wx25,x25,0,0),(wx26,x26,0,0),(wx27,x27,0,0),(wx28,x28,0,0),(wx29,x29,0,0),
(wx0,x0,0,0),(wx1,x1,0,0),(wx2,x2,0,0),(wx3,x3,0,0),(wx4,x4,0,0),
(wx5,x5,0,0),(wx6,x6,0,0),(wx7,x7,0,0),(wx8,x8,0,0),(wx9,x9,0,0),
(wx10,x10,0,0),(wx11,x11,0,0),(wx12,x12,0,0),(wx13,x13,0,0),(wx14,x14,0,0),
(wx15,x15,0,0),(wx16,x16,0,0),(wx17,x17,0,0),(wx18,x18,0,0),(wx19,x19,0,0),
(wx20,x20,0,0),(wx21,x21,0,0),(wx22,x22,0,0),(wx23,x23,0,0),(wx24,x24,0,0),
(wx25,x25,0,0),(wx26,x26,0,0),(wx27,x27,0,0),(wx28,x28,0,0),(wx29,x29,0,0),

(y0,y1,1,1),(y1,y2,1,1),(y2,y3,1,1),(y3,y4,1,1),(y4,y5,1,1),
(y5,y6,1,1),(y6,y7,1,1),(y7,y8,1,1),(y8,y9,1,1),(y9,y10,1,1),
(y10,y11,1,1),(y11,y12,1,1),(y12,y13,1,1),(y13,y14,1,1),(y14,y15,1,1),
(y15,y16,1,1),(y16,y17,1,1),(y17,y18,1,1),(y18,y19,1,1),(y19,y20,1,1),
(y20,y21,1,1),(y21,y22,1,1),(y22,y23,1,1),(y23,y24,1,1),(y24,y25,1,1),
(y25,y26,1,1),(y26,y27,1,1),(y27,y28,1,1),(y28,y29,1,1),(y29,i,1,1),
(wy0,y0,0,0),(wy1,y1,0,0),(wy2,y2,0,0),(wy3,y3,0,0),(wy4,y4,0,0),
(wy5,y5,0,0),(wy6,y6,0,0),(wy7,y7,0,0),(wy8,y8,0,0),(wy9,y9,0,0),
(wy10,y10,0,0),(wy11,y11,0,0),(wy12,y12,0,0),(wy13,y13,0,0),(wy14,y14,0,0),
(wy15,y15,0,0),(wy16,y16,0,0),(wy17,y17,0,0),(wy18,y18,0,0),(wy19,y19,0,0),
(wy20,y20,0,0),(wy21,y21,0,0),(wy22,y22,0,0),(wy23,y23,0,0),(wy24,y24,0,0),
(wy25,y25,0,0),(wy26,y26,0,0),(wy27,y27,0,0),(wy28,y28,0,0),(wy29,y29,0,0),
(wy0,y0,0,0),(wy1,y1,0,0),(wy2,y2,0,0),(wy3,y3,0,0),(wy4,y4,0,0),
(wy5,y5,0,0),(wy6,y6,0,0),(wy7,y7,0,0),(wy8,y8,0,0),(wy9,y9,0,0),
(wy10,y10,0,0),(wy11,y11,0,0),(wy12,y12,0,0),(wy13,y13,0,0),(wy14,y14,0,0),
(wy15,y15,0,0),(wy16,y16,0,0),(wy17,y17,0,0),(wy18,y18,0,0),(wy19,y19,0,0),
(wy20,y20,0,0),(wy21,y21,0,0),(wy22,y22,0,0),(wy23,y23,0,0),(wy24,y24,0,0),
(wy25,y25,0,0),(wy26,y26,0,0),(wy27,y27,0,0),(wy28,y28,0,0),(wy29,y29,0,0),

(z0,z1,1,1),(z1,z2,1,1),(z2,z3,1,1),(z3,z4,1,1),(z4,z5,1,1),
(z5,z6,1,1),(z6,z7,1,1),(z7,z8,1,1),(z8,z9,1,1),(z9,z10,1,1),
(z10,z11,1,1),(z11,z12,1,1),(z12,z13,1,1),(z13,z14,1,1),(z14,z15,1,1),
(z15,z16,1,1),(z16,z17,1,1),(z17,z18,1,1),(z18,z19,1,1),(z19,z20,1,1),
(z20,z21,1,1),(z21,z22,1,1),(z22,z23,1,1),(z23,z24,1,1),(z24,z25,1,1),
(z25,z26,1,1),(z26,z27,1,1),(z27,z28,1,1),(z28,z29,1,1),(z29,i,1,1),
(wz0,z0,0,0),(wz1,z1,0,0),(wz2,z2,0,0),(wz3,z3,0,0),(wz4,z4,0,0),
(wz5,z5,0,0),(wz6,z6,0,0),(wz7,z7,0,0),(wz8,z8,0,0),(wz9,z9,0,0),
(wz10,z10,0,0),(wz11,z11,0,0),(wz12,z12,0,0),(wz13,z13,0,0),(wz14,z14,0,0),
(wz15,z15,0,0),(wz16,z16,0,0),(wz17,z17,0,0),(wz18,z18,0,0),(wz19,z19,0,0),
(wz20,z20,0,0),(wz21,z21,0,0),(wz22,z22,0,0),(wz23,z23,0,0),(wz24,z24,0,0),
(wz25,z25,0,0),(wz26,z26,0,0),(wz27,z27,0,0),(wz28,z28,0,0),(wz29,z29,0,0),
(wz0,z0,0,0),(wz1,z1,0,0),(wz2,z2,0,0),(wz3,z3,0,0),(wz4,z4,0,0),
(wz5,z5,0,0),(wz6,z6,0,0),(wz7,z7,0,0),(wz8,z8,0,0),(wz9,z9,0,0),
(wz10,z10,0,0),(wz11,z11,0,0),(wz12,z12,0,0),(wz13,z13,0,0),(wz14,z14,0,0),
(wz15,z15,0,0),(wz16,z16,0,0),(wz17,z17,0,0),(wz18,z18,0,0),(wz19,z19,0,0),
(wz20,z20,0,0),(wz21,z21,0,0),(wz22,z22,0,0),(wz23,z23,0,0),(wz24,z24,0,0),
(wz25,z25,0,0),(wz26,z26,0,0),(wz27,z27,0,0),(wz28,z28,0,0),(wz29,z29,0,0);

endmodule


module prim2and3(i);
input i;
prim_nand2 #3
(a0,a1,1),(a1,a2,1),(a2,a3,1),(a3,a4,1),(a4,a5,1),
(a5,a6,1),(a6,a7,1),(a7,a8,1),(a8,a9,1),(a9,a10,1),
(a10,a11,1),(a11,a12,1),(a12,a13,1),(a13,a14,1),(a14,a15,1),
(a15,a16,1),(a16,a17,1),(a17,a18,1),(a18,a19,1),(a19,a20,1),
(a20,a21,1),(a21,a22,1),(a22,a23,1),(a23,a24,1),(a24,a25,1),
(a25,a26,1),(a26,a27,1),(a27,a28,1),(a28,a29,1),(a29,i,1),
(wa0,a0,0),(wa1,a1,0),(wa2,a2,0),(wa3,a3,0),(wa4,a4,0),
(wa5,a5,0),(wa6,a6,0),(wa7,a7,0),(wa8,a8,0),(wa9,a9,0),
(wa10,a10,0),(wa11,a11,0),(wa12,a12,0),(wa13,a13,0),(wa14,a14,0),
(wa15,a15,0),(wa16,a16,0),(wa17,a17,0),(wa18,a18,0),(wa19,a19,0),
(wa20,a20,0),(wa21,a21,0),(wa22,a22,0),(wa23,a23,0),(wa24,a24,0),
(wa25,a25,0),(wa26,a26,0),(wa27,a27,0),(wa28,a28,0),(wa29,a29,0),

(b0,b1,1),(b1,b2,1),(b2,b3,1),(b3,b4,1),(b4,b5,1),
(b5,b6,1),(b6,b7,1),(b7,b8,1),(b8,b9,1),(b9,b10,1),
(b10,b11,1),(b11,b12,1),(b12,b13,1),(b13,b14,1),(b14,b15,1),
(b15,b16,1),(b16,b17,1),(b17,b18,1),(b18,b19,1),(b19,b20,1),
(b20,b21,1),(b21,b22,1),(b22,b23,1),(b23,b24,1),(b24,b25,1),
(b25,b26,1),(b26,b27,1),(b27,b28,1),(b28,b29,1),(b29,i,1),
(wb0,b0,0),(wb1,b1,0),(wb2,b2,0),(wb3,b3,0),(wb4,b4,0),
(wb5,b5,0),(wb6,b6,0),(wb7,b7,0),(wb8,b8,0),(wb9,b9,0),
(wb10,b10,0),(wb11,b11,0),(wb12,b12,0),(wb13,b13,0),(wb14,b14,0),
(wb15,b15,0),(wb16,b16,0),(wb17,b17,0),(wb18,b18,0),(wb19,b19,0),
(wb20,b20,0),(wb21,b21,0),(wb22,b22,0),(wb23,b23,0),(wb24,b24,0),
(wb25,b25,0),(wb26,b26,0),(wb27,b27,0),(wb28,b28,0),(wb29,b29,0),

(c0,c1,1),(c1,c2,1),(c2,c3,1),(c3,c4,1),(c4,c5,1),
(c5,c6,1),(c6,c7,1),(c7,c8,1),(c8,c9,1),(c9,c10,1),
(c10,c11,1),(c11,c12,1),(c12,c13,1),(c13,c14,1),(c14,c15,1),
(c15,c16,1),(c16,c17,1),(c17,c18,1),(c18,c19,1),(c19,c20,1),
(c20,c21,1),(c21,c22,1),(c22,c23,1),(c23,c24,1),(c24,c25,1),
(c25,c26,1),(c26,c27,1),(c27,c28,1),(c28,c29,1),(c29,i,1),
(wc0,c0,0),(wc1,c1,0),(wc2,c2,0),(wc3,c3,0),(wc4,c4,0),
(wc5,c5,0),(wc6,c6,0),(wc7,c7,0),(wc8,c8,0),(wc9,c9,0),
(wc10,c10,0),(wc11,c11,0),(wc12,c12,0),(wc13,c13,0),(wc14,c14,0),
(wc15,c15,0),(wc16,c16,0),(wc17,c17,0),(wc18,c18,0),(wc19,c19,0),
(wc20,c20,0),(wc21,c21,0),(wc22,c22,0),(wc23,c23,0),(wc24,c24,0),
(wc25,c25,0),(wc26,c26,0),(wc27,c27,0),(wc28,c28,0),(wc29,c29,0),

(d0,d1,1),(d1,d2,1),(d2,d3,1),(d3,d4,1),(d4,d5,1),
(d5,d6,1),(d6,d7,1),(d7,d8,1),(d8,d9,1),(d9,d10,1),
(d10,d11,1),(d11,d12,1),(d12,d13,1),(d13,d14,1),(d14,d15,1),
(d15,d16,1),(d16,d17,1),(d17,d18,1),(d18,d19,1),(d19,d20,1),
(d20,d21,1),(d21,d22,1),(d22,d23,1),(d23,d24,1),(d24,d25,1),
(d25,d26,1),(d26,d27,1),(d27,d28,1),(d28,d29,1),(d29,i,1),
(wd0,d0,0),(wd1,d1,0),(wd2,d2,0),(wd3,d3,0),(wd4,d4,0),
(wd5,d5,0),(wd6,d6,0),(wd7,d7,0),(wd8,d8,0),(wd9,d9,0),
(wd10,d10,0),(wd11,d11,0),(wd12,d12,0),(wd13,d13,0),(wd14,d14,0),
(wd15,d15,0),(wd16,d16,0),(wd17,d17,0),(wd18,d18,0),(wd19,d19,0),
(wd20,d20,0),(wd21,d21,0),(wd22,d22,0),(wd23,d23,0),(wd24,d24,0),
(wd25,d25,0),(wd26,d26,0),(wd27,d27,0),(wd28,d28,0),(wd29,d29,0),

(e0,e1,1),(e1,e2,1),(e2,e3,1),(e3,e4,1),(e4,e5,1),
(e5,e6,1),(e6,e7,1),(e7,e8,1),(e8,e9,1),(e9,e10,1),
(e10,e11,1),(e11,e12,1),(e12,e13,1),(e13,e14,1),(e14,e15,1),
(e15,e16,1),(e16,e17,1),(e17,e18,1),(e18,e19,1),(e19,e20,1),
(e20,e21,1),(e21,e22,1),(e22,e23,1),(e23,e24,1),(e24,e25,1),
(e25,e26,1),(e26,e27,1),(e27,e28,1),(e28,e29,1),(e29,i,1),
(we0,e0,0),(we1,e1,0),(we2,e2,0),(we3,e3,0),(we4,e4,0),
(we5,e5,0),(we6,e6,0),(we7,e7,0),(we8,e8,0),(we9,e9,0),
(we10,e10,0),(we11,e11,0),(we12,e12,0),(we13,e13,0),(we14,e14,0),
(we15,e15,0),(we16,e16,0),(we17,e17,0),(we18,e18,0),(we19,e19,0),
(we20,e20,0),(we21,e21,0),(we22,e22,0),(we23,e23,0),(we24,e24,0),
(we25,e25,0),(we26,e26,0),(we27,e27,0),(we28,e28,0),(we29,e29,0),

(f0,f1,1),(f1,f2,1),(f2,f3,1),(f3,f4,1),(f4,f5,1),
(f5,f6,1),(f6,f7,1),(f7,f8,1),(f8,f9,1),(f9,f10,1),
(f10,f11,1),(f11,f12,1),(f12,f13,1),(f13,f14,1),(f14,f15,1),
(f15,f16,1),(f16,f17,1),(f17,f18,1),(f18,f19,1),(f19,f20,1),
(f20,f21,1),(f21,f22,1),(f22,f23,1),(f23,f24,1),(f24,f25,1),
(f25,f26,1),(f26,f27,1),(f27,f28,1),(f28,f29,1),(f29,i,1),
(wf0,f0,0),(wf1,f1,0),(wf2,f2,0),(wf3,f3,0),(wf4,f4,0),
(wf5,f5,0),(wf6,f6,0),(wf7,f7,0),(wf8,f8,0),(wf9,f9,0),
(wf10,f10,0),(wf11,f11,0),(wf12,f12,0),(wf13,f13,0),(wf14,f14,0),
(wf15,f15,0),(wf16,f16,0),(wf17,f17,0),(wf18,f18,0),(wf19,f19,0),
(wf20,f20,0),(wf21,f21,0),(wf22,f22,0),(wf23,f23,0),(wf24,f24,0),
(wf25,f25,0),(wf26,f26,0),(wf27,f27,0),(wf28,f28,0),(wf29,f29,0),

(g0,g1,1),(g1,g2,1),(g2,g3,1),(g3,g4,1),(g4,g5,1),
(g5,g6,1),(g6,g7,1),(g7,g8,1),(g8,g9,1),(g9,g10,1),
(g10,g11,1),(g11,g12,1),(g12,g13,1),(g13,g14,1),(g14,g15,1),
(g15,g16,1),(g16,g17,1),(g17,g18,1),(g18,g19,1),(g19,g20,1),
(g20,g21,1),(g21,g22,1),(g22,g23,1),(g23,g24,1),(g24,g25,1),
(g25,g26,1),(g26,g27,1),(g27,g28,1),(g28,g29,1),(g29,i,1),
(wg0,g0,0),(wg1,g1,0),(wg2,g2,0),(wg3,g3,0),(wg4,g4,0),
(wg5,g5,0),(wg6,g6,0),(wg7,g7,0),(wg8,g8,0),(wg9,g9,0),
(wg10,g10,0),(wg11,g11,0),(wg12,g12,0),(wg13,g13,0),(wg14,g14,0),
(wg15,g15,0),(wg16,g16,0),(wg17,g17,0),(wg18,g18,0),(wg19,g19,0),
(wg20,g20,0),(wg21,g21,0),(wg22,g22,0),(wg23,g23,0),(wg24,g24,0),
(wg25,g25,0),(wg26,g26,0),(wg27,g27,0),(wg28,g28,0),(wg29,g29,0),

(h0,h1,1),(h1,h2,1),(h2,h3,1),(h3,h4,1),(h4,h5,1),
(h5,h6,1),(h6,h7,1),(h7,h8,1),(h8,h9,1),(h9,h10,1),
(h10,h11,1),(h11,h12,1),(h12,h13,1),(h13,h14,1),(h14,h15,1),
(h15,h16,1),(h16,h17,1),(h17,h18,1),(h18,h19,1),(h19,h20,1),
(h20,h21,1),(h21,h22,1),(h22,h23,1),(h23,h24,1),(h24,h25,1),
(h25,h26,1),(h26,h27,1),(h27,h28,1),(h28,h29,1),(h29,i,1),
(wh0,h0,0),(wh1,h1,0),(wh2,h2,0),(wh3,h3,0),(wh4,h4,0),
(wh5,h5,0),(wh6,h6,0),(wh7,h7,0),(wh8,h8,0),(wh9,h9,0),
(wh10,h10,0),(wh11,h11,0),(wh12,h12,0),(wh13,h13,0),(wh14,h14,0),
(wh15,h15,0),(wh16,h16,0),(wh17,h17,0),(wh18,h18,0),(wh19,h19,0),
(wh20,h20,0),(wh21,h21,0),(wh22,h22,0),(wh23,h23,0),(wh24,h24,0),
(wh25,h25,0),(wh26,h26,0),(wh27,h27,0),(wh28,h28,0),(wh29,h29,0),

(i0,i1,1),(i1,i2,1),(i2,i3,1),(i3,i4,1),(i4,i5,1),
(i5,i6,1),(i6,i7,1),(i7,i8,1),(i8,i9,1),(i9,i10,1),
(i10,i11,1),(i11,i12,1),(i12,i13,1),(i13,i14,1),(i14,i15,1),
(i15,i16,1),(i16,i17,1),(i17,i18,1),(i18,i19,1),(i19,i20,1),
(i20,i21,1),(i21,i22,1),(i22,i23,1),(i23,i24,1),(i24,i25,1),
(i25,i26,1),(i26,i27,1),(i27,i28,1),(i28,i29,1),(i29,i,1),
(wi0,i0,0),(wi1,i1,0),(wi2,i2,0),(wi3,i3,0),(wi4,i4,0),
(wi5,i5,0),(wi6,i6,0),(wi7,i7,0),(wi8,i8,0),(wi9,i9,0),
(wi10,i10,0),(wi11,i11,0),(wi12,i12,0),(wi13,i13,0),(wi14,i14,0),
(wi15,i15,0),(wi16,i16,0),(wi17,i17,0),(wi18,i18,0),(wi19,i19,0),
(wi20,i20,0),(wi21,i21,0),(wi22,i22,0),(wi23,i23,0),(wi24,i24,0),
(wi25,i25,0),(wi26,i26,0),(wi27,i27,0),(wi28,i28,0),(wi29,i29,0),

(j0,j1,1),(j1,j2,1),(j2,j3,1),(j3,j4,1),(j4,j5,1),
(j5,j6,1),(j6,j7,1),(j7,j8,1),(j8,j9,1),(j9,j10,1),
(j10,j11,1),(j11,j12,1),(j12,j13,1),(j13,j14,1),(j14,j15,1),
(j15,j16,1),(j16,j17,1),(j17,j18,1),(j18,j19,1),(j19,j20,1),
(j20,j21,1),(j21,j22,1),(j22,j23,1),(j23,j24,1),(j24,j25,1),
(j25,j26,1),(j26,j27,1),(j27,j28,1),(j28,j29,1),(j29,i,1),
(wj0,j0,0),(wj1,j1,0),(wj2,j2,0),(wj3,j3,0),(wj4,j4,0),
(wj5,j5,0),(wj6,j6,0),(wj7,j7,0),(wj8,j8,0),(wj9,j9,0),
(wj10,j10,0),(wj11,j11,0),(wj12,j12,0),(wj13,j13,0),(wj14,j14,0),
(wj15,j15,0),(wj16,j16,0),(wj17,j17,0),(wj18,j18,0),(wj19,j19,0),
(wj20,j20,0),(wj21,j21,0),(wj22,j22,0),(wj23,j23,0),(wj24,j24,0),
(wj25,j25,0),(wj26,j26,0),(wj27,j27,0),(wj28,j28,0),(wj29,j29,0),

(k0,k1,1),(k1,k2,1),(k2,k3,1),(k3,k4,1),(k4,k5,1),
(k5,k6,1),(k6,k7,1),(k7,k8,1),(k8,k9,1),(k9,k10,1),
(k10,k11,1),(k11,k12,1),(k12,k13,1),(k13,k14,1),(k14,k15,1),
(k15,k16,1),(k16,k17,1),(k17,k18,1),(k18,k19,1),(k19,k20,1),
(k20,k21,1),(k21,k22,1),(k22,k23,1),(k23,k24,1),(k24,k25,1),
(k25,k26,1),(k26,k27,1),(k27,k28,1),(k28,k29,1),(k29,i,1),
(wk0,k0,0),(wk1,k1,0),(wk2,k2,0),(wk3,k3,0),(wk4,k4,0),
(wk5,k5,0),(wk6,k6,0),(wk7,k7,0),(wk8,k8,0),(wk9,k9,0),
(wk10,k10,0),(wk11,k11,0),(wk12,k12,0),(wk13,k13,0),(wk14,k14,0),
(wk15,k15,0),(wk16,k16,0),(wk17,k17,0),(wk18,k18,0),(wk19,k19,0),
(wk20,k20,0),(wk21,k21,0),(wk22,k22,0),(wk23,k23,0),(wk24,k24,0),
(wk25,k25,0),(wk26,k26,0),(wk27,k27,0),(wk28,k28,0),(wk29,k29,0),

(l0,l1,1),(l1,l2,1),(l2,l3,1),(l3,l4,1),(l4,l5,1),
(l5,l6,1),(l6,l7,1),(l7,l8,1),(l8,l9,1),(l9,l10,1),
(l10,l11,1),(l11,l12,1),(l12,l13,1),(l13,l14,1),(l14,l15,1),
(l15,l16,1),(l16,l17,1),(l17,l18,1),(l18,l19,1),(l19,l20,1),
(l20,l21,1),(l21,l22,1),(l22,l23,1),(l23,l24,1),(l24,l25,1),
(l25,l26,1),(l26,l27,1),(l27,l28,1),(l28,l29,1),(l29,i,1),
(wl0,l0,0),(wl1,l1,0),(wl2,l2,0),(wl3,l3,0),(wl4,l4,0),
(wl5,l5,0),(wl6,l6,0),(wl7,l7,0),(wl8,l8,0),(wl9,l9,0),
(wl10,l10,0),(wl11,l11,0),(wl12,l12,0),(wl13,l13,0),(wl14,l14,0),
(wl15,l15,0),(wl16,l16,0),(wl17,l17,0),(wl18,l18,0),(wl19,l19,0),
(wl20,l20,0),(wl21,l21,0),(wl22,l22,0),(wl23,l23,0),(wl24,l24,0),
(wl25,l25,0),(wl26,l26,0),(wl27,l27,0),(wl28,l28,0),(wl29,l29,0),

(m0,m1,1),(m1,m2,1),(m2,m3,1),(m3,m4,1),(m4,m5,1),
(m5,m6,1),(m6,m7,1),(m7,m8,1),(m8,m9,1),(m9,m10,1),
(m10,m11,1),(m11,m12,1),(m12,m13,1),(m13,m14,1),(m14,m15,1),
(m15,m16,1),(m16,m17,1),(m17,m18,1),(m18,m19,1),(m19,m20,1),
(m20,m21,1),(m21,m22,1),(m22,m23,1),(m23,m24,1),(m24,m25,1),
(m25,m26,1),(m26,m27,1),(m27,m28,1),(m28,m29,1),(m29,i,1),
(wm0,m0,0),(wm1,m1,0),(wm2,m2,0),(wm3,m3,0),(wm4,m4,0),
(wm5,m5,0),(wm6,m6,0),(wm7,m7,0),(wm8,m8,0),(wm9,m9,0),
(wm10,m10,0),(wm11,m11,0),(wm12,m12,0),(wm13,m13,0),(wm14,m14,0),
(wm15,m15,0),(wm16,m16,0),(wm17,m17,0),(wm18,m18,0),(wm19,m19,0),
(wm20,m20,0),(wm21,m21,0),(wm22,m22,0),(wm23,m23,0),(wm24,m24,0),
(wm25,m25,0),(wm26,m26,0),(wm27,m27,0),(wm28,m28,0),(wm29,m29,0),

(n0,n1,1),(n1,n2,1),(n2,n3,1),(n3,n4,1),(n4,n5,1),
(n5,n6,1),(n6,n7,1),(n7,n8,1),(n8,n9,1),(n9,n10,1),
(n10,n11,1),(n11,n12,1),(n12,n13,1),(n13,n14,1),(n14,n15,1),
(n15,n16,1),(n16,n17,1),(n17,n18,1),(n18,n19,1),(n19,n20,1),
(n20,n21,1),(n21,n22,1),(n22,n23,1),(n23,n24,1),(n24,n25,1),
(n25,n26,1),(n26,n27,1),(n27,n28,1),(n28,n29,1),(n29,i,1),
(wn0,n0,0),(wn1,n1,0),(wn2,n2,0),(wn3,n3,0),(wn4,n4,0),
(wn5,n5,0),(wn6,n6,0),(wn7,n7,0),(wn8,n8,0),(wn9,n9,0),
(wn10,n10,0),(wn11,n11,0),(wn12,n12,0),(wn13,n13,0),(wn14,n14,0),
(wn15,n15,0),(wn16,n16,0),(wn17,n17,0),(wn18,n18,0),(wn19,n19,0),
(wn20,n20,0),(wn21,n21,0),(wn22,n22,0),(wn23,n23,0),(wn24,n24,0),
(wn25,n25,0),(wn26,n26,0),(wn27,n27,0),(wn28,n28,0),(wn29,n29,0);

prim_nand3 #3
(o0,o1,1,1),(o1,o2,1,1),(o2,o3,1,1),(o3,o4,1,1),(o4,o5,1,1),
(o5,o6,1,1),(o6,o7,1,1),(o7,o8,1,1),(o8,o9,1,1),(o9,o10,1,1),
(o10,o11,1,1),(o11,o12,1,1),(o12,o13,1,1),(o13,o14,1,1),(o14,o15,1,1),
(o15,o16,1,1),(o16,o17,1,1),(o17,o18,1,1),(o18,o19,1,1),(o19,o20,1,1),
(o20,o21,1,1),(o21,o22,1,1),(o22,o23,1,1),(o23,o24,1,1),(o24,o25,1,1),
(o25,o26,1,1),(o26,o27,1,1),(o27,o28,1,1),(o28,o29,1,1),(o29,i,1,1),
(wo0,o0,0,0),(wo1,o1,0,0),(wo2,o2,0,0),(wo3,o3,0,0),(wo4,o4,0,0),
(wo5,o5,0,0),(wo6,o6,0,0),(wo7,o7,0,0),(wo8,o8,0,0),(wo9,o9,0,0),
(wo10,o10,0,0),(wo11,o11,0,0),(wo12,o12,0,0),(wo13,o13,0,0),(wo14,o14,0,0),
(wo15,o15,0,0),(wo16,o16,0,0),(wo17,o17,0,0),(wo18,o18,0,0),(wo19,o19,0,0),
(wo20,o20,0,0),(wo21,o21,0,0),(wo22,o22,0,0),(wo23,o23,0,0),(wo24,o24,0,0),
(wo25,o25,0,0),(wo26,o26,0,0),(wo27,o27,0,0),(wo28,o28,0,0),(wo29,o29,0,0),
(wo0,o0,0,0),(wo1,o1,0,0),(wo2,o2,0,0),(wo3,o3,0,0),(wo4,o4,0,0),
(wo5,o5,0,0),(wo6,o6,0,0),(wo7,o7,0,0),(wo8,o8,0,0),(wo9,o9,0,0),
(wo10,o10,0,0),(wo11,o11,0,0),(wo12,o12,0,0),(wo13,o13,0,0),(wo14,o14,0,0),
(wo15,o15,0,0),(wo16,o16,0,0),(wo17,o17,0,0),(wo18,o18,0,0),(wo19,o19,0,0),
(wo20,o20,0,0),(wo21,o21,0,0),(wo22,o22,0,0),(wo23,o23,0,0),(wo24,o24,0,0),
(wo25,o25,0,0),(wo26,o26,0,0),(wo27,o27,0,0),(wo28,o28,0,0),(wo29,o29,0,0),

(p0,p1,1,1),(p1,p2,1,1),(p2,p3,1,1),(p3,p4,1,1),(p4,p5,1,1),
(p5,p6,1,1),(p6,p7,1,1),(p7,p8,1,1),(p8,p9,1,1),(p9,p10,1,1),
(p10,p11,1,1),(p11,p12,1,1),(p12,p13,1,1),(p13,p14,1,1),(p14,p15,1,1),
(p15,p16,1,1),(p16,p17,1,1),(p17,p18,1,1),(p18,p19,1,1),(p19,p20,1,1),
(p20,p21,1,1),(p21,p22,1,1),(p22,p23,1,1),(p23,p24,1,1),(p24,p25,1,1),
(p25,p26,1,1),(p26,p27,1,1),(p27,p28,1,1),(p28,p29,1,1),(p29,i,1,1),
(wp0,p0,0,0),(wp1,p1,0,0),(wp2,p2,0,0),(wp3,p3,0,0),(wp4,p4,0,0),
(wp5,p5,0,0),(wp6,p6,0,0),(wp7,p7,0,0),(wp8,p8,0,0),(wp9,p9,0,0),
(wp10,p10,0,0),(wp11,p11,0,0),(wp12,p12,0,0),(wp13,p13,0,0),(wp14,p14,0,0),
(wp15,p15,0,0),(wp16,p16,0,0),(wp17,p17,0,0),(wp18,p18,0,0),(wp19,p19,0,0),
(wp20,p20,0,0),(wp21,p21,0,0),(wp22,p22,0,0),(wp23,p23,0,0),(wp24,p24,0,0),
(wp25,p25,0,0),(wp26,p26,0,0),(wp27,p27,0,0),(wp28,p28,0,0),(wp29,p29,0,0),
(wp0,p0,0,0),(wp1,p1,0,0),(wp2,p2,0,0),(wp3,p3,0,0),(wp4,p4,0,0),
(wp5,p5,0,0),(wp6,p6,0,0),(wp7,p7,0,0),(wp8,p8,0,0),(wp9,p9,0,0),
(wp10,p10,0,0),(wp11,p11,0,0),(wp12,p12,0,0),(wp13,p13,0,0),(wp14,p14,0,0),
(wp15,p15,0,0),(wp16,p16,0,0),(wp17,p17,0,0),(wp18,p18,0,0),(wp19,p19,0,0),
(wp20,p20,0,0),(wp21,p21,0,0),(wp22,p22,0,0),(wp23,p23,0,0),(wp24,p24,0,0),
(wp25,p25,0,0),(wp26,p26,0,0),(wp27,p27,0,0),(wp28,p28,0,0),(wp29,p29,0,0),

(q0,q1,1,1),(q1,q2,1,1),(q2,q3,1,1),(q3,q4,1,1),(q4,q5,1,1),
(q5,q6,1,1),(q6,q7,1,1),(q7,q8,1,1),(q8,q9,1,1),(q9,q10,1,1),
(q10,q11,1,1),(q11,q12,1,1),(q12,q13,1,1),(q13,q14,1,1),(q14,q15,1,1),
(q15,q16,1,1),(q16,q17,1,1),(q17,q18,1,1),(q18,q19,1,1),(q19,q20,1,1),
(q20,q21,1,1),(q21,q22,1,1),(q22,q23,1,1),(q23,q24,1,1),(q24,q25,1,1),
(q25,q26,1,1),(q26,q27,1,1),(q27,q28,1,1),(q28,q29,1,1),(q29,i,1,1),
(wq0,q0,0,0),(wq1,q1,0,0),(wq2,q2,0,0),(wq3,q3,0,0),(wq4,q4,0,0),
(wq5,q5,0,0),(wq6,q6,0,0),(wq7,q7,0,0),(wq8,q8,0,0),(wq9,q9,0,0),
(wq10,q10,0,0),(wq11,q11,0,0),(wq12,q12,0,0),(wq13,q13,0,0),(wq14,q14,0,0),
(wq15,q15,0,0),(wq16,q16,0,0),(wq17,q17,0,0),(wq18,q18,0,0),(wq19,q19,0,0),
(wq20,q20,0,0),(wq21,q21,0,0),(wq22,q22,0,0),(wq23,q23,0,0),(wq24,q24,0,0),
(wq25,q25,0,0),(wq26,q26,0,0),(wq27,q27,0,0),(wq28,q28,0,0),(wq29,q29,0,0),
(wq0,q0,0,0),(wq1,q1,0,0),(wq2,q2,0,0),(wq3,q3,0,0),(wq4,q4,0,0),
(wq5,q5,0,0),(wq6,q6,0,0),(wq7,q7,0,0),(wq8,q8,0,0),(wq9,q9,0,0),
(wq10,q10,0,0),(wq11,q11,0,0),(wq12,q12,0,0),(wq13,q13,0,0),(wq14,q14,0,0),
(wq15,q15,0,0),(wq16,q16,0,0),(wq17,q17,0,0),(wq18,q18,0,0),(wq19,q19,0,0),
(wq20,q20,0,0),(wq21,q21,0,0),(wq22,q22,0,0),(wq23,q23,0,0),(wq24,q24,0,0),
(wq25,q25,0,0),(wq26,q26,0,0),(wq27,q27,0,0),(wq28,q28,0,0),(wq29,q29,0,0),

(r0,r1,1,1),(r1,r2,1,1),(r2,r3,1,1),(r3,r4,1,1),(r4,r5,1,1),
(r5,r6,1,1),(r6,r7,1,1),(r7,r8,1,1),(r8,r9,1,1),(r9,r10,1,1),
(r10,r11,1,1),(r11,r12,1,1),(r12,r13,1,1),(r13,r14,1,1),(r14,r15,1,1),
(r15,r16,1,1),(r16,r17,1,1),(r17,r18,1,1),(r18,r19,1,1),(r19,r20,1,1),
(r20,r21,1,1),(r21,r22,1,1),(r22,r23,1,1),(r23,r24,1,1),(r24,r25,1,1),
(r25,r26,1,1),(r26,r27,1,1),(r27,r28,1,1),(r28,r29,1,1),(r29,i,1,1),
(wr0,r0,0,0),(wr1,r1,0,0),(wr2,r2,0,0),(wr3,r3,0,0),(wr4,r4,0,0),
(wr5,r5,0,0),(wr6,r6,0,0),(wr7,r7,0,0),(wr8,r8,0,0),(wr9,r9,0,0),
(wr10,r10,0,0),(wr11,r11,0,0),(wr12,r12,0,0),(wr13,r13,0,0),(wr14,r14,0,0),
(wr15,r15,0,0),(wr16,r16,0,0),(wr17,r17,0,0),(wr18,r18,0,0),(wr19,r19,0,0),
(wr20,r20,0,0),(wr21,r21,0,0),(wr22,r22,0,0),(wr23,r23,0,0),(wr24,r24,0,0),
(wr25,r25,0,0),(wr26,r26,0,0),(wr27,r27,0,0),(wr28,r28,0,0),(wr29,r29,0,0),
(wr0,r0,0,0),(wr1,r1,0,0),(wr2,r2,0,0),(wr3,r3,0,0),(wr4,r4,0,0),
(wr5,r5,0,0),(wr6,r6,0,0),(wr7,r7,0,0),(wr8,r8,0,0),(wr9,r9,0,0),
(wr10,r10,0,0),(wr11,r11,0,0),(wr12,r12,0,0),(wr13,r13,0,0),(wr14,r14,0,0),
(wr15,r15,0,0),(wr16,r16,0,0),(wr17,r17,0,0),(wr18,r18,0,0),(wr19,r19,0,0),
(wr20,r20,0,0),(wr21,r21,0,0),(wr22,r22,0,0),(wr23,r23,0,0),(wr24,r24,0,0),
(wr25,r25,0,0),(wr26,r26,0,0),(wr27,r27,0,0),(wr28,r28,0,0),(wr29,r29,0,0),

(s0,s1,1,1),(s1,s2,1,1),(s2,s3,1,1),(s3,s4,1,1),(s4,s5,1,1),
(s5,s6,1,1),(s6,s7,1,1),(s7,s8,1,1),(s8,s9,1,1),(s9,s10,1,1),
(s10,s11,1,1),(s11,s12,1,1),(s12,s13,1,1),(s13,s14,1,1),(s14,s15,1,1),
(s15,s16,1,1),(s16,s17,1,1),(s17,s18,1,1),(s18,s19,1,1),(s19,s20,1,1),
(s20,s21,1,1),(s21,s22,1,1),(s22,s23,1,1),(s23,s24,1,1),(s24,s25,1,1),
(s25,s26,1,1),(s26,s27,1,1),(s27,s28,1,1),(s28,s29,1,1),(s29,i,1,1),
(ws0,s0,0,0),(ws1,s1,0,0),(ws2,s2,0,0),(ws3,s3,0,0),(ws4,s4,0,0),
(ws5,s5,0,0),(ws6,s6,0,0),(ws7,s7,0,0),(ws8,s8,0,0),(ws9,s9,0,0),
(ws10,s10,0,0),(ws11,s11,0,0),(ws12,s12,0,0),(ws13,s13,0,0),(ws14,s14,0,0),
(ws15,s15,0,0),(ws16,s16,0,0),(ws17,s17,0,0),(ws18,s18,0,0),(ws19,s19,0,0),
(ws20,s20,0,0),(ws21,s21,0,0),(ws22,s22,0,0),(ws23,s23,0,0),(ws24,s24,0,0),
(ws25,s25,0,0),(ws26,s26,0,0),(ws27,s27,0,0),(ws28,s28,0,0),(ws29,s29,0,0),
(ws0,s0,0,0),(ws1,s1,0,0),(ws2,s2,0,0),(ws3,s3,0,0),(ws4,s4,0,0),
(ws5,s5,0,0),(ws6,s6,0,0),(ws7,s7,0,0),(ws8,s8,0,0),(ws9,s9,0,0),
(ws10,s10,0,0),(ws11,s11,0,0),(ws12,s12,0,0),(ws13,s13,0,0),(ws14,s14,0,0),
(ws15,s15,0,0),(ws16,s16,0,0),(ws17,s17,0,0),(ws18,s18,0,0),(ws19,s19,0,0),
(ws20,s20,0,0),(ws21,s21,0,0),(ws22,s22,0,0),(ws23,s23,0,0),(ws24,s24,0,0),
(ws25,s25,0,0),(ws26,s26,0,0),(ws27,s27,0,0),(ws28,s28,0,0),(ws29,s29,0,0),

(t0,t1,1,1),(t1,t2,1,1),(t2,t3,1,1),(t3,t4,1,1),(t4,t5,1,1),
(t5,t6,1,1),(t6,t7,1,1),(t7,t8,1,1),(t8,t9,1,1),(t9,t10,1,1),
(t10,t11,1,1),(t11,t12,1,1),(t12,t13,1,1),(t13,t14,1,1),(t14,t15,1,1),
(t15,t16,1,1),(t16,t17,1,1),(t17,t18,1,1),(t18,t19,1,1),(t19,t20,1,1),
(t20,t21,1,1),(t21,t22,1,1),(t22,t23,1,1),(t23,t24,1,1),(t24,t25,1,1),
(t25,t26,1,1),(t26,t27,1,1),(t27,t28,1,1),(t28,t29,1,1),(t29,i,1,1),
(wt0,t0,0,0),(wt1,t1,0,0),(wt2,t2,0,0),(wt3,t3,0,0),(wt4,t4,0,0),
(wt5,t5,0,0),(wt6,t6,0,0),(wt7,t7,0,0),(wt8,t8,0,0),(wt9,t9,0,0),
(wt10,t10,0,0),(wt11,t11,0,0),(wt12,t12,0,0),(wt13,t13,0,0),(wt14,t14,0,0),
(wt15,t15,0,0),(wt16,t16,0,0),(wt17,t17,0,0),(wt18,t18,0,0),(wt19,t19,0,0),
(wt20,t20,0,0),(wt21,t21,0,0),(wt22,t22,0,0),(wt23,t23,0,0),(wt24,t24,0,0),
(wt25,t25,0,0),(wt26,t26,0,0),(wt27,t27,0,0),(wt28,t28,0,0),(wt29,t29,0,0),
(wt0,t0,0,0),(wt1,t1,0,0),(wt2,t2,0,0),(wt3,t3,0,0),(wt4,t4,0,0),
(wt5,t5,0,0),(wt6,t6,0,0),(wt7,t7,0,0),(wt8,t8,0,0),(wt9,t9,0,0),
(wt10,t10,0,0),(wt11,t11,0,0),(wt12,t12,0,0),(wt13,t13,0,0),(wt14,t14,0,0),
(wt15,t15,0,0),(wt16,t16,0,0),(wt17,t17,0,0),(wt18,t18,0,0),(wt19,t19,0,0),
(wt20,t20,0,0),(wt21,t21,0,0),(wt22,t22,0,0),(wt23,t23,0,0),(wt24,t24,0,0),
(wt25,t25,0,0),(wt26,t26,0,0),(wt27,t27,0,0),(wt28,t28,0,0),(wt29,t29,0,0),

(u0,u1,1,1),(u1,u2,1,1),(u2,u3,1,1),(u3,u4,1,1),(u4,u5,1,1),
(u5,u6,1,1),(u6,u7,1,1),(u7,u8,1,1),(u8,u9,1,1),(u9,u10,1,1),
(u10,u11,1,1),(u11,u12,1,1),(u12,u13,1,1),(u13,u14,1,1),(u14,u15,1,1),
(u15,u16,1,1),(u16,u17,1,1),(u17,u18,1,1),(u18,u19,1,1),(u19,u20,1,1),
(u20,u21,1,1),(u21,u22,1,1),(u22,u23,1,1),(u23,u24,1,1),(u24,u25,1,1),
(u25,u26,1,1),(u26,u27,1,1),(u27,u28,1,1),(u28,u29,1,1),(u29,i,1,1),
(wu0,u0,0,0),(wu1,u1,0,0),(wu2,u2,0,0),(wu3,u3,0,0),(wu4,u4,0,0),
(wu5,u5,0,0),(wu6,u6,0,0),(wu7,u7,0,0),(wu8,u8,0,0),(wu9,u9,0,0),
(wu10,u10,0,0),(wu11,u11,0,0),(wu12,u12,0,0),(wu13,u13,0,0),(wu14,u14,0,0),
(wu15,u15,0,0),(wu16,u16,0,0),(wu17,u17,0,0),(wu18,u18,0,0),(wu19,u19,0,0),
(wu20,u20,0,0),(wu21,u21,0,0),(wu22,u22,0,0),(wu23,u23,0,0),(wu24,u24,0,0),
(wu25,u25,0,0),(wu26,u26,0,0),(wu27,u27,0,0),(wu28,u28,0,0),(wu29,u29,0,0),
(wu0,u0,0,0),(wu1,u1,0,0),(wu2,u2,0,0),(wu3,u3,0,0),(wu4,u4,0,0),
(wu5,u5,0,0),(wu6,u6,0,0),(wu7,u7,0,0),(wu8,u8,0,0),(wu9,u9,0,0),
(wu10,u10,0,0),(wu11,u11,0,0),(wu12,u12,0,0),(wu13,u13,0,0),(wu14,u14,0,0),
(wu15,u15,0,0),(wu16,u16,0,0),(wu17,u17,0,0),(wu18,u18,0,0),(wu19,u19,0,0),
(wu20,u20,0,0),(wu21,u21,0,0),(wu22,u22,0,0),(wu23,u23,0,0),(wu24,u24,0,0),
(wu25,u25,0,0),(wu26,u26,0,0),(wu27,u27,0,0),(wu28,u28,0,0),(wu29,u29,0,0),

(v0,v1,1,1),(v1,v2,1,1),(v2,v3,1,1),(v3,v4,1,1),(v4,v5,1,1),
(v5,v6,1,1),(v6,v7,1,1),(v7,v8,1,1),(v8,v9,1,1),(v9,v10,1,1),
(v10,v11,1,1),(v11,v12,1,1),(v12,v13,1,1),(v13,v14,1,1),(v14,v15,1,1),
(v15,v16,1,1),(v16,v17,1,1),(v17,v18,1,1),(v18,v19,1,1),(v19,v20,1,1),
(v20,v21,1,1),(v21,v22,1,1),(v22,v23,1,1),(v23,v24,1,1),(v24,v25,1,1),
(v25,v26,1,1),(v26,v27,1,1),(v27,v28,1,1),(v28,v29,1,1),(v29,i,1,1),
(wv0,v0,0,0),(wv1,v1,0,0),(wv2,v2,0,0),(wv3,v3,0,0),(wv4,v4,0,0),
(wv5,v5,0,0),(wv6,v6,0,0),(wv7,v7,0,0),(wv8,v8,0,0),(wv9,v9,0,0),
(wv10,v10,0,0),(wv11,v11,0,0),(wv12,v12,0,0),(wv13,v13,0,0),(wv14,v14,0,0),
(wv15,v15,0,0),(wv16,v16,0,0),(wv17,v17,0,0),(wv18,v18,0,0),(wv19,v19,0,0),
(wv20,v20,0,0),(wv21,v21,0,0),(wv22,v22,0,0),(wv23,v23,0,0),(wv24,v24,0,0),
(wv25,v25,0,0),(wv26,v26,0,0),(wv27,v27,0,0),(wv28,v28,0,0),(wv29,v29,0,0),
(wv0,v0,0,0),(wv1,v1,0,0),(wv2,v2,0,0),(wv3,v3,0,0),(wv4,v4,0,0),
(wv5,v5,0,0),(wv6,v6,0,0),(wv7,v7,0,0),(wv8,v8,0,0),(wv9,v9,0,0),
(wv10,v10,0,0),(wv11,v11,0,0),(wv12,v12,0,0),(wv13,v13,0,0),(wv14,v14,0,0),
(wv15,v15,0,0),(wv16,v16,0,0),(wv17,v17,0,0),(wv18,v18,0,0),(wv19,v19,0,0),
(wv20,v20,0,0),(wv21,v21,0,0),(wv22,v22,0,0),(wv23,v23,0,0),(wv24,v24,0,0),
(wv25,v25,0,0),(wv26,v26,0,0),(wv27,v27,0,0),(wv28,v28,0,0),(wv29,v29,0,0),

(w0,w1,1,1),(w1,w2,1,1),(w2,w3,1,1),(w3,w4,1,1),(w4,w5,1,1),
(w5,w6,1,1),(w6,w7,1,1),(w7,w8,1,1),(w8,w9,1,1),(w9,w10,1,1),
(w10,w11,1,1),(w11,w12,1,1),(w12,w13,1,1),(w13,w14,1,1),(w14,w15,1,1),
(w15,w16,1,1),(w16,w17,1,1),(w17,w18,1,1),(w18,w19,1,1),(w19,w20,1,1),
(w20,w21,1,1),(w21,w22,1,1),(w22,w23,1,1),(w23,w24,1,1),(w24,w25,1,1),
(w25,w26,1,1),(w26,w27,1,1),(w27,w28,1,1),(w28,w29,1,1),(w29,i,1,1),
(ww0,w0,0,0),(ww1,w1,0,0),(ww2,w2,0,0),(ww3,w3,0,0),(ww4,w4,0,0),
(ww5,w5,0,0),(ww6,w6,0,0),(ww7,w7,0,0),(ww8,w8,0,0),(ww9,w9,0,0),
(ww10,w10,0,0),(ww11,w11,0,0),(ww12,w12,0,0),(ww13,w13,0,0),(ww14,w14,0,0),
(ww15,w15,0,0),(ww16,w16,0,0),(ww17,w17,0,0),(ww18,w18,0,0),(ww19,w19,0,0),
(ww20,w20,0,0),(ww21,w21,0,0),(ww22,w22,0,0),(ww23,w23,0,0),(ww24,w24,0,0),
(ww25,w25,0,0),(ww26,w26,0,0),(ww27,w27,0,0),(ww28,w28,0,0),(ww29,w29,0,0),
(ww0,w0,0,0),(ww1,w1,0,0),(ww2,w2,0,0),(ww3,w3,0,0),(ww4,w4,0,0),
(ww5,w5,0,0),(ww6,w6,0,0),(ww7,w7,0,0),(ww8,w8,0,0),(ww9,w9,0,0),
(ww10,w10,0,0),(ww11,w11,0,0),(ww12,w12,0,0),(ww13,w13,0,0),(ww14,w14,0,0),
(ww15,w15,0,0),(ww16,w16,0,0),(ww17,w17,0,0),(ww18,w18,0,0),(ww19,w19,0,0),
(ww20,w20,0,0),(ww21,w21,0,0),(ww22,w22,0,0),(ww23,w23,0,0),(ww24,w24,0,0),
(ww25,w25,0,0),(ww26,w26,0,0),(ww27,w27,0,0),(ww28,w28,0,0),(ww29,w29,0,0),

(x0,x1,1,1),(x1,x2,1,1),(x2,x3,1,1),(x3,x4,1,1),(x4,x5,1,1),
(x5,x6,1,1),(x6,x7,1,1),(x7,x8,1,1),(x8,x9,1,1),(x9,x10,1,1),
(x10,x11,1,1),(x11,x12,1,1),(x12,x13,1,1),(x13,x14,1,1),(x14,x15,1,1),
(x15,x16,1,1),(x16,x17,1,1),(x17,x18,1,1),(x18,x19,1,1),(x19,x20,1,1),
(x20,x21,1,1),(x21,x22,1,1),(x22,x23,1,1),(x23,x24,1,1),(x24,x25,1,1),
(x25,x26,1,1),(x26,x27,1,1),(x27,x28,1,1),(x28,x29,1,1),(x29,i,1,1),
(wx0,x0,0,0),(wx1,x1,0,0),(wx2,x2,0,0),(wx3,x3,0,0),(wx4,x4,0,0),
(wx5,x5,0,0),(wx6,x6,0,0),(wx7,x7,0,0),(wx8,x8,0,0),(wx9,x9,0,0),
(wx10,x10,0,0),(wx11,x11,0,0),(wx12,x12,0,0),(wx13,x13,0,0),(wx14,x14,0,0),
(wx15,x15,0,0),(wx16,x16,0,0),(wx17,x17,0,0),(wx18,x18,0,0),(wx19,x19,0,0),
(wx20,x20,0,0),(wx21,x21,0,0),(wx22,x22,0,0),(wx23,x23,0,0),(wx24,x24,0,0),
(wx25,x25,0,0),(wx26,x26,0,0),(wx27,x27,0,0),(wx28,x28,0,0),(wx29,x29,0,0),
(wx0,x0,0,0),(wx1,x1,0,0),(wx2,x2,0,0),(wx3,x3,0,0),(wx4,x4,0,0),
(wx5,x5,0,0),(wx6,x6,0,0),(wx7,x7,0,0),(wx8,x8,0,0),(wx9,x9,0,0),
(wx10,x10,0,0),(wx11,x11,0,0),(wx12,x12,0,0),(wx13,x13,0,0),(wx14,x14,0,0),
(wx15,x15,0,0),(wx16,x16,0,0),(wx17,x17,0,0),(wx18,x18,0,0),(wx19,x19,0,0),
(wx20,x20,0,0),(wx21,x21,0,0),(wx22,x22,0,0),(wx23,x23,0,0),(wx24,x24,0,0),
(wx25,x25,0,0),(wx26,x26,0,0),(wx27,x27,0,0),(wx28,x28,0,0),(wx29,x29,0,0),

(y0,y1,1,1),(y1,y2,1,1),(y2,y3,1,1),(y3,y4,1,1),(y4,y5,1,1),
(y5,y6,1,1),(y6,y7,1,1),(y7,y8,1,1),(y8,y9,1,1),(y9,y10,1,1),
(y10,y11,1,1),(y11,y12,1,1),(y12,y13,1,1),(y13,y14,1,1),(y14,y15,1,1),
(y15,y16,1,1),(y16,y17,1,1),(y17,y18,1,1),(y18,y19,1,1),(y19,y20,1,1),
(y20,y21,1,1),(y21,y22,1,1),(y22,y23,1,1),(y23,y24,1,1),(y24,y25,1,1),
(y25,y26,1,1),(y26,y27,1,1),(y27,y28,1,1),(y28,y29,1,1),(y29,i,1,1),
(wy0,y0,0,0),(wy1,y1,0,0),(wy2,y2,0,0),(wy3,y3,0,0),(wy4,y4,0,0),
(wy5,y5,0,0),(wy6,y6,0,0),(wy7,y7,0,0),(wy8,y8,0,0),(wy9,y9,0,0),
(wy10,y10,0,0),(wy11,y11,0,0),(wy12,y12,0,0),(wy13,y13,0,0),(wy14,y14,0,0),
(wy15,y15,0,0),(wy16,y16,0,0),(wy17,y17,0,0),(wy18,y18,0,0),(wy19,y19,0,0),
(wy20,y20,0,0),(wy21,y21,0,0),(wy22,y22,0,0),(wy23,y23,0,0),(wy24,y24,0,0),
(wy25,y25,0,0),(wy26,y26,0,0),(wy27,y27,0,0),(wy28,y28,0,0),(wy29,y29,0,0),
(wy0,y0,0,0),(wy1,y1,0,0),(wy2,y2,0,0),(wy3,y3,0,0),(wy4,y4,0,0),
(wy5,y5,0,0),(wy6,y6,0,0),(wy7,y7,0,0),(wy8,y8,0,0),(wy9,y9,0,0),
(wy10,y10,0,0),(wy11,y11,0,0),(wy12,y12,0,0),(wy13,y13,0,0),(wy14,y14,0,0),
(wy15,y15,0,0),(wy16,y16,0,0),(wy17,y17,0,0),(wy18,y18,0,0),(wy19,y19,0,0),
(wy20,y20,0,0),(wy21,y21,0,0),(wy22,y22,0,0),(wy23,y23,0,0),(wy24,y24,0,0),
(wy25,y25,0,0),(wy26,y26,0,0),(wy27,y27,0,0),(wy28,y28,0,0),(wy29,y29,0,0),

(z0,z1,1,1),(z1,z2,1,1),(z2,z3,1,1),(z3,z4,1,1),(z4,z5,1,1),
(z5,z6,1,1),(z6,z7,1,1),(z7,z8,1,1),(z8,z9,1,1),(z9,z10,1,1),
(z10,z11,1,1),(z11,z12,1,1),(z12,z13,1,1),(z13,z14,1,1),(z14,z15,1,1),
(z15,z16,1,1),(z16,z17,1,1),(z17,z18,1,1),(z18,z19,1,1),(z19,z20,1,1),
(z20,z21,1,1),(z21,z22,1,1),(z22,z23,1,1),(z23,z24,1,1),(z24,z25,1,1),
(z25,z26,1,1),(z26,z27,1,1),(z27,z28,1,1),(z28,z29,1,1),(z29,i,1,1),
(wz0,z0,0,0),(wz1,z1,0,0),(wz2,z2,0,0),(wz3,z3,0,0),(wz4,z4,0,0),
(wz5,z5,0,0),(wz6,z6,0,0),(wz7,z7,0,0),(wz8,z8,0,0),(wz9,z9,0,0),
(wz10,z10,0,0),(wz11,z11,0,0),(wz12,z12,0,0),(wz13,z13,0,0),(wz14,z14,0,0),
(wz15,z15,0,0),(wz16,z16,0,0),(wz17,z17,0,0),(wz18,z18,0,0),(wz19,z19,0,0),
(wz20,z20,0,0),(wz21,z21,0,0),(wz22,z22,0,0),(wz23,z23,0,0),(wz24,z24,0,0),
(wz25,z25,0,0),(wz26,z26,0,0),(wz27,z27,0,0),(wz28,z28,0,0),(wz29,z29,0,0),
(wz0,z0,0,0),(wz1,z1,0,0),(wz2,z2,0,0),(wz3,z3,0,0),(wz4,z4,0,0),
(wz5,z5,0,0),(wz6,z6,0,0),(wz7,z7,0,0),(wz8,z8,0,0),(wz9,z9,0,0),
(wz10,z10,0,0),(wz11,z11,0,0),(wz12,z12,0,0),(wz13,z13,0,0),(wz14,z14,0,0),
(wz15,z15,0,0),(wz16,z16,0,0),(wz17,z17,0,0),(wz18,z18,0,0),(wz19,z19,0,0),
(wz20,z20,0,0),(wz21,z21,0,0),(wz22,z22,0,0),(wz23,z23,0,0),(wz24,z24,0,0),
(wz25,z25,0,0),(wz26,z26,0,0),(wz27,z27,0,0),(wz28,z28,0,0),(wz29,z29,0,0);

endmodule


primitive prim_nand2(out, in1, in2);
output out;
input in1, in2;
table
    11:1;
    0?:0;
    ?0:0;
endtable
endprimitive

primitive prim_nand3(out, in1, in2, in3);
output out;
input in1, in2, in3;
table
    111:1;
    0??:0;
    ?0?:0;
    ??0:0;
endtable
endprimitive
