/******************************************************************
 * NOTICE: The information contained in this file is proprietary  *
 * to Cadence Design Systems and is being made available          *
 * to Cadence customers under strict non-disclosure agreements.   *
 * Use or disclosure of this information is permissible only      *
 * under the terms of the existing non-disclosure agreement.      *
 ******************************************************************/

// Simulation control module and 
// waveform description for the MOS01 circuit
module mos01_wave;

    // Circuit inputs
    reg
        VCC,VSS;

    // Circuit outputs
    tri
        NCI,NCO;

    // Circuit bidirectionals
    reg
        i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16;
    trior
        A=i2, B=i3, Q1=i4,
        \M<0> =i5, \M<1> =i6, \M<2> =i7, \M<3> =i8, \M<4> =i9,
        CBRK=i10, PV=i11, NOV=i12, NV=i13, CC1=i14, CCZ=i15, S=i16;

    // Instantiation of the MOS01 circuit
    MOS01
        cct(VCC, VSS,
            A,B,Q1,\M<0> ,\M<1> ,\M<2> ,\M<3> ,\M<4> ,CBRK,PV,NOV,NV,
            CC1,CCZ,S,
            NCI,NCO);

    parameter d = 100; // defines the waveform time step
    integer test_number; // test number for display
    initial test_number = 1; // initialize test number

    // Display test number, circuit stimulus and response values
    initial #(d-1)
        forever
            begin
                #d $display("Test %d   %b -> %b", test_number,
                    {VCC,VSS,
                        i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16},
                    {A,B,Q1,\M<0> ,\M<1> ,\M<2> ,\M<3> ,\M<4> ,CBRK,PV,NOV,NV,
                        CC1,CCZ,NCI,NCO,S});
                test_number = test_number + 1;
            end

    // Stimulus patterns
    parameter X=1'bx, Z=1'bz;
    initial
        begin
            #d  VCC=1; VSS=0; i2=1; i3=1; i4=0; i5=0; i6=0; i7=1; i8=1;
                i9=1; i10=1; i11=1; i12=0; i13=0; i14=0; i15=0; i16=0;
            #d  i2=0; i3=0; i5=1; i6=1; i7=0; i9=0; i12=1; i15=1;
            #d  i3=1; i5=X; i6=X; i7=1; i8=X; i9=1; i10=X; i13=1;
                i14=Z; i15=Z;
            #d  i4=1; i7=0; i9=0; i10=0; i11=X; i12=X; i13=X;
                i14=X; i15=X; i16=X;
            #d  i7=1; i14=Z;
            #d  i2=1; i5=0; i7=0; i14=X;
            #d  i4=0; i5=1; i7=X; i9=1; i11=0; i12=1; i13=1;
                i14=Z; i15=0; i16=0;
            #d  i3=0; i4=1; i5=X; i6=0; i8=0; i9=0; i11=X; i12=X; i13=X;
                i14=X; i15=X; i16=X;
            #d  i4=0; i6=1; i8=X; i9=1; i11=0; i12=1; i13=1;
                i14=Z; i15=0; i16=0;
            #d  i2=0; i4=1; i6=X; i8=0; i9=0; i11=X; i12=X; i13=X;
                i14=X; i15=X; i16=X;
            #d  i8=1;
            #d  i2=1; i3=1; i4=0; i5=1; i7=1; i8=X;
            #d  i2=0; i5=X; i9=1; i10=X; i11=0; i12=1; i13=1; i15=Z; i16=0;
            #d  i2=1; i4=1; i5=1; i7=0; i9=0; i10=0; i12=0; i15=X; i16=Z;
            #d  i2=0; i5=0; i7=1; i8=0; i13=0;
            #d  i3=0; i5=X; i7=0; i8=1; i11=X; i12=X; i13=X; i16=X;
            #d  i3=1; i8=X; i9=X; i10=1;
            #d  i2=1; i3=0; i6=1; i7=X; i8=0; i9=0; i10=0;
            #d  i3=1; i4=0; i5=1; i6=X; i7=1; i8=X; i9=X; i10=1;
            #d  i2=Z; i3=Z; i4=Z; i5=X; i7=X; i10=X;
            #d  i2=X; i3=X; i4=X; i5=Z; i6=Z; i7=Z; i8=Z;
                i9=Z; i10=Z; i11=Z; i12=Z; i13=Z;
            #d  i2=0; i3=1; i4=0; i5=X; i6=X; i7=1; i8=X;
                i9=1; i10=1; i11=0; i12=1; i13=X; i15=Z; i16=1;
            #d  i4=1; i9=0; i10=0; i13=1; i16=0;
            #d  i7=0; i9=1; i10=X; i14=Z; i15=1;
            #d  i2=1; i5=0; i7=1; i10=1;
            #d  i2=0; i5=1; i7=0;
            #d  i2=1; i3=0; i6=0; i8=0;
                i9=0; i10=0; i11=X; i12=X; i13=X;
                i14=X; i15=X; i16=X;
            #d  i2=0; i5=X; i6=X; i7=1;
            #d  i2=1; i3=1; i5=0; i6=1; i7=0;
            #d  i2=0; i5=X; i6=X; i8=1;
            #d  $finish;
        end
endmodule // mos01_wave


// Description of the MOS01 network
module MOS01(VCC,VSS,A,B,Q1,\M<0> ,\M<1> ,\M<2> ,\M<3> ,\M<4> ,
        CBRK,PV,NOV,NV,
        CC1,CCZ,S,NCI,NCO);
    input VCC,VSS;
    inout A,B,Q1,\M<0> ,\M<1> ,\M<2> ,\M<3> ,\M<4> ,
        CBRK,PV,NOV,NV,CC1,CCZ,S;
    output NCI,NCO;
    tri #(5,3,7)
        NCO,NCI,NS;
    triand #(5,3,7)
        X7,X6,NP,NG;
    trior #(5,3,7)
        S,NNS,CC1,CCZ,A,B,Q1,\M<0> ,\M<1> ,\M<2> ,\M<3> ,\M<4> ,CBRK,PV,
        NOV,NV;
    wire
        X13,X12,XT,XG,NA,NNA,NNB,NB,X4,X3,X2,X1;
    nmos #(5,3,7)
        ALUBIT34(S,VSS,NV),
        ALUBIT33(S,VCC,PV),
        ALUBIT31(CCZ,VSS,NNS),
        ALUBIT30(CC1,VSS,NS),
        ALUBIT23(NCO,VCC,Q1),
        ALUBIT22(NCI,VSS,\M<4> ),
        ALUBIT19(NCO,VSS,XG),
        ALUBIT17(NG,VCC,Q1),
        ALUBIT16(NP,VCC,Q1),
        (X4,VSS,\M<3> ),
        (X3,VSS,\M<2> ),
        (X2,VSS,\M<1> ),
        (X1,VSS,\M<0> ),
        \$AXNOR-2 (NS,X13,X12),
        \$AXNOR-1 (NS,X12,X13);
    tranif1 #(7,3)
        ALUBIT32(S,NNS,NOV),
        ALUBIT21(NCO,NCI,XT),
        ALUBIT15(X6,NP,NA),
        ALUBIT12(X6,NG,NNA);
    nor #(7,3)
        ALUBIT29(NNS,NS),
        (X13,NCI),
        (X12,NP),
        (XT,CBRK,NP),
        (XG,CBRK,NG),
        (NA,A),
        (NNA,NA),
        (NNB,NB),
        (NB,B);
    nmos #(3,3,7)
        ALUBIT13(NP,X7,NNA),
        ALUBIT8(X6,X3,NNB),
        ALUBIT7(X7,X1,NNB),
        ALUBIT6(X7,X2,NB),
        ALUBIT5(X6,X4,NB);
    rnmos #(5,3,7)
        \$AXNOR-L (NS,VCC,VCC);
endmodule // MOS01
