/******************************************************************
 * NOTICE: The information contained in this file is proprietary  *
 * to Cadence Design Systems and is being made available          *
 * to Cadence customers under strict non-disclosure agreements.   *
 * Use or disclosure of this information is permissible only      *
 * under the terms of the existing non-disclosure agreement.      *
 ******************************************************************/

//description of a MOS static RAM cell
module sram(data_out, address, data_in, write);
    output data_out;
    input address, data_in, write;
    tri w1, w3, w4, w43;
    bufif1
        g1(w1, data_in, write);
    tranif1
        g2(w4, w1, address);
    not
        g3(w3, w4), g43(w43, w3);
    rnmos
        g4(w4, w43, 1);
    buf
        g5(data_out, w1);
endmodule // sram

//waveform for testing the static RAM cell
module wave_sram;
    wire data_out;
    reg address, data_in, write;

    //make the circuit a sub-module and define the
    //waveform-circuit interconnections
    sram cell(data_out, address, data_in, write);

    //define the waveform to drive the circuit
    parameter d = 100;
    initial
        begin
            #d dis;
            #d address = 1;
            #d dis;
            #d data_in = 1;
            #d dis;
            #d write = 1;
            #d dis;
            #d write = 0;
            #d dis;
            #d write = 'bx;
            #d dis;
            #d address = 'bx;
            #d dis;
            #d address = 1;
            #d dis;
            #d write = 0;
            #d dis;
        end

    //display the circuit state
    task dis;
        $display($time,,
            "address=%b data_in=%b write=%b   data_out=%b",
                address, data_in, write, data_out,
            "    w134=",
                cell.w1, cell.w3, cell.w4);
    endtask
endmodule // wave_sram
