module andLib(out, a, b);
output out;
input a, b;
parameter daR = 0.0,
	  daF = 0.0,
	  dbR = 0.0,
	  dbF = 0.0;

   and u1(out, a, b);

   specify
      (a => out) = (0.0,0.0);
      (b => out) = (0.0,0.0);
   endspecify

   initial 
     begin
        $initDelay(a, out, daR, daF);
        $initDelay(b, out, dbR, dbF);
     end
endmodule
module andLib2(out, a, b);
output out;
input a, b;
parameter daR = 0.0,
	  daF = 0.0;

   and u1(out, a, b);

   specify
      (a,b => out) = (0.0,0.0);
   endspecify

   initial 
     begin
        $initDelay(a, out, daR, daF);
     end
endmodule

module bufLib(out, in);
output out;
input in;
parameter daR = 0.0,
	  daF = 0.0;

   buf u1(out, in);
   
   specify
      (in => out) = (0.0, 0.0);
   endspecify
   initial
      $initDelay(in, out, daR, daF);
endmodule

module test;

reg a, b;

   bufLib  #(6,6)                     u1(outB, a);
   andLib  #(10,10,11:12:13,15:16:17) u2(outA, a, b);
   andLib2 #(7,9)                     u3(outA2, a, b);
   initial
      $monitor($time,,a,b,,outB,outA,outA2);
      
   initial
     begin
        
            a = 0;
	    b = 0;
	#5  a = 1;
	#10 a = 0;
	#20 a = 1;
	#5  b = 1;
	
	#100 $stop;
	
     end
endmodule     


