# example contents of active_times.ctl
# Lines beginning with  '#' are comments

# Start monitoring at sim time 1000 (defaults to 0) the first window begins
# at simulation time startTime or when specified to sync with clockHi or clockLo
# at the first such sync event after startTime.
startTime: 1000

# Filename of signal names (1 name  per line i.e. top.m2.net3 ) to monitor
netsFile:  nets.lst

# Restart window time to zero at least every 400 time units
windowLength: 400

# Monitor for 40 window cycles (default no limit i.e. until $finish)
numWindows: 40

# Reset the window time = 0 when sclock goes low

clockLo: top.sclock

# Reset the window time = 0 when sclock goes low
clockHi: top.cclock

#  Only resolve time within a window into 100 slots (default resolves to 1 unit)
#  Window length 400 divided by 100 slots resolves to 10 time units
#  I.e active times will only be resolved to ranges 0-9  or 10-19 ... 390-399
slotsPerWindow: 40

# Extend the simulated change time by -1 through +2 time unit change uncertainty
# with slot resolution as 10 unit ranges (windowLength/slotsPerWindow), 
# some change events will be reported active through 2 slots = 20 time units
timeMinus: 0
timePlus: 2

# To have a windowLength of slotting be offset slightly from a clockHi or 
# clockLo edge  clockOffset (defaults to 0) can be specified
clockOffset: 6
#     This will shift the window slots time ranges by six to  6-15 ... 396-405 
#     where events within
#     6 time units of the clock are considered late events from the previous
#     window 0...5 map to 400...405 in the 396-405 output slot time resolution.


