primitive dff(q,clk,d);
input clk, d;
output q;
reg q;

   table
   //  clk   d  :  q  :  q+
        r    0  :  ?  :  0;
        r    1  :  ?  :  1;
        f    ?  :  ?  :  -;
        ?    *  :  ?  :  -;
   endtable
endprimitive


// D flip-flop lumped delay timing model
`celldefine
module dflop(q,qb,clk,d);
input clk, d;
output q, qb;

   dff g1(qi,clk,d);
   buf #102 g2(q,qi);
   not #156 g3(qb,qi);
endmodule
`endcelldefine


// 2x1 multiplexer lumped delay timing model
`celldefine
module mux21(y,i1,i2,sel);
input i1, i2, sel;
output y;

   bufif0 #56 g1(y,i1,sel);
   bufif1 #72 g2(y,i2,sel);
endmodule
`endcelldefine


module rmux221(q,qb,da,db,select,clk);
input select, clk;
input [1:0] da, db;
output [1:0] q, qb;

   mux21 m1(dm1,da[0],db[0],select);
   mux21 m2(dm2,da[1],db[1],select);
   dflop m3(q[0],qb[0],clk,dm1);
   dflop m4(q[1],qb[1],clk,dm2);
endmodule


module top;

reg clk, select;
reg [1:0] da, db;
wire [1:0] q, qb;

   rmux221 m1(q,qb,da,db,select,clk);

   // calculate delays
   initial
      $ba_delays("test_inp.del");

   // monitor
   initial
      $monitor($time,,"clk=%b  sel=%b  da=%b  db=%b  q=%b  qb=%b",
                                                        clk,select,da,db,q,qb);

   // clock
   initial
   begin 
      clk = 0;
      forever
         #200 clk = ~clk;
   end

   initial
   begin
      // test clocking through 'da'
      $display("test clocking through 'da'");
      da = 0;
      select = 0;
      repeat(3) 
         @(negedge clk) da = da + 1;

      @(negedge clk);

      // test clocking through 'db'
      $display("\ntest clocking through 'db'");
      db = 0;
      select = 1;
      repeat(3)
         @(negedge clk) db = db + 1;

      @(negedge clk)
         $finish;
   end 
endmodule

