/*
	bignum.c -- bignum library
*/
#include	<stdio.h>
#include	<ctype.h>

#include	"veriuser.h"

#include	"common.h"

static int 	cmp PROTO_PARAMS((unsigned *p, unsigned *q, SIZE_T n));

#define		max(a, b)	(((a) > (b))?(a):(b))

static int cmp(p, q, n)
unsigned *p, *q;
SIZE_T n;
{
	if (n == 0)
		return (0);	/* always equal */
	else
		--n;	/* compansation */
	while (n--) {
		if (*p != *q)
			break;
		else {
			p++;
			q++;
		}
	}
	return ((*p == *q)?(0):(*p > *q)?(1):(-1));
}

int bn_cmp(a, b)	/* (a == b)?0:(a > b)?1:-1 */
_bignum *a, *b;
{
        int  result;
        SIZE_T nword;
	SIZE_T bytes;

	if (a->nword == b->nword) {	/* diffrent size */
		result = cmp(a->value, b->value, a->nword);
	} else {
		unsigned *p, *q;

		nword = max(a->nword, b->nword);
		bytes = nword * sizeof(unsigned);
		p = (unsigned *)xalloc(bytes);
		q = (unsigned *)xalloc(bytes);
		ucopy(a->value, &p[nword - a->nword], a->nword);
		ucopy(b->value, &q[nword - b->nword], b->nword);
		result = cmp(p, q, nword);
		free(p);
		free(q);
	}
	return (result);
}

static unsigned umask[] = {
0x00000001, 0x00000002, 0x00000004, 0x00000008,
0x00000010, 0x00000020, 0x00000040, 0x00000080,
0x00000100, 0x00000200, 0x00000400, 0x00000800,
0x00001000, 0x00002000, 0x00004000, 0x00008000,
0x00010000, 0x00020000, 0x00040000, 0x00080000,
0x00100000, 0x00200000, 0x00400000, 0x00800000,
0x01000000, 0x02000000, 0x04000000, 0x08000000,
0x10000000, 0x20000000, 0x40000000, 0x80000000};

int bn_incr(a)
_bignum *a;
{
	SIZE_T i;
        long w;
        
	for (w = a->nword - 1; w >= 0; w--) {
		for (i = 0; i < sizeof(unsigned) * 8; i++) {
			if ((a->value[w] & umask[i]) == 0) {
				a->value[w] ^= umask[i];
				goto end;
			} else {
				a->value[w] ^= umask[i];
			}
		}
	}
	return (1);	/* overflow */
end:
	/* normal end */
	return (0);
}

int bn_decr(a)
_bignum *a;
{
	SIZE_T i;
        long w;

	for (w = a->nword - 1; w >= 0; w--) {
		for (i = 0; i < sizeof(unsigned) * 8; i++) {
			if (a->value[w] & umask[i]) {
				a->value[w] ^= umask[i];
				goto end;
			} else {
				a->value[w] ^= umask[i];
			}
		}
	}
	return (1);	/* underflow */
end:
	/* normal end */
	return (0);
}

int bn_printh(a, func)
_bignum *a;
int (*func)();
{
	long w;

	for (w = 0; w < a->nword; w++)
		func("%08x", a->value[w]);
	func("\n");

        return 0;
}

/*
	bn_dup() duplicate _bignum into new space, and return it.
*/
_bignum *bn_dup(a)
_bignum *a;
{
	_bignum *b;

	b = talloc(_bignum);
	b->nword = a->nword;
	b->bit_width = a->bit_width;
	b->value = usave(a->value, a->nword);
	return (b);
}

/*
	bn_new() allocate new _bignum.
*/
_bignum *bn_new(n)
SIZE_T n;
{
	_bignum *a;

	a = talloc(_bignum);
	a->nword = n;
	a->value = unew(n);
	return (a);
}

/*
	bn_copy() copies _bignum structure and expand its value
		to lager one.
*/
_bignum *bn_copy(s, d)
_bignum *s, *d;
{
	if (d->nword >= s->nword) {
		/* enough space to be copied */
		ucopy(s->value, d->value, s->nword);
	} else {
		/* should be allocated new space */
		free(d->value);
		d->value = usave(s->value, s->nword);
	}
	d->nword = s->nword;
	d->bit_width = s->bit_width;
	return (d);
}

_bignum *bn_expr_to_bignum(ip)
s_tfexprinfo *ip;
{
	static _bignum num;
	static unsigned value[PIG];
	int ngroups = ip->expr_ngroups;
	int i;

	num.value = value;
	if (ngroups > PIG) {
		num.nword = 0;
		tf_error("Too wide data/address.");
		tf_dofinish();
	} else {
		int n;
		num.nword = ngroups;
		n = ngroups - 1;
		i = 0;
		while (ngroups--) {
			/* note that different word (int) order */
			value[i] = ip->expr_value_p[n - i].avalbits;
			i++;
		}
		num.bit_width = ip->expr_vec_size;
	}
	return (&num);
}

_bignum *bn_strh_to_bignum(p)
char *p;
{
	static _bignum num;
	static unsigned value[PIG];
	unsigned word;
	int nchar, nword, w, i;
	char *q;

	num.value = value;
	nchar = (int)strlen(p);
	if (nchar == 0) {
		num.nword = 0;
		num.bit_width = 0;
	} else {
		num.nword = (nchar - 1) / (sizeof(unsigned) * 2) + 1;
		num.bit_width = nchar * 4;	/* 1 nibble is 4 bit long */
		q = &(p[nchar - 1]);
		for (w = num.nword - 1; w >= 0; w--) {
			word = 0;
			for (i = 0; i < sizeof(unsigned) * 2; i++) {
				if (p > q)
					break;	/* reached to top of string */
				else {
					word += htoi(*q) << (4 * i);
					q--;
				}
			}
			num.value[w] = word;
		}
	}
	return (&num);
}
