/*
	common.h -- very common part
*/

#define	IDSIZE		4096	/* Identifier maximum length */
#define	WORDSIZE	(sizeof(int) * 8)	/* bit width of natural word */
#define	PIG			128

#define	talloc(type)	(type *)(xalloc(sizeof(type)))
#define	REG		register

#define	DIR_INCR	1
#define	DIR_DECR	-1

#if defined(__STDC__) || defined(__cplusplus)
#include <stddef.h>
#include <stdlib.h>
typedef size_t SIZE_T;

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) params
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN
#define DEFINED_EXTERN
#endif

#else

typedef unsigned long SIZE_T;
extern	char *calloc();
extern	char *index();

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) (/* nothing */)
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN extern
#define DEFINED_EXTERN
#endif

#endif

#include <string.h>

typedef struct _bignum {
	int nword;
	int bit_width;
	unsigned *value;	/* Big endian order */
} _bignum;

typedef struct _mem_word {
	_bignum adrs;
	unsigned *value;
	struct _mem_word *next;
} _mem_word;

typedef struct _mem_desc {
	char *id;	/* unique identifier */
	unsigned bit_width;
	unsigned ngroups;
	_bignum *adrs_from_bound, *adrs_to_bound;
	_mem_word **hash_p;
	struct _mem_desc *next;
} _mem_desc;

/* bignum.c */
EXTERN int 	bn_cmp PROTO_PARAMS((_bignum *a, _bignum *b));
EXTERN int 	bn_incr PROTO_PARAMS((_bignum *a));
EXTERN int 	bn_decr PROTO_PARAMS((_bignum *a));
EXTERN int 	bn_printh PROTO_PARAMS((_bignum *a, int (*func)()));
EXTERN _bignum *	bn_dup PROTO_PARAMS((_bignum *a));
EXTERN _bignum *	bn_new PROTO_PARAMS((SIZE_T n));
EXTERN _bignum *	bn_copy PROTO_PARAMS((_bignum *s, _bignum *d));
EXTERN _bignum *	bn_expr_to_bignum PROTO_PARAMS((s_tfexprinfo *ip));
EXTERN _bignum *	bn_strh_to_bignum PROTO_PARAMS((char *p));

/* daram.c */
EXTERN int 	damem_declare_checktf PROTO_PARAMS((void));
EXTERN int 	damem_declare PROTO_PARAMS((void));
EXTERN int 	damem_read_checktf PROTO_PARAMS((void));
EXTERN int 	damem_read PROTO_PARAMS((void));
EXTERN int 	damem_write_checktf PROTO_PARAMS((void));
EXTERN int 	damem_write PROTO_PARAMS((void));
EXTERN _mem_desc *	mem_desc_find PROTO_PARAMS((char *name));
EXTERN _mem_word *	mem_word_find PROTO_PARAMS((_mem_desc *mdp, _bignum *adrs));
EXTERN _mem_word *	mem_word_enter PROTO_PARAMS((_mem_desc *mdp, _bignum *adrs, unsigned *value));
EXTERN _mem_desc *	mem_desc_alloc PROTO_PARAMS((int IDpos));
EXTERN char *	make_fullname PROTO_PARAMS((s_tfexprinfo *ip));
EXTERN int 	damem_test_checktf PROTO_PARAMS((void));
EXTERN int 	damem_test PROTO_PARAMS((void));

/* etc.c */
EXTERN char *	xalloc PROTO_PARAMS((SIZE_T n));
EXTERN char *	strsave PROTO_PARAMS((char *p));
EXTERN unsigned *	usave PROTO_PARAMS((unsigned *p, SIZE_T n));
EXTERN unsigned *	ucopy PROTO_PARAMS((unsigned *s, unsigned *d, SIZE_T n));
EXTERN unsigned *	unew PROTO_PARAMS((SIZE_T n));
EXTERN int 	htoi PROTO_PARAMS((int ch));

/* initram.c */
EXTERN int 	damem_initb_checktf PROTO_PARAMS((void));
EXTERN int 	damem_initb PROTO_PARAMS((void));
EXTERN int 	damem_inith_checktf PROTO_PARAMS((void));
EXTERN int 	damem_inith PROTO_PARAMS((void));

/* mvl.c */
EXTERN s_tfexprinfo *	mvl_strh_to_mvl PROTO_PARAMS((char *p, int bits));
EXTERN s_tfexprinfo *	mvl_strb_to_mvl PROTO_PARAMS((char *p, int bits));
EXTERN int 	mvl_printh PROTO_PARAMS((s_tfexprinfo *info, int (*func)()));

/* version.c */
