/*
	daram.c -- dynamic allocated RAM implementation part
*/

#include	<stdio.h>
#include	"veriuser.h"

#include	"common.h"

static unsigned 	mem_desc_hash PROTO_PARAMS((char *name));
static _mem_desc *	mem_desc_enter PROTO_PARAMS((char *name, s_tfexprinfo *ip));
static unsigned 	mem_word_hash PROTO_PARAMS((_bignum *p));
static void 	fillX PROTO_PARAMS((unsigned *p, int n));
static int 	expr_to_int PROTO_PARAMS((s_tfexprinfo *ip));
static int 	anyAmbiguous PROTO_PARAMS((s_tfexprinfo *ip));
static void 	copy_value PROTO_PARAMS((unsigned *s, unsigned *d, int n));

#define	HASHSIZE	10007

static _mem_desc *hash_tbl[HASHSIZE];
static int first_call = 1;

int debug = 0;

_mem_desc *mem_desc_alloc();
_mem_desc *mem_desc_find(), *mem_desc_enter();
_mem_word *mem_word_find(), *mem_word_enter();
char *make_fullname();

int damem_declare_checktf()
{
	extern char damem_version[];

	/* $damem_declare("mem99", 0, 63, 0, 'h100); */

	int type, anyerr = 0;
#ifdef DEBUG
	io_printf("damem_declare_checktf() here.\n");
#endif

	if (first_call) {
		first_call = 0;
		io_printf("%s\n", damem_version);
	}
	if (mc_scan_plusargs("+debug"))
		debug = 1;
	if (tf_typep(1) != tf_string)
		anyerr = 1;
	if ((type = tf_typep(2)) != tf_readonly && type != tf_readwrite)
		anyerr = 1;
	if ((type = tf_typep(3)) != tf_readonly && type != tf_readwrite)
		anyerr = 1;
	if ((type = tf_typep(4)) != tf_readonly && type != tf_readwrite)
		anyerr = 1;
	if ((type = tf_typep(5)) != tf_readonly && type != tf_readwrite)
		anyerr = 1;
	if (anyerr) {
		tf_error("illegal arguments for $damem_declare user task");
	} else {
		_mem_desc *mdp;
		s_tfexprinfo info;
		int bit1, bit2, bits;

		/* convert expr_value format to int */
		tf_exprinfo(2, &info);
		bit1 = expr_to_int(&info);
		tf_exprinfo(3, &info);
		bit2 = expr_to_int(&info);

		mdp = mem_desc_alloc(1);
		bits = mdp->bit_width = (bit1 > bit2)?(bit1 - bit2 + 1):(bit2 - bit1 + 1);
		mdp->ngroups = (bits - 1) / WORDSIZE + 1;
		mdp->hash_p = (_mem_word **)xalloc(sizeof(_mem_word *) * HASHSIZE);

		/* convert expr_value format to bignum */
		tf_exprinfo(4, &info);
		mdp->adrs_from_bound = bn_dup(bn_expr_to_bignum(&info));
		tf_exprinfo(5, &info);
		mdp->adrs_to_bound = bn_dup(bn_expr_to_bignum(&info));
#if 0
/* for test of bignum staff */
		{
			_bignum *p;
			s_tfexprinfo *ip;

			tf_exprinfo(6, &info);
			io_printf("%s\n", info.expr_string);
/*
			p = bn_strh_to_bignum(info.expr_string);
*/
			ip = mvl_strh_to_mvl(info.expr_string, 0);
			p = bn_expr_to_bignum(ip);

			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
			bn_decr(p);
			bn_printh(p, io_printf);
			bn_decr(p);
			bn_printh(p, io_printf);
			bn_decr(p);
			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
			mvl_printh(ip, io_printf);
		}
		{
			_bignum *p;
			s_tfexprinfo *ip;

			tf_exprinfo(7, &info);
			io_printf("%s\n", info.expr_string);

			ip = mvl_strb_to_mvl(info.expr_string, 0);
			mvl_printh(ip, io_printf);

			p = bn_expr_to_bignum(ip);

			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
			bn_decr(p);
			bn_printh(p, io_printf);
			bn_decr(p);
			bn_printh(p, io_printf);
			bn_decr(p);
			bn_printh(p, io_printf);
			bn_incr(p);
			bn_printh(p, io_printf);
		}
/*-----------------*/
#endif
	}
        return 0;
}

int damem_declare()
{
	int type;
	
#ifdef DEBUG
	io_printf("damem_declare() here.\n");
#endif
	type = tf_typep(1);
	{
		s_tfexprinfo info, *ip = &info;
		unsigned n, *p;
		tf_exprinfo(1, ip);
		n = ip->expr_ngroups;
		p = (unsigned *)ip->expr_value_p;
		while (n--) {
			io_printf("%08x ", *p);
			p++;
			io_printf("%08x ", *p);
			p++;
		}
	}
	/*
		nothing to do.
	*/
        return 0;
}

int damem_read_checktf()
{
	/*
		reg [7:0] data;
		$damem_read("mem99", 10, data);
	*/
	int type, anyerr = 0;

#ifdef DEBUG
	io_printf("damem_read_checktf() here.\n");
#endif

	if (tf_typep(1) != tf_string)
		anyerr = 1;
	if ((type = tf_typep(2)) != tf_readonly && type != tf_readwrite)
		anyerr = 1;
	if (tf_typep(3) != tf_readwrite)
		anyerr = 1;
	if (anyerr)
		tf_error("illegal arguments for $damem_read user task");
	
        return 0;
}

int damem_read()
{
	char *id;
	s_tfexprinfo info, *ip = &info;
	_mem_desc *mdp;
	_mem_word *mwp;
	_bignum *adrs;

#ifdef DEBUG
	io_printf("damem_read() here.\n");
#endif

	tf_exprinfo(1, ip);	/* ID */
	id = make_fullname(ip);
	if ((mdp = mem_desc_find(id)) == NULL) {
		tf_error("damem_read(): Not found memory ID '%s' in this scope.\n", id);
		exit(1);
	}
	tf_exprinfo(2, ip);	/* address */
	if (anyAmbiguous(ip)) {
		/* address is ambiguous (includes 'X', 'Z') */
		tf_exprinfo(3, ip);	/* data */
		/* return all 'X' */
		fillX((unsigned *)(ip->expr_value_p), ip->expr_ngroups);
		if (debug)
			io_printf("damem_read write back %08x\n", *(unsigned *)(ip->expr_value_p));
	} else {
		adrs = bn_expr_to_bignum(ip);
		tf_exprinfo(3, ip);	/* data */
		if ((mwp = mem_word_find(mdp, adrs)) == NULL) {
			/* not yet initialized */
			fillX((unsigned *)(ip->expr_value_p), ip->expr_ngroups);
			if (debug)
				io_printf("damem_read write back %08x\n", 
					*(unsigned *)(ip->expr_value_p));
		} else {
			/* write back value */
			copy_value(mwp->value, (unsigned *)(ip->expr_value_p),
                                   ip->expr_ngroups);
			if (debug)
				io_printf("damem_read write back %08x\n", 
					*(unsigned *)(ip->expr_value_p));
		}
	}
#if 0
	tf_exprinfo(3, ip);	/* data */
	*((unsigned *)ip->expr_value_p) = 0x5a;
	*((unsigned *)ip->expr_value_p + 1) = 0x00;
#endif

	tf_propagatep(3);

        return 0;
}
	
int damem_write_checktf()
{
	/*
		$damem_write("mem99", 4, 16'h55aa);
	*/
	int type, anyerr = 0;
#ifdef DEBUG
	io_printf("damem_write_checktf() here.\n");
#endif

	if (tf_typep(1) != tf_string)
		anyerr = 1;
	if ((type = tf_typep(2)) != tf_readonly && type != tf_readwrite)
		anyerr = 1;
	if ((type = tf_typep(3)) != tf_readonly && type != tf_readwrite)
		anyerr = 1;
	if (anyerr)
		tf_error("illegal arguments for $damem_write user task");

        return 0;
}

int damem_write()
{
	char *id;
	s_tfexprinfo info, *ip = &info;
	_mem_desc *mdp;
	_mem_word *mwp;
	unsigned *value;
	_bignum *adrs;

#ifdef DEBUG
	io_printf("damem_write() here.\n");
#endif

	tf_exprinfo(1, ip);	/* ID */
	id = make_fullname(ip);
	if ((mdp = mem_desc_find(id)) == NULL) {
		tf_error("damem_write(): Not found memory ID '%s' in this scope.\n", id);
		exit(1);
	}
	tf_exprinfo(2, ip);	/* address */
	if (anyAmbiguous(ip)) {
		/* address is ambiguous (includes 'X', 'Z') */

		/* nothing to do. */

		/* But I think all entry (contents of RAM)
			should be 'X' when this condition met */

	} else {
		adrs = bn_expr_to_bignum(ip);
		tf_exprinfo(3, ip);	/* data */
		if ((mwp = mem_word_find(mdp, adrs)) == NULL) {
			mem_word_enter(mdp, adrs, (unsigned *)(ip->expr_value_p));
		} else {
			/* overwrite */
			copy_value((unsigned *)(ip->expr_value_p), mwp->value, ip->expr_ngroups);
		}
	}

        return 0;
}

/*
	mem_desc staff
*/
static unsigned mem_desc_hash(name)
char *name;
{
	unsigned n = 0;
	while (*name) {
		n *= 65599;
		n += *name++;
	}
	return (n % HASHSIZE);
}

_mem_desc *mem_desc_find(name)
char *name;
{
	unsigned mem_desc_hash();
	_mem_desc *mdp;

	mdp = hash_tbl[mem_desc_hash(name)];
	while (mdp != NULL)
		if (strcmp(mdp->id, name) == 0)
			break;
		else
			mdp = mdp->next;
	return (mdp);
}

static _mem_desc *mem_desc_enter(name, ip)
char *name;
s_tfexprinfo *ip;
{
	char *strsave();
	_mem_desc *mdp;

	unsigned n = mem_desc_hash(name);
	mdp = talloc(_mem_desc);
	mdp->id = strsave(name);
	mdp->next = NULL;

	if (hash_tbl[n] == NULL)
		hash_tbl[n] = mdp;
	else {
		_mem_desc *p = hash_tbl[n];
		mdp->next = hash_tbl[n];	/* insert to head of list */
		hash_tbl[n] = mdp;
	}
	return (mdp);
}

/*
	mem_word staff
*/

static unsigned mem_word_hash(p)
_bignum *p;
{
	unsigned n = 0, *q = p->value;
	int nint = p->nword;

	while (nint--) {
		n <<= 5;
		n ^= *q++;
	}
	return (n % HASHSIZE);
}

_mem_word *mem_word_find(mdp, adrs)	
_mem_desc *mdp;
_bignum *adrs;
{
	unsigned mem_word_hash();
	unsigned n;
	_mem_word *mwp;

	n = mem_word_hash(adrs);
	mwp = mdp->hash_p[n];
	while (mwp != NULL)
		if (bn_cmp(adrs, &mwp->adrs) == 0)
			break;
		else
			mwp = mwp->next;
	return (mwp);
}

static void fillX(p, n)
unsigned *p;
int n;
{
	n *= 2;	/* for avalbits and bvalbits */
	while (n--)
		*p++ = 0xffffffff;	/* it means 'X' */
}

_mem_word *mem_word_enter(mdp, adrs, value)
_mem_desc *mdp;
_bignum *adrs;
unsigned *value;
{
	unsigned n = mem_word_hash(adrs);
	_mem_word *mwp;

	if ((mwp = mem_word_find(mdp, adrs)) == NULL) {
		/* first write to this word */
		int bytes;
		bytes = adrs->nword * sizeof(unsigned);
		mwp = talloc(_mem_word);
		mwp->adrs.nword = adrs->nword;
		mwp->adrs.value = (unsigned *)xalloc(bytes);
		bcopy(adrs->value, mwp->adrs.value, bytes);
		mwp->value = (unsigned *)xalloc(mdp->ngroups * 2 * sizeof(unsigned));

		/* copy value */
		copy_value(value, mwp->value, mdp->ngroups);

		if (mdp->hash_p[n] == NULL) {
			mdp->hash_p[n] = mwp;
		} else {
			mwp->next = mdp->hash_p[n];
			mdp->hash_p[n] = mwp;
		}
	} else {
		/* overwrite value */
		copy_value(value, mwp->value, mdp->ngroups);
	}
	return (mwp);
}

_mem_desc *mem_desc_alloc(IDpos)
int IDpos;
{
	s_tfexprinfo info;
	_mem_desc *mdp;
	char *name;

	tf_exprinfo(IDpos, &info);
	name = make_fullname(&info);
	if ((mdp = mem_desc_find(name)) == NULL)
		mdp = mem_desc_enter(name, &info);
	return (mdp);
}

static int expr_to_int(ip)
s_tfexprinfo *ip;
{
	if (ip->expr_ngroups > 1) {
		tf_error("illegal arguments for $damem_declare user task");
		return (-1);
	} else {
		return (ip->expr_value_p->avalbits);
	}
}

static int anyAmbiguous(ip)
s_tfexprinfo *ip;
{
	s_vecval *p = ip->expr_value_p;
	int ng = ip->expr_ngroups;

	while (ng--)
		if (p->bvalbits)
			return (1);
		else
			p++;
	return (0);
}

static void copy_value(s, d, n)
unsigned *s, *d;
int n;
{
	n *= 2;
	while (n--)
		*d++ = *s++;
}

char *make_fullname(ip)
s_tfexprinfo *ip;
{
	static char tmp[IDSIZE];

	strcat(strcat(strcpy(tmp, tf_mipname()), "."), ip->expr_string);
	return (tmp);
}

/*
	debug staff
*/

int damem_test_checktf()
{
	return (0);
}

int damem_test()
{
	char *id;
	s_tfexprinfo info, *ip = &info;
	s_tfexprinfo *ip2;
	_mem_desc *mdp;
	_mem_word *mwp;
	_bignum *adrs;

	tf_exprinfo(1, ip);	/* ID */
	id = make_fullname(ip);
	mdp = mem_desc_find(id);
	tf_exprinfo(2, ip);	/* address */

/*	adrs = bn_expr_to_bignum(mvl_strh_to_mvl(ip->expr_string), 0); */
	adrs = bn_expr_to_bignum(mvl_strh_to_mvl(ip->expr_string, 0));
	tf_exprinfo(3, ip);	/* data */
	ip2 = mvl_strh_to_mvl(ip->expr_string, 0);
	mem_word_enter(mdp, adrs, (unsigned *)(ip2->expr_value_p));
#if 0
	tf_exprinfo(3, ip);	/* data */
	*((unsigned *)ip->expr_value_p) = 0x5a;
	*((unsigned *)ip->expr_value_p + 1) = 0x00;
#endif
        return 0;
}
	
