/*
	mvl.c -- multi valued logic support.
*/
#include	<stdio.h>
#include	<ctype.h>

#include	"veriuser.h"

#include	"common.h"

static unsigned 	mvl_h_toaval PROTO_PARAMS((int ch));
static unsigned 	mvl_h_tobval PROTO_PARAMS((int ch));
static unsigned 	mvl_b_toaval PROTO_PARAMS((int ch));
static unsigned 	mvl_b_tobval PROTO_PARAMS((int ch));

#define		max(a, b)	(((a) > (b))?(a):(b))

/*
	MVL coding scheme

	ab = 00 : 0
		 10 : 1
		 11 : X
		 01 : Z
*/
static unsigned mvl_h_toaval(ch)
char ch;
{
	unsigned val = 0;

	ch = isupper(ch) ? tolower(ch) : ch;
	if (ch == 'x') {
		return (0xf);
	} else if (ch == 'z') {
		return (0);
	} else if (isxdigit(ch)) {
		return (htoi(ch));
	} else {	/* illegal string */
		return (0xf);
	}
}

static unsigned mvl_h_tobval(ch)
char ch;
{
	unsigned val = 0;

	ch = isupper(ch) ? tolower(ch) : ch;
	if (ch == 'x' || ch == 'z') {
		return (0xf);
	} else if (isxdigit(ch)) {
		return (0);
	} else {	/* illegal string */
		return (0xf);
	}
}

static unsigned mvl_b_toaval(ch)
char ch;
{
	ch = isupper(ch) ? tolower(ch) : ch;
	if (ch == '1' || ch == 'x')
		return (1);
	else if (ch == '0' || ch == 'z')
		return (0);
	else
		return (1);	/* illegal char */
}

static unsigned mvl_b_tobval(ch)
char ch;
{
	ch = isupper(ch) ? tolower(ch) : ch;
	if (ch == 'x' || ch == 'z')
		return (1);
	else if (ch == '0' || ch == '1')
		return (0);
	else
		return (1);	/* illegal char */
}

s_tfexprinfo *mvl_strh_to_mvl(p, bits)
char *p;
int bits;
{
	static s_tfexprinfo info;
	static s_vecval vector[PIG];
	unsigned aval, bval;
	int nchar, nword, w, i, j;
	int ngroups;
	char *q;

	bzero(vector, PIG);
	info.expr_value_p = vector;
	info.expr_vec_size = bits;
	nchar = strlen(p);
	if (bits == 0) {
		/* not specified (yokini hakarae) */
		info.expr_ngroups = (nchar - 1) / (sizeof(unsigned) * 2) + 1;
		info.expr_vec_size = nchar * 4;
	} else {
		info.expr_ngroups = (bits - 1) / (sizeof(unsigned) * 2) + 1;
		info.expr_vec_size = bits;
	}
	ngroups = (nchar - 1) / (sizeof(unsigned) * 2) + 1;
	q = &(p[nchar - 1]);
	for (w = ngroups - 1, j = 0; w >= 0; w--, j++) {
		aval = bval = 0;
		for (i = 0; i < sizeof(unsigned) * 2; i++) {
			if (p > q)
				break;	/* reached to top of string */
			else {
				aval += mvl_h_toaval(*q) << (4 * i);
				bval += mvl_h_tobval(*q) << (4 * i);
				q--;
			}
		}
		vector[j].avalbits = aval;
		vector[j].bvalbits = bval;
	}
	return (&info);
}

s_tfexprinfo *mvl_strb_to_mvl(p, bits)
char *p;
int bits;
{
	static s_tfexprinfo info;
	static s_vecval vector[PIG];
	unsigned aval, bval;
	int nchar, nword, w, i, j;
	int ngroups;
	char *q;

	bzero(vector, PIG);
	info.expr_value_p = vector;
	info.expr_vec_size = bits;
	nchar = strlen(p);
	if (bits == 0) {
		/* not specified (yokini hakarae) */
		info.expr_ngroups = (nchar - 1) / (sizeof(unsigned) * 8) + 1;
		info.expr_vec_size = nchar;
	} else {
		info.expr_ngroups = (bits - 1) / (sizeof(unsigned) * 8) + 1;
		info.expr_vec_size = bits;
	}
	ngroups = (nchar - 1) / (sizeof(unsigned) * 2) + 1;
	q = &(p[nchar - 1]);
	for (w = ngroups - 1, j = 0; w >= 0; w--, j++) {
		aval = bval = 0;
		for (i = 0; i < sizeof(unsigned) * 8; i++) {
			if (p > q)
				break;	/* reached to top of string */
			else {
				aval += mvl_b_toaval(*q) << i;
				bval += mvl_b_tobval(*q) << i;
				q--;
			}
		}
		vector[j].avalbits = aval;
		vector[j].bvalbits = bval;
	}
	return (&info);
}

int mvl_printh(info, func)
s_tfexprinfo *info;
int (*func)();
{
	int ngroups = info->expr_ngroups;
	int w, n;
	unsigned aval, bval;
	static unsigned nmask[] = {
	0xf0000000, 0x0f000000, 0x00f00000, 0x000f0000,
	0x0000f000, 0x00000f00, 0x000000f0, 0x0000000f};

	if (ngroups == 0)
		return 0;
	for (w = ngroups - 1; w >= 0; w--) {
		aval = info->expr_value_p[w].avalbits;
		bval = info->expr_value_p[w].bvalbits;
		for (n = 0; n < sizeof(unsigned) * 2; n++) {
			unsigned a, b;
			a = (aval & nmask[n]) >> (4 * (sizeof(unsigned) * 2 - 1 - n));
			b = (bval & nmask[n]) >> (4 * (sizeof(unsigned) * 2 - 1 - n));
			a &= 0xf;
			b &= 0xf;
			if (a == 0xf && b == 0xf)
				func("x");
			else if (a == 0 && b == 0xf)
				func("z");
			else if (b != 0) {
				if ((a & b) != 0)
					func("X");	/* any arbitrary 'x' */
				else
					func("Z");	/* all Hi-Z */
			} else {
				func("%c", (a < 10)?(a + '0'):(a + 'a' - 10));
			}
		}
	}
	func("\n");

        return 0;
}
