/* Last Edit: Tue May  7 15:36:32 1991 by rays */
/*
   This file is at the header of all the dtran routines
*/

#define Wire0 0x2
#define Wire1 0x4
#define WireX 0x6
#define WireZ 0x0
#define Wand0 0x7
#define Wand1 0x4
#define WandX 0x5
#define WandZ 0x0
#define Wor0  0x4
#define Wor1  0x7
#define WorX  0x5
#define WorZ  0x0

typedef struct {
  int 
    number_of_a_drivers,
    number_of_b_drivers,
    *a_values,
    *b_values,
    a_nettype,
    b_nettype;
} dtran_inst_info;


typedef struct {
  char *instance;  /* The instance pointer for a dtran */
  int  *value;    /* A pointer to the array member this terminal effects*/
  int  nettype;
} consumer_data;

#if defined(__STDC__) || defined(__cplusplus)
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#endif

#include "veriuser.h"
#include "acc_user.h"
#include <malloc.h>

#if defined(__STDC__) || defined(__cplusplus)

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) params
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN
#define DEFINED_EXTERN
#endif

#else

#ifndef PROTO_PARAMS
#define PROTO_PARAMS(params) (/* nothing */)
#define DEFINED_PROTO_PARAMS
#endif
#ifndef EXTERN
#define EXTERN extern
#define DEFINED_EXTERN
#endif

#endif /* __STDC__ */

/* dtran_calltf.c */
EXTERN int 	dtran_calltf PROTO_PARAMS((void));

/* dtran_checktf.c */
EXTERN int 	dtran_checktf PROTO_PARAMS((void));
EXTERN int 	initialize_array PROTO_PARAMS((int nettype));

/* dtran_consumer.c */
EXTERN void 	dtran_consumer PROTO_PARAMS((p_vc_record change_data));

/* dtran_misctf.c */
EXTERN int 	dtran_misctf PROTO_PARAMS((int data, int reason));
EXTERN void 	handle_value_changes PROTO_PARAMS((void));
EXTERN void 	get_newvalue PROTO_PARAMS((char newvalstr[], int new_value, int nettype));
EXTERN void 	handle_dtran_save PROTO_PARAMS((void));
EXTERN void 	handle_dtran_restore PROTO_PARAMS((void));
