/*
			MODULE DTRAN

This module implements the verilog part of the dtran.  The schematic looks
like this:


             +-------------------------------+
             |delbuf     +-------+           |
             |   abuf  +-| a_reg |           |
             |     /|  | +-------+    |\     |
             +----+ +--+           +--+ +----+
             |     \|              |  |/     |
             |           +-------+ | delbuf  |
             |           | b_reg |-+   bbuf  |
             |           +-------+           |
	     | initial                       |
             |   $delay_transport(a_reg,     |
	     |                    b_reg);    |
             +-------------------------------+

$delay transport monitors the driving terminals and places the correct
values in a_reg and b_reg.  The delbufs accellerate these register and
apply the timing.

See the READ.ME file for details.

*/

module dtran(a,b);
inout a,b;

reg a_reg, b_reg;

delbuf adel (a,a_reg); /* accellerate a_reg and b_reg */
delbuf bdel (b,b_reg);

initial
   $delay_transport(a_reg, b_reg); /* This monitors the driving terminals and
				      does the right thing */

endmodule

/*                       MODULE DELBUF

This module accelerates the input and applies the timing in the specify block.
It can be attached to other specify blocks, and you would do your
backannotation in this module

*/
module delbuf (out, in);
output out;
input in;

nmos (out, in, 1); /* nmos will allow Zs through */

specify
  specparam 
       delay = 0;

  (in *> out) = (delay);

endspecify

endmodule