/* Created:   Tue Dec 18 09:18:28 1990 by rays */
/* Last Edit: Fri May 10 09:47:43 1991 by rays */
#include "dtran.h"

/*
                            DTRAN CONSUMER

PLEASE READ DTRAN_PROGRAM.DOC BEFORE READING THIS DOCUMENTATION

This is the consumer routine for the dtran.  Verilog-XL calls this routine
whenever one of the drivers changes value.  This routine simply gets
the new value of the terminal and stores it in the location pointed
to by the user_data structure.

dtran_checktf created a structure and gave this routine a pointer to
that structure.  That pointer is in the user_data field of the change_data
record.  The structure looks like this:


typedef struct {
  char *instance;  S* The instance pointer for a dtran *S
  int  *value;    S* A pointer to the array member this terminal effects*S
  int  nettype;
} consumer_data;

The consumer routine will do the following:

  1. get new value of the terminal from change_data
  2. find the proper representation for that value based upon the netttype
  3. store that representation in the location pointed to by *value
  4. schedule the misctf routine with tf_isynchronize

dtran_misctf will finish the job by evaluating the net and placing the
new values in a_reg and b_reg.

*/



void dtran_consumer(change_data)
p_vc_record change_data;
  {
    
    consumer_data  *transition_info;

    transition_info = (consumer_data *) change_data -> user_data;

/* this two level switch will find the proper value representation based
   upon the nettype and the new value */

    switch (transition_info -> nettype)
      {
      case accWire:
      case accTri:
	switch (change_data -> out_value.logic_value)
	  {
	  case vcl0:
	    *(transition_info -> value) = Wire0;
	    break;
	  case vcl1:
	    *(transition_info -> value) = Wire1;
	    break;
	  case vclX:
	    *(transition_info -> value) = WireX;
	    break;
	  case vclZ:
	    *(transition_info -> value) = WireZ;
	    break;
	  }
	break;
	
      case accWand:
      case accTriand:
	switch (change_data -> out_value.logic_value)
	  {
	  case vcl0:
	    *(transition_info -> value) = Wand0;
	    break;
	  case vcl1:
	    *(transition_info -> value) = Wand1;
	    break;
	  case vclX:
	    *(transition_info -> value) = WandX;
	    break;
	  case vclZ:
	    *(transition_info -> value) = WireZ;
	    break;
	  }
	break;
      case accWor:
      case accTrior:
	
	switch (change_data -> out_value.logic_value)
	  {
	  case vcl0:
	    *(transition_info -> value) = Wor0;
	    break;
	  case vcl1:
	    *(transition_info -> value) = Wor1;
	    break;
	  case vclX:
	    *(transition_info -> value) = WorX;
	    break;
	  case vclZ:
	    *(transition_info -> value) = WorZ;
	    break;
	  }
      }
    tf_isynchronize(transition_info -> instance);
  }



