/* Created:   Sat Mar 23 16:27:39 1991 by rays */
/* Last Edit: Tue Mar 26 11:49:46 1991 by rays */

/***********************************************************************
                         get_new_value.c

     The routines in this file process tfarg 1.  They handle register values
     UDP values and random values.


This file contains:

   char *get_new_value();
   char *register_value();
   int   udp_value();
   char *random_value();


***********************************************************************/


/***********************************************************************
                          GET NEW VALUE

     This function will return the new value specified by the user in
     tfarg 1.  It will handle all of the 0 padding or truncation needed
     if the register width and argument width are different.  It will
     also handle the "random" string.

     get_new_value takes a handle and returns a string that's appropriate
     to the type of object it is passed.  It only handles UDPs and 
     registers.

***********************************************************************/

#include "set_values.h"

char *get_new_value(item)
     handle
       item;
     
{
  char 
    *register_value(); /* Returns a value string for a register based upon
			  the width of the register.  If tfarg 1 is random
			  then register_value returns a string of random
			  1's and 0's of the correct length. */

  int 
    udp_value(),       /* Returns a scalar value based upon the LSB of the
			  value string in tfarg 1.  If tfarg1 is "random" then
			  udp_value returns acc1 or acc0 in a random fashion */

    msb,   /* The msb of a register.  Used to find the width if item 
	      is a register */
    lsb;   /* The lsb of a register.  Used with the msb to find width */
  
  
  switch (acc_fetch_fulltype(item))
    {
    case accRegister:
      acc_fetch_range(item, &msb, &lsb);      /* Get msb and lsb */
      return  register_value(abs(msb-lsb)+1); /* use msb & lsb to get width */
    case accSeqPrim:
      return  (char *) udp_value(); /* udp_value returns a scalar but
				       get_new_value returns a ptr to a char.
				       Cast it here for consistency */
    }
  
  return NULL;
}

/***********************************************************************
                          UDP VALUE

This routine looks at the lsb of the value string and returns it
as a scalar value.  

Since UDP's cannot output a 'Z', udp_value converts values of 'Z' to accX

***********************************************************************/

int udp_value()
{
  char *value_string,      /* The value string */
       *random_value(); /* This routine returns a random value string
			   of the requested length.  The random value
			   string will only contain 1s and 0s.*/

/* Read the value string */  
  value_string = (strtoupper(acc_fetch_tfarg_str(1)));



  if (!strcmp(value_string, RANDOM_STRING))  /* If the value string is "RANDOM" */
    value_string = random_value(1);          /* replace it with random string
					     of length 1 */
	       
  
  switch (value_string[strlen(value_string)-1]) /* look at the LSB */
    {
    case '0':
      return acc0;
      
    case '1':
      return acc1;
      
    case 'X':
    case 'x':
      return accX;
      
    case 'z':
    case 'Z':
      return accX;    /* Convert Z to accX.  UDPs don't handle Z */
      
    default:
      tf_message(ERR_ERROR, "USER", "XXXX",
                 "Illegal value \"%c\" in udp_value.",
		 value_string[strlen(value_string)-1]);
      
    }

  return 1;
}

/***********************************************************************
                         REGISTER VALUE

This routine will return the value string from tfarg1.  It will also
truncate the value string or pad it, based upon the width of the 
item width.

If the item width is greater than the value string length, then register_value
will pad the msbs of the string with 0s.  

If the item width is less than the value string length, then register_value
will truncate the msbs of the value string.

If the value string calls for a random number, then register_value will
return a random string of the proper width.

***********************************************************************/

char *register_value(item_width)
     int
       item_width; /* The requested length of the string */
     
{
  char 
    *value_string,   /* The value string supplied in tfarg 1 */
    *reg_value,      /* The string of the proper length with 0s added
		        or msbs truncated */
    *random_value(); /* This routine returns a random value string
			   of the requested length.  The random value
			   string will only contain 1s and 0s.*/

  
  
  int
    ctr,              /* A loop counter */
    value_string_len; /* The length of the value string */
  
  value_string = strtoupper(acc_fetch_tfarg_str(VALUE_TFARG_NUMB));
  value_string_len = strlen(value_string);
  
  if (!strcmp(value_string, RANDOM_STRING)) /* if they want a random value */
    return random_value (item_width); /* return one */
  else
    {
      reg_value = malloc (item_width+1);
      
      if (value_string_len == item_width)          /* The simple case. The */
	return (strcpy(reg_value, value_string)); /* lengths are the same */
      
      if (value_string_len > item_width) /* Must truncate string */
	{
          /* Start at LSB */
	  value_string = value_string + (strlen(value_string) - 1);  
	  reg_value = reg_value + item_width;
	  *(reg_value--) = '\0';    /* Make the end of the return string */
	  ctr = 1;
	  while (ctr <= item_width) /* copy the value string from the lsb */
	    {
	      *(reg_value--) = *(value_string--);
	      ctr++;
	    }
	  return ++reg_value;
	}
      

      if (value_string_len < item_width)   /* Must pad 0s to MSBs */
	{
	  for (ctr = 0; ctr < (item_width - value_string_len); ctr++)
	    reg_value[ctr] = '0';               /* First put 0s in string */
	  strcpy (reg_value+ctr, value_string); /* Then copy value string */
	  return reg_value;
	}
    }

  return NULL;
}

/***********************************************************************
                           RANDOM VALUE

  This routine will return a random string of the proper length.  It generates
the string by "flipping a coin" for each bit and placing a 1 or 0 depending
upon the result 
***********************************************************************/

char *random_value (length)
     int length;  /* The requested length of the random string */
{
  int 
    ptr,       /* An array index into the random string */
    rand();    /* Returns a random number between 1 and MY_RAND_MAX */  
  char *value;   /* The string that will be returned */
  
  value = malloc(length+1);   /* Get enough memory for the result */
  for (ptr = 0; ptr < length; ptr++)  /* Go through each bit */
    if ( ( ((double) myrand()) / MY_RAND_MAX ) < 0.5) /* Flip a coin */
      value[ptr] = '0';    /* Heads --  put in a 0 */
    else
      value[ptr] = '1';    /* Tails --  put in a 1 */

  value[ptr] = '\0';   /* Terminate the string */

  return value;
}
