/* Created:   Mon Feb 25 11:55:35 1991 by rays */
/* Last Edit: Tue Mar 26 13:49:50 1991 by rays */

#include "set_values.h"

/************************************************************************

                        SET VALUES CALLTF
  
  This routine implements the calltf function of $set_values.  It works by
  examining each argument and deciding how to handle the argument.  There
  are four kinds of arguments:
  
  1.  Register  - If there is a register data type on the command line, then
  set_values_calltf will stuff it with the new value from tfarg 1.
  
  2.  Sequential UDP - If there is a sequential UDP then set_values_calltf
  will stuff it with the LSB of the new value.
  
  3.  Memories -  If there is a memory then this routine will fill the memory
  with the new value. 
  
  4.  Modules  -  If there is a module instance in the tfarg list then 
  this routine will look for a selection string.   The 
  selection string tells us whether we should stuff registers,
  sequential udps, or both.  If there is no string, then we
  assume that we want to stuff both.
  
  $set_values will traverse the hierarchy at and below
  the module instance and replace the values in the
  elements identified by the selection string.
  
***********************************************************************/


int set_values_calltf()
{
  
  handle 
    tfarg;
  int 
    tfarg_numb = FIRST_STORAGE_TFARG, /* The tfarg that we are looking at */
    number_of_tfargs = tf_nump();     /* The total number of tfargs */
  
  
  void
    stuff_memory(),    /* Places new values in memories */
    stuff_register(),  /* Places new values in registers */
    stuff_udp(),       /* Places new values in UDPs */
    stuff_module();    /* Places new values in regs or UDPs in an hierarchy */
  
  bool tfarg_is_a_memory(); /* Checks to see if the tfarg is a memory */
  
  acc_initialize();
#if 0
  acc_configure(accDevelopmentVersion, "1.6");
#endif
  while (tfarg_numb <= number_of_tfargs)
    {
      if (tfarg_is_a_memory(tfarg_numb)) /* Is this argument a memory? */
	stuff_memory(tfarg_numb);        
      else                               /* no */
	{ 
	  tfarg = acc_handle_tfarg(tfarg_numb);
	  
	  switch (acc_fetch_fulltype(tfarg)) /* What kind of an argument it */
	    {
	    case accRegister:
	      stuff_register(tfarg);
	      break;
	    case accSeqPrim: 
	      stuff_udp(tfarg);
	      break;
	    case accModuleInstance:
	      stuff_module(tfarg,&tfarg_numb); /* This routine may increment
		                                  tfarg_numb */
	      break;
	    default:
	      tf_message(ERR_WARNING, "Verilog", "BADARG", 
			 "Argument %d is bad in $set_values call", tfarg_numb,
			 "Not supported by set_values switch");
	    }
	}
      tfarg_numb++; /* Handle the next tfarg */
    }
  acc_close();

  return 0;
}
  


  
  




