/* Last Edit: Tue Mar 26 11:55:31 1991 by rays */

#include "set_values.h"
/***********************************************************************
			    stuff_module.c

This file contains the routines that set all of the values in a hierarchy.
These implement the case where a user passes a module instance to 
$set_values.

The routines defined here:

   void stuff_module();
   void stuff_hierarchy();


**********************************************************************/
/***********************************************************************
			     STUFF MODULE

This routine will fill the storage elements in an entire hierarchy, based
upon a value string and a selection string.

  The value string is a string containing a binary value, it is tfarg 1.

  The selection string tells us whether we should fill all registers, UDPs
  or both.  The selection string can be "RU" , "UR", "R", or "U".  If the
  selection string is missing, then we assume "RU".  We checked the
  format of the selection string in set_check.

 ** This routine cannot work with memories, because we cannot yet get a
    handle to a memory with acc_next **


When we are passed the handle to a module, we set values in all the
storage elements below that level of hierarchy.  That means we fill
all the storage elements in the module, then all the storage elements
below that module.

This routine assumes that we want to store values in Registers and 
Sequential UDPs.  Then it checks the selection string to make sure this
assumption is correct.  It fills a search_list based upon the selection
string.

Once we have the search list we call stuff_hierarchy and pass it the
module handle and the search list.  

stuff_hierarchy sets the values in module it is called with, plus all
the modules below it.  It uses the search list to know which modules have
to be filled.

**********************************************************************/

void stuff_module(module, tfarg_numb)
     handle module;
     int *tfarg_numb;
{
  char *selection_string;



  void stuff_hierarchy();


  int search_list[3]; 
  
  search_list[0] = accRegister; /* Fill the search list using the assumption
  search_list[1] = accSeqPrim;     that the selection string is "RU" or "UR"
  search_list[2] = 0;           */

  if (tf_typep((*tfarg_numb)+1)==tf_string) /* Check for a selection string */
    {                                       /* If one exists then fetch it */
      selection_string = 
	strtoupper(acc_fetch_tfarg_str ((*tfarg_numb)+1));
      if (strlen(selection_string) == 1) /* If the string is "R" or "U" */
	{                                /* it will have a length of 1  */
	  switch (selection_string[0])   
	    {                            /* Modify the search list        */
	    case 'R':                    /* based on the selection string */
	      search_list[0] = accRegister;
	      break;
	    case 'U':
	      search_list[0] = accSeqPrim;
	      break;
	    default:
	      tf_message(ERR_ERROR, "Verilog", "BADSEL", 
			 "Error in stuff_module: Bad selection char");
	    }
	  search_list[1] = 0; /* The search list is only one element long */

	}
     (*tfarg_numb)++; /* Move the tfarg pointer beyond the selection string */
    }

  stuff_hierarchy(module, search_list); /* Stuff the hierarchy */
}

/***********************************************************************
			   STUFF HIERARCHY

This routine will fill storage elements in a hierarchy with a value
specified by the value string in tfarg 1.  It uses a search list filled
with access routine type constants to tell which objects must have
their values changed.

The routine works by calling acc_next and passing it the search_list.
As acc_next returns handles, stuff_hierarchy checks their types and
calls stuff_udp or stuff_register as is appropriate.

Once it's done with the storage elements in this module, it goes through 
all the children of the module and calls stuff_hierarchy for each one 
of them.
**********************************************************************/
void stuff_hierarchy(module, search_list)
     handle module;  /* The module that is the top of the hierarchy */
     int    search_list[]; /* an array of fulltypes used by acc_next
			      it tells us what objects to stuff     */
{
  handle 
    object_to_stuff, /* One of the objects that we will set with a new value */
    child;           /* A child module of this top module */
  void 
    stuff_hierarchy(), /* This module again, recursively called on children */
    stuff_udp(),       /* Puts the new value in a UDP.  See stuff_udp.c */
    stuff_register();  /* Puts new value into register. See stuff_register.c */

  object_to_stuff = null; /* Start going through objects */
  while ((object_to_stuff = 
	  acc_next(search_list, module, object_to_stuff)) != null)
    {
      switch (acc_fetch_fulltype(object_to_stuff)) /* check object type */
	{
	case accSeqPrim:
	  stuff_udp(object_to_stuff);
	  break;
	case accRegister:
	  stuff_register(object_to_stuff);
	  break;
	default: 
	  tf_message(ERR_ERROR, "Verilog", "BADOBJ",
		     "Error in stuff_module: Bad Object from acc_next");
	}
    }
  
  child = null;             /* Start going through children */
  while ((child = acc_next_child(module, child))!=null)
    stuff_hierarchy(child, search_list);
}
