`celldefine
module dflop (d, c, r, q); 

  input d, c, r;
  output q;

  nand #1   
            nand_2 (n2, d_, c_),
            nand_3 (n3, n1, n4),   
            nand_7 (q, n5, q_);
 
  nand #0   nand_1 (n1, d, c_, r),
            nand_4 (n4, n2, n3, r),
            nand_5 (n5, n3, c),
            nand_6 (n6, n4, c),
            nand_8 (q_, n6, r, q);  

  not  #0   inv_1 (c_, c),
            inv_2 (d_, d);

endmodule  
`endcelldefine


module lfsr100 (a1, clk, reset, b1);

  input a1, clk, reset;
  output b1;

  dflop dflop_1 (x1, clk, reset, q1),
        dflop_2 (q1, clk, reset, q2),
        dflop_3 (q2, clk, reset, q3),
        dflop_4 (q3, clk, reset, q4),
        dflop_5 (q4, clk, reset, q5),
        dflop_6 (q5, clk, reset, q6),
        dflop_7 (q6, clk, reset, q7),
        dflop_8 (q7, clk, reset, q8),
        dflop_9 (q8, clk, reset, q9),
        dflop_10 (q9, clk, reset, b1);  

  xnor  xnor_1 (x1, q7, a1);

endmodule


module lfsr1000 (a2, clk, reset, b2);

  input a2, clk, reset;
  output b2;

  lfsr100 lfsr100_1 (x2, clk, reset, q1),
          lfsr100_2 (q1, clk, reset, q2),
          lfsr100_3 (q2, clk, reset, q3),
          lfsr100_4 (q3, clk, reset, q4),
          lfsr100_5 (q4, clk, reset, q5),
          lfsr100_6 (q5, clk, reset, q6),
          lfsr100_7 (q6, clk, reset, q7),
          lfsr100_8 (q7, clk, reset, q8),
          lfsr100_9 (q8, clk, reset, q9),
          lfsr100_10 (q9, clk, reset, b2); 

  xnor    xnor_1 (x2, q7, a2);

endmodule  


module lfsr5000 (a3, clk, reset, b3);

  input a3, clk, reset;
  output b3;

  lfsr1000 lfsr1000_1 (x3, clk, reset, q1),
           lfsr1000_2 (q1, clk, reset, q2),
           lfsr1000_3 (q2, clk, reset, q3),
           lfsr1000_4 (q3, clk, reset, q4),
           lfsr1000_5 (q4, clk, reset, b3);  

  xnor     xnor_1 (x3, q3, a3);
                   
endmodule  

          
module lfsr10000 (a4, clk, reset, b4);

  input a4, clk, reset;
  output b4;

  lfsr5000 lfsr5000_1 (x4, clk, reset, q1),
           lfsr5000_2 (q1, clk, reset, b4); 

  xnor     xnor_1 (x4, q1, a4);
                   
endmodule  


module stimulus;

  reg clk, reset;  

  parameter period = 10, cycles = 1000;  

  lfsr10000 lfsr_1 (a4, clk, reset, b4);

  buf g1(a4,b4);

  initial
  begin
     repeat(cycles) @(posedge clk);
     $finish(2);
  end

  initial
    begin
      clk = 0;
      forever 
        #(period/2) clk = !clk;
    end

  initial
    begin
      reset = 0;
      #period
      reset = 1;
    end 

  // toggle test
  initial
    begin
      $toggle_test(lfsr_1);
      forever
        begin
          repeat (10) 
            @(posedge clk) ;
          $toggle_test_summary;
        end
    end
endmodule
