/* toggle_reports.c
 *
 * This file contains the routines associated with the system task that
 * allows users to retrieve and output toggle test result information.
 *
 */

#include <stdio.h>
#include "veriuser.h"
#include "acc_user.h"
#include "tt_toggle.h"
#include "tt_routines.h"


/* tg_summary_call()
 *
 * This routine prints summary toggle test information.
 *
 */
int tg_summary_call()
{
   double net_pct;
   double port_bit_pct;

   /* process the buffer to ensure data is current */
   tg_process_buffer();

   /* calculate statistics */
   net_pct = (double) (((double) tg_toggled_nets)/((double) tg_num_mon_nets))*100.0;
   port_bit_pct = (double) (((double) tg_toggled_port_bits)/((double) tg_num_mon_port_bits))*100.0;

   /* print summary report to standard output and to the log file */
   io_printf("\n");
   io_printf("*** TOGGLE TEST SUMMARY ***\n");
   io_printf("   # monitored simulated nets - %d\n",tg_num_mon_nets);
   io_printf("                    # toggled - %d\n",tg_toggled_nets);
   io_printf("                    %% toggled - %lf%%\n\n",net_pct);     
   io_printf("   # monitored port bits      - %d\n",tg_num_mon_port_bits);
   io_printf("               # toggled      - %d\n",tg_toggled_port_bits);
   io_printf("               %% toggled      - %lf%%\n\n",port_bit_pct);

   return 0;
}
